/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.provider;

import com.sun.enterprise.security.provider.PolicyConfigurationFactoryImpl;
import com.sun.enterprise.security.provider.PolicyConfigurationImpl;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextException;
import sun.security.provider.PolicyFile;

public final class PolicyWrapper
extends Policy {
    private Policy policy = new PolicyFile();
    private static Logger logger = Logger.getLogger("javax.enterprise.system.core.security");
    private static final String REUSE = "java.security.Policy.supportsReuse";

    public PermissionCollection getPermissions(CodeSource codesource) {
        String contextId = PolicyContext.getContextID();
        PolicyConfigurationImpl pci = PolicyWrapper.getPolicyConfigForContext(contextId);
        Policy appPolicy = this.getPolicy(pci);
        PermissionCollection perms = appPolicy.getPermissions(codesource);
        if (perms != null) {
            perms = PolicyWrapper.removeExcludedPermissions(pci, perms);
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("JACC Policy Provider: PolicyWrapper.getPermissions(cs), context (" + contextId + ") codesource (" + codesource + ") permissions: " + perms);
        }
        return perms;
    }

    public PermissionCollection getPermissions(ProtectionDomain domain) {
        String contextId = PolicyContext.getContextID();
        PolicyConfigurationImpl pci = PolicyWrapper.getPolicyConfigForContext(contextId);
        Policy appPolicy = this.getPolicy(pci);
        PermissionCollection perms = appPolicy.getPermissions(domain);
        if (perms != null) {
            perms = PolicyWrapper.removeExcludedPermissions(pci, perms);
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("JACC Policy Provider: PolicyWrapper.getPermissions(d), context (" + contextId + ") permissions: " + perms);
        }
        return perms;
    }

    public boolean implies(ProtectionDomain domain, Permission permission) {
        Permissions excluded;
        String contextId = PolicyContext.getContextID();
        PolicyConfigurationImpl pci = PolicyWrapper.getPolicyConfigForContext(contextId);
        Policy appPolicy = this.getPolicy(pci);
        boolean result = appPolicy.implies(domain, permission);
        if (result && (excluded = PolicyWrapper.getExcludedPolicy(pci)) != null) {
            boolean bl = result = !PolicyWrapper.grantedIsExcluded(permission, excluded);
        }
        if (logger.isLoggable(Level.FINEST) && !result) {
            logger.finest("JACC Policy Provider: PolicyWrapper.implies, context (" + contextId + ")- result was(" + result + ") permission (" + permission + ")");
        }
        return result;
    }

    public void refresh() {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("JACC Policy Provider: Refreshing Policy files!");
        }
        this.policy.refresh();
        Collection c = PolicyConfigurationFactoryImpl.getPolicyConfigurationImpls();
        if (c != null) {
            Iterator it = c.iterator();
            while (it.hasNext()) {
                PolicyConfigurationImpl pci = (PolicyConfigurationImpl)it.next();
                if (pci == null) continue;
                pci.refresh(false);
            }
        }
        try {
            if (PolicyContext.getHandlerKeys().contains(REUSE)) {
                PolicyContext.getContext((String)REUSE);
            }
        }
        catch (PolicyContextException pe) {
            throw new IllegalStateException(pe.toString());
        }
    }

    private static PolicyConfigurationImpl getPolicyConfigForContext(String contextId) {
        PolicyConfigurationImpl pci = null;
        if (contextId != null) {
            pci = PolicyConfigurationFactoryImpl.getPolicyConfigurationImpl(contextId);
        }
        return pci;
    }

    private Policy getPolicy(PolicyConfigurationImpl pci) {
        Policy result = null;
        if (pci == null) {
            result = this.policy;
        } else {
            result = pci.getPolicy();
            if (result == null) {
                result = this.policy;
            }
        }
        return result;
    }

    private static Permissions getExcludedPolicy(PolicyConfigurationImpl pci) {
        Permissions result = null;
        if (pci != null) {
            result = pci.getExcludedPolicy();
        }
        return result;
    }

    private static PermissionCollection removeExcludedPermissions(PolicyConfigurationImpl pci, PermissionCollection perms) {
        PermissionCollection result = perms;
        boolean noneRemoved = true;
        Permissions excluded = PolicyWrapper.getExcludedPolicy(pci);
        if (excluded != null && excluded.elements().hasMoreElements()) {
            result = null;
            Enumeration<Permission> enumeration = perms.elements();
            while (enumeration.hasMoreElements()) {
                Permission granted = enumeration.nextElement();
                if (!PolicyWrapper.grantedIsExcluded(granted, excluded)) {
                    if (result == null) {
                        result = new Permissions();
                    }
                    result.add(granted);
                    continue;
                }
                noneRemoved = false;
            }
            if (noneRemoved) {
                result = perms;
            }
        }
        return result;
    }

    private static boolean grantedIsExcluded(Permission granted, Permissions excluded) {
        boolean isExcluded = false;
        if (excluded != null) {
            if (!excluded.implies(granted)) {
                Enumeration<Permission> enumeration = excluded.elements();
                while (!isExcluded && enumeration.hasMoreElements()) {
                    Permission excludedPerm = enumeration.nextElement();
                    if (!granted.implies(excludedPerm)) continue;
                    isExcluded = true;
                }
            } else {
                isExcluded = true;
            }
        }
        if (logger.isLoggable(Level.FINEST) && isExcluded) {
            logger.finest("JACC Policy Provider: permission is excluded: " + granted);
        }
        return isExcluded;
    }
}

