/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.factory;

import com.sun.enterprise.SecurityManager;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.security.application.EJBSecurityManager;
import com.sun.enterprise.security.factory.AbstractSecurityManagerFactory;
import com.sun.enterprise.security.factory.SecurityManagerFactory;
import java.util.logging.Level;

public final class EJBSecurityManagerFactory
extends AbstractSecurityManagerFactory {
    private EJBSecurityManagerFactory() {
    }

    public static SecurityManagerFactory getInstance() {
        if (_theFactory == null) {
            _theFactory = new EJBSecurityManagerFactory();
        }
        return _theFactory;
    }

    public SecurityManager getSecurityManager(String contextId) {
        if (this._poolHas(contextId)) {
            return this._poolGet(contextId);
        }
        return null;
    }

    public SecurityManager createSecurityManager(Descriptor descriptor) {
        EJBSecurityManager ejbSM = null;
        String contextId = null;
        try {
            ejbSM = EJBSecurityManager.getInstance(descriptor);
            EjbDescriptor ejbdes = (EjbDescriptor)descriptor;
            contextId = ejbdes.getApplication().getRegistrationName();
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "[EJB-Security] EJB Security:Creating EJBSecurityManager for contextId = " + contextId);
            }
        }
        catch (Exception e) {
            _logger.log(Level.FINE, "[EJB-Security] FATAl Exception. Unable to create EJBSecurityManager: " + e.getMessage());
            throw new RuntimeException(e);
        }
        this._poolPut(contextId, ejbSM);
        return ejbSM;
    }
}

