/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.auth.realm;

import com.sun.enterprise.security.auth.realm.AuthenticationHandler;
import com.sun.enterprise.security.auth.realm.BadRealmException;
import com.sun.enterprise.security.auth.realm.InvalidOperationException;
import com.sun.enterprise.security.auth.realm.NoSuchRealmException;
import com.sun.enterprise.security.auth.realm.NoSuchUserException;
import com.sun.enterprise.security.auth.realm.User;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public abstract class Realm
implements Comparable {
    private static LocalStringManagerImpl localStrings;
    private static Hashtable loadedRealms;
    private String myName;
    private static String defaultRealmName;
    private static final String RI_DEFAULT = "default";
    private Properties ctxProps = new Properties();
    static final /* synthetic */ boolean $assertionsDisabled;

    public final String getName() {
        return this.myName;
    }

    protected final void setName(String name) {
        if (this.myName != null) {
            return;
        }
        this.myName = name;
    }

    public String toString() {
        return this.myName;
    }

    public int compareTo(Object realm) {
        if (!(realm instanceof Realm)) {
            return 1;
        }
        Realm r = (Realm)realm;
        String str = r.getAuthType();
        int temp = this.getAuthType().compareTo(str);
        if (temp != 0) {
            return temp;
        }
        str = r.getName();
        return this.getName().compareTo(str);
    }

    public static Realm instantiate(String name, String className, Properties props) throws BadRealmException {
        return Realm.doInstantiate(name, className, props);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Realm instantiate(String realmName, File f) throws NoSuchRealmException, BadRealmException, FileNotFoundException {
        Realm realm;
        if (!f.exists()) throw new FileNotFoundException();
        if (!f.isFile()) {
            throw new FileNotFoundException();
        }
        if (Realm._getInstance(realmName) != null) {
            throw new BadRealmException(localStrings.getLocalString("realm.already_exists", "This Realm already exists."));
        }
        FileInputStream in = null;
        Properties props = new Properties();
        try {
            try {
                in = new FileInputStream(f);
                props.load(in);
                String classname = props.getProperty("classname");
                if (!$assertionsDisabled && classname == null) {
                    throw new AssertionError();
                }
                realm = Realm.doInstantiate(realmName, classname, props);
                Object var7_7 = null;
                if (in == null) return realm;
            }
            catch (IOException e) {
                throw new BadRealmException(e.toString());
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (in == null) throw throwable;
            try {
                ((InputStream)in).close();
                throw throwable;
            }
            catch (Exception ex) {
                throw throwable;
            }
        }
        try {}
        catch (Exception ex) {
            // empty catch block
            return realm;
        }
        ((InputStream)in).close();
        return realm;
    }

    private static Realm doInstantiate(String name, String className, Properties props) throws BadRealmException {
        try {
            Class<?> realmClass = Class.forName(className);
            Object obj = realmClass.newInstance();
            Realm r = (Realm)obj;
            r.setName(name);
            r.init(props);
            loadedRealms.put(name, r);
            return r;
        }
        catch (Exception e) {
            throw new BadRealmException(e.toString());
        }
    }

    protected static void updateInstance(Realm realm, String name) {
        Realm oldRealm = (Realm)loadedRealms.get(name);
        if (!oldRealm.getClass().equals(realm.getClass())) {
            throw new Error("Incompatible class " + realm.getClass() + " in replacement realm " + name);
        }
        realm.setName(oldRealm.getName());
        loadedRealms.put(name, realm);
    }

    public static Realm getDefaultInstance() throws NoSuchRealmException {
        return Realm.getInstance(defaultRealmName);
    }

    public static String getDefaultRealm() {
        return defaultRealmName;
    }

    public static void setDefaultRealm(String realmName) {
        defaultRealmName = realmName;
    }

    static void unloadInstance(String realmName) throws NoSuchRealmException {
        Realm.getInstance(realmName);
        loadedRealms.remove(realmName);
    }

    public void setProperty(String name, String value) {
        this.ctxProps.setProperty(name, value);
    }

    public String getProperty(String name) {
        return this.ctxProps.getProperty(name);
    }

    protected Properties getProperties() {
        return this.ctxProps;
    }

    public String getJAASContext() {
        return this.ctxProps.getProperty("jaas-context");
    }

    public static Realm getInstance(String name) throws NoSuchRealmException {
        Realm retval = Realm._getInstance(name);
        if (retval == null) {
            throw new NoSuchRealmException(localStrings.getLocalString("realm.no_such_realm", name + " realm does not exist.", new Object[]{name}));
        }
        return retval;
    }

    private static Realm _getInstance(String name) {
        Realm retval = null;
        retval = (Realm)loadedRealms.get(name);
        if (retval == null && RI_DEFAULT.equals(name)) {
            retval = (Realm)loadedRealms.get(defaultRealmName);
        }
        return retval;
    }

    public static Enumeration getRealmNames() {
        return loadedRealms.keys();
    }

    protected Realm() {
    }

    protected void init(Properties props) throws BadRealmException, NoSuchRealmException {
    }

    public abstract String getAuthType();

    public abstract AuthenticationHandler getAuthenticationHandler();

    public abstract Enumeration getUserNames() throws BadRealmException;

    public abstract User getUser(String var1) throws NoSuchUserException, BadRealmException;

    public abstract Enumeration getGroupNames() throws BadRealmException;

    public abstract Enumeration getGroupNames(String var1) throws InvalidOperationException, NoSuchUserException;

    public abstract void refresh() throws BadRealmException;

    public static boolean isValidRealm(String name) {
        if (name == null) {
            return false;
        }
        return loadedRealms.containsKey(name);
    }

    static {
        $assertionsDisabled = !Realm.class.desiredAssertionStatus();
        localStrings = new LocalStringManagerImpl(Realm.class);
        loadedRealms = new Hashtable();
        defaultRealmName = RI_DEFAULT;
    }
}

