/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.application;

import com.sun.ejb.Invocation;
import com.sun.enterprise.ComponentInvocation;
import com.sun.enterprise.InvocationException;
import com.sun.enterprise.InvocationManager;
import com.sun.enterprise.SecurityManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbIORConfigurationDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.MethodPermission;
import com.sun.enterprise.deployment.RunAsIdentityDescriptor;
import com.sun.enterprise.deployment.web.SecurityRoleReference;
import com.sun.enterprise.security.CachedPermission;
import com.sun.enterprise.security.CachedPermissionImpl;
import com.sun.enterprise.security.PermissionCache;
import com.sun.enterprise.security.PermissionCacheFactory;
import com.sun.enterprise.security.SecurityContext;
import com.sun.enterprise.security.audit.AuditManager;
import com.sun.enterprise.security.audit.AuditManagerFactory;
import com.sun.enterprise.security.auth.LoginContextDriver;
import com.sun.enterprise.security.authorize.PolicyContextHandlerImpl;
import com.sun.enterprise.security.factory.FactoryForSecurityManagerFactory;
import com.sun.enterprise.security.factory.FactoryForSecurityManagerFactoryImpl;
import com.sun.enterprise.security.factory.SecurityManagerFactory;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessControlContext;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.SubjectDomainCombiner;
import javax.security.jacc.EJBMethodPermission;
import javax.security.jacc.EJBRoleRefPermission;
import javax.security.jacc.PolicyConfiguration;
import javax.security.jacc.PolicyConfigurationFactory;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextException;

public final class EJBSecurityManager
implements SecurityManager {
    private static Logger _logger;
    private static LocalStringManagerImpl localStrings;
    private static AuditManager auditManager;
    private static final PolicyContextHandlerImpl pcHandlerImpl;
    private EjbDescriptor deploymentDescriptor = null;
    private Switch theSwitch;
    private RunAsIdentityDescriptor runAs = null;
    private static PolicyConfigurationFactory pcf;
    private String ejbName = null;
    private String contextId = null;
    private String codebase = null;
    private CodeSource codesource = null;
    private String realmName = null;
    private Hashtable cacheRoleToPerm = new Hashtable();
    private Map cacheProtectionDomain = Collections.synchronizedMap(new WeakHashMap());
    private Map protectionDomainCache = Collections.synchronizedMap(new WeakHashMap());
    private Map accessControlContextCache = Collections.synchronizedMap(new WeakHashMap());
    private PermissionCache uncheckedMethodPermissionCache = null;
    private Policy policy = null;
    private static CodeSource managerCodeSource;
    private boolean isMdb;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static EJBSecurityManager getInstance(Descriptor des) throws Exception {
        return new EJBSecurityManager(des);
    }

    private EJBSecurityManager(Descriptor ejbDescriptor) throws Exception {
        boolean runas;
        if (ejbDescriptor == null || !(ejbDescriptor instanceof EjbDescriptor)) {
            throw new IllegalArgumentException("Illegal Deployment Descriptor Information.");
        }
        this.deploymentDescriptor = (EjbDescriptor)ejbDescriptor;
        this.isMdb = "Message-driven".equals(this.deploymentDescriptor.getType());
        this.policy = Policy.getPolicy();
        boolean bl = runas = !this.deploymentDescriptor.getUsesCallerIdentity();
        if (runas) {
            this.runAs = this.deploymentDescriptor.getRunAsIdentity();
            if (this.runAs != null && _logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, this.deploymentDescriptor.getEjbClassName() + " will run-as: " + this.runAs.getPrincipal() + " (" + this.runAs.getRoleName() + ")");
            }
        }
        this.theSwitch = Switch.getSwitch();
        this.initialize();
    }

    private static CodeSource getApplicationCodeSource(String pcid) throws Exception {
        CodeSource result = null;
        String archiveURI = "file:///" + pcid.replace(' ', '_');
        try {
            URI uri = null;
            try {
                uri = new URI(archiveURI);
                if (uri != null) {
                    result = new CodeSource(uri.toURL(), null);
                }
            }
            catch (URISyntaxException use) {
                _logger.log(Level.SEVERE, "JACC: Error Creating URI ", use);
                throw new RuntimeException(use);
            }
        }
        catch (MalformedURLException mue) {
            _logger.log(Level.SEVERE, "JACC: ejbsm.codesourceerror", mue);
            throw new RuntimeException(mue);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PolicyConfigurationFactory getPolicyFactory() throws PolicyContextException {
        Class clazz = EJBSecurityManager.class;
        synchronized (clazz) {
            if (pcf == null) {
                try {
                    pcf = PolicyConfigurationFactory.getPolicyConfigurationFactory();
                }
                catch (ClassNotFoundException cnfe) {
                    _logger.severe("jaccfactory.notfound");
                    throw new PolicyContextException((Throwable)cnfe);
                }
                catch (PolicyContextException pce) {
                    _logger.severe("jaccfactory.notfound");
                    throw pce;
                }
            }
        }
        return pcf;
    }

    public boolean getUsesCallerIdentity() {
        return this.runAs == null;
    }

    public static void loadPolicyConfiguration(EjbDescriptor eDescriptor) throws Exception {
        String pcid = eDescriptor.getApplication().getRegistrationName();
        boolean inService = EJBSecurityManager.getPolicyFactory().inService(pcid);
        if (!inService) {
            EJBSecurityManager.convertEJBMethodPermissions(eDescriptor, pcid);
            EJBSecurityManager.convertEJBRoleReferences(eDescriptor, pcid);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("JACC: policy translated for policy context:" + pcid);
            }
        }
    }

    private void initialize() throws Exception {
        Set iorConfigs;
        Iterator iter;
        this.contextId = this.deploymentDescriptor.getApplication().getRegistrationName();
        this.codesource = EJBSecurityManager.getApplicationCodeSource(this.contextId);
        this.ejbName = this.deploymentDescriptor.getName();
        this.realmName = this.deploymentDescriptor.getApplication().getRealm();
        if (this.realmName == null && (iter = (iorConfigs = this.deploymentDescriptor.getIORConfigurationDescriptors()).iterator()) != null) {
            while (iter.hasNext()) {
                EjbIORConfigurationDescriptor iorConfig = (EjbIORConfigurationDescriptor)iter.next();
                this.realmName = iorConfig.getRealmName();
            }
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("JACC: Context id (id under which all EJB's in application will be created) = " + this.contextId);
            _logger.fine("Codebase (module id for ejb " + this.ejbName + ") = " + this.codebase);
        }
        this.addEJBRoleReferenceToCache(this.deploymentDescriptor);
        this.uncheckedMethodPermissionCache = PermissionCacheFactory.createPermissionCache(this.contextId, this.codesource, new Class[]{EJBMethodPermission.class}, this.ejbName);
    }

    private static void convertEJBRoleReferences(EjbDescriptor eDescriptor, String pcid) throws PolicyContextException {
        PolicyConfiguration pc = EJBSecurityManager.getPolicyFactory().getPolicyConfiguration(pcid, false);
        if (!$assertionsDisabled && pc == null) {
            throw new AssertionError();
        }
        if (pc != null) {
            String eName = eDescriptor.getName();
            Iterator iroleref = eDescriptor.getRoleReferences().iterator();
            while (iroleref.hasNext()) {
                SecurityRoleReference roleRef = (SecurityRoleReference)iroleref.next();
                String rolename = roleRef.getRolename();
                EJBRoleRefPermission ejbrr = new EJBRoleRefPermission(eName, rolename);
                String rolelink = roleRef.getSecurityRoleLink().getName();
                pc.addToRole(rolelink, (Permission)ejbrr);
                if (!_logger.isLoggable(Level.FINE)) continue;
                _logger.fine("JACC: Converting role-ref -> " + roleRef.toString() + " to permission with name(" + ejbrr.getName() + ") and actions (" + ejbrr.getActions() + ")" + "mapped to role (" + rolelink + ")");
            }
        }
    }

    private void addEJBRoleReferenceToCache(EjbDescriptor eDescriptor) {
        String eName = eDescriptor.getName();
        Iterator iroleref = eDescriptor.getRoleReferences().iterator();
        while (iroleref.hasNext()) {
            SecurityRoleReference roleRef = (SecurityRoleReference)iroleref.next();
            String rolename = roleRef.getRolename();
            EJBRoleRefPermission ejbrr = new EJBRoleRefPermission(eName, rolename);
            String rolelink = roleRef.getSecurityRoleLink().getName();
            this.cacheRoleToPerm.put(eName + "_" + rolename, ejbrr);
            if (!_logger.isLoggable(Level.FINE)) continue;
            _logger.fine("JACC: Converting role-ref -> " + roleRef.toString() + " to permission with name(" + ejbrr.getName() + ") and actions (" + ejbrr.getActions() + ")" + "mapped to role (" + rolelink + ")");
        }
    }

    private static HashMap addToRolePermissionsTable(HashMap table, MethodPermission mp, EJBMethodPermission ejbmp) {
        if (mp.isRoleBased()) {
            String roleName;
            Permissions rolePermissions;
            if (table == null) {
                table = new HashMap<String, Permissions>();
            }
            if ((rolePermissions = (Permissions)table.get(roleName = mp.getRole().getName())) == null) {
                rolePermissions = new Permissions();
                table.put(roleName, rolePermissions);
            }
            rolePermissions.add((Permission)ejbmp);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("JACC DD conversion: EJBMethodPermission ->(" + ejbmp.getName() + " " + ejbmp.getActions() + ")protected by role -> " + roleName);
            }
        }
        return table;
    }

    private static Permissions addToUncheckedPermissions(Permissions permissions, MethodPermission mp, EJBMethodPermission ejbmp) {
        if (mp.isUnchecked()) {
            if (permissions == null) {
                permissions = new Permissions();
            }
            permissions.add((Permission)ejbmp);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("JACC DD conversion: EJBMethodPermission ->(" + ejbmp.getName() + " " + ejbmp.getActions() + ") is (unchecked)");
            }
        }
        return permissions;
    }

    private static Permissions addToExcludedPermissions(Permissions permissions, MethodPermission mp, EJBMethodPermission ejbmp) {
        if (mp.isExcluded()) {
            if (permissions == null) {
                permissions = new Permissions();
            }
            permissions.add((Permission)ejbmp);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("JACC DD conversion: EJBMethodPermission ->(" + ejbmp.getName() + " " + ejbmp.getActions() + ") is (excluded)");
            }
        }
        return permissions;
    }

    private static void convertEJBMethodPermissions(EjbDescriptor eDescriptor, String pcid) throws PolicyContextException {
        PolicyConfiguration pc = EJBSecurityManager.getPolicyFactory().getPolicyConfiguration(pcid, false);
        if (!$assertionsDisabled && pc == null) {
            throw new AssertionError();
        }
        if (pc != null) {
            String eName = eDescriptor.getName();
            Permissions uncheckedPermissions = null;
            Permissions excludedPermissions = null;
            HashMap rolePermissionsTable = null;
            EJBMethodPermission ejbmp = null;
            HashMap mpMap = eDescriptor.getMethodPermissionsFromDD();
            if (mpMap != null) {
                Iterator mpIt = mpMap.keySet().iterator();
                while (mpIt.hasNext()) {
                    MethodPermission mp = (MethodPermission)mpIt.next();
                    Iterator mdIt = ((ArrayList)mpMap.get(mp)).iterator();
                    while (mdIt.hasNext()) {
                        MethodDescriptor md = (MethodDescriptor)mdIt.next();
                        String mthdName = md.getName();
                        String mthdIntf = md.getEjbClassSymbol();
                        String[] mthdParams = md.getStyle() == 3 ? md.getParameterClassNames() : null;
                        ejbmp = new EJBMethodPermission(eName, mthdName.equals("*") ? null : mthdName, mthdIntf, mthdParams);
                        rolePermissionsTable = EJBSecurityManager.addToRolePermissionsTable(rolePermissionsTable, mp, ejbmp);
                        uncheckedPermissions = EJBSecurityManager.addToUncheckedPermissions(uncheckedPermissions, mp, ejbmp);
                        excludedPermissions = EJBSecurityManager.addToExcludedPermissions(excludedPermissions, mp, ejbmp);
                    }
                }
            }
            Iterator mdIt = eDescriptor.getMethodDescriptors().iterator();
            while (mdIt.hasNext()) {
                MethodDescriptor md = (MethodDescriptor)mdIt.next();
                Method mthd = md.getMethod(eDescriptor);
                String mthdIntf = md.getEjbClassSymbol();
                if (mthd == null) continue;
                if (mthdIntf == null || mthdIntf.equals("")) {
                    _logger.severe("MethodDescriptor interface not defined -  ejbName: " + eName + " methodName: " + md.getName() + " methodParams: " + md.getParameterClassNames());
                    continue;
                }
                ejbmp = new EJBMethodPermission(eName, mthdIntf, mthd);
                Iterator mpIt = eDescriptor.getMethodPermissionsFor(md).iterator();
                while (mpIt.hasNext()) {
                    MethodPermission mp = (MethodPermission)mpIt.next();
                    rolePermissionsTable = EJBSecurityManager.addToRolePermissionsTable(rolePermissionsTable, mp, ejbmp);
                    uncheckedPermissions = EJBSecurityManager.addToUncheckedPermissions(uncheckedPermissions, mp, ejbmp);
                    excludedPermissions = EJBSecurityManager.addToExcludedPermissions(excludedPermissions, mp, ejbmp);
                }
            }
            if (uncheckedPermissions != null) {
                pc.addToUncheckedPolicy(uncheckedPermissions);
            }
            if (excludedPermissions != null) {
                pc.addToExcludedPolicy(excludedPermissions);
            }
            if (rolePermissionsTable != null) {
                Iterator roleIt = rolePermissionsTable.keySet().iterator();
                while (roleIt.hasNext()) {
                    String roleName = (String)roleIt.next();
                    pc.addToRole(roleName, (PermissionCollection)((Permissions)rolePermissionsTable.get(roleName)));
                }
            }
        }
    }

    private ProtectionDomain getCachedProtectionDomain(Set principalSet, boolean applicationCodeSource) {
        ProtectionDomain prdm = null;
        Principal[] principals = null;
        CodeSource cs = null;
        if (applicationCodeSource) {
            prdm = (ProtectionDomain)this.cacheProtectionDomain.get(principalSet);
            cs = this.codesource;
        } else {
            prdm = (ProtectionDomain)this.protectionDomainCache.get(principalSet);
            cs = managerCodeSource;
        }
        if (prdm == null) {
            principals = principalSet == null ? null : principalSet.toArray(new Principal[0]);
            prdm = new ProtectionDomain(cs, null, null, principals);
            if (applicationCodeSource) {
                this.cacheProtectionDomain.put(new HashSet(principalSet), prdm);
            } else {
                this.protectionDomainCache.put(new HashSet(principalSet), prdm);
            }
            _logger.fine("JACC: new ProtectionDomain added to cache");
        }
        if (_logger.isLoggable(Level.FINE)) {
            if (principalSet == null) {
                _logger.fine("JACC: returning cached ProtectionDomain PrincipalSet: null");
            } else {
                StringBuffer pBuf = null;
                principals = principalSet.toArray(new Principal[0]);
                for (int i = 0; i < principals.length; ++i) {
                    if (i == 0) {
                        pBuf = new StringBuffer(((Object)principals[i]).toString());
                        continue;
                    }
                    pBuf.append(" " + ((Object)principals[i]).toString());
                }
                _logger.fine("JACC: returning cached ProtectionDomain - CodeSource: (" + cs + ") PrincipalSet: " + pBuf);
            }
        }
        return prdm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean authorize(Invocation inv) {
        boolean ret = false;
        CachedPermission cp = null;
        Object ejbmp = null;
        if (inv.invocationInfo == null || inv.invocationInfo.cachedPermission == null) {
            ejbmp = new EJBMethodPermission(this.ejbName, inv.getMethodInterface(), inv.method);
            cp = new CachedPermissionImpl(this.uncheckedMethodPermissionCache, (Permission)ejbmp);
            if (inv.invocationInfo != null) {
                inv.invocationInfo.cachedPermission = cp;
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("JACC: permission initialized in InvocationInfo: EJBMethodPermission (Name) = " + ((Permission)ejbmp).getName() + " (Action) = " + ((Permission)ejbmp).getActions());
                }
            }
        } else {
            cp = inv.invocationInfo.cachedPermission;
            ejbmp = cp.getPermission();
        }
        String caller = null;
        SecurityContext sc = null;
        ret = cp.checkPermission();
        if (!ret) {
            pcHandlerImpl.getHandlerData().setInvocation(inv);
            sc = SecurityContext.getCurrent();
            Set principalSet = sc.getPrincipalSet();
            ProtectionDomain prdm = this.getCachedProtectionDomain(principalSet, true);
            try {
                String oldContextId = EJBSecurityManager.setPolicyContext(this.contextId);
                try {
                    ret = this.policy.implies(prdm, (Permission)ejbmp);
                }
                catch (SecurityException se) {
                    _logger.log(Level.SEVERE, "JACC: Unexpected security exception on access decision", se);
                    ret = false;
                }
                catch (Throwable t) {
                    _logger.log(Level.SEVERE, "JACC: Unexpected exception on access decision", t);
                    ret = false;
                }
                finally {
                    EJBSecurityManager.resetPolicyContext(oldContextId, this.contextId);
                }
            }
            catch (Throwable t) {
                _logger.log(Level.SEVERE, "JACC: Unexpected exception manipulating policy context", t);
                ret = false;
            }
        }
        if (auditManager.isAuditOn()) {
            if (sc == null) {
                sc = SecurityContext.getCurrent();
            }
            caller = sc.getCallerPrincipal().getName();
            auditManager.ejbInvocation(caller, this.ejbName, inv.method.toString(), ret);
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("JACC: Access Control Decision Result: " + ret + " EJBMethodPermission (Name) = " + ((Permission)ejbmp).getName() + " (Action) = " + ((Permission)ejbmp).getActions() + " (Caller) = " + caller);
        }
        return ret;
    }

    private boolean areMethodPermissionsSet() {
        boolean empty = this.deploymentDescriptor.getPermissionedMethodsByPermission().isEmpty();
        return !empty;
    }

    public void preInvoke(ComponentInvocation inv) {
        if (this.isMdb) {
            SecurityContext.setUnauthenticatedContext();
        }
        if (this.runAs != null) {
            inv.setOldSecurityContext(SecurityContext.getCurrent());
            this.loginForRunAs();
        }
    }

    public void postInvoke(ComponentInvocation inv) {
        if (this.runAs != null) {
            final ComponentInvocation finv = inv;
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    SecurityContext.setCurrent(finv.getOldSecurityContext());
                    return null;
                }
            });
        }
    }

    private void loginForRunAs() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                LoginContextDriver.loginPrincipal(EJBSecurityManager.this.runAs.getPrincipal(), EJBSecurityManager.this.realmName);
                return null;
            }
        });
    }

    public boolean isCallerInRole(String role) {
        SecurityContext sc;
        EJBRoleRefPermission ejbrr;
        boolean ret = false;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.entering("EJBSecurityManager", "isCallerInRole", role);
        }
        if ((ejbrr = (EJBRoleRefPermission)this.cacheRoleToPerm.get(this.ejbName + "_" + role)) == null) {
            ejbrr = new EJBRoleRefPermission(this.ejbName, role);
        }
        if (this.runAs != null) {
            InvocationManager im = this.theSwitch.getInvocationManager();
            ComponentInvocation ci = im.getCurrentInvocation();
            sc = ci.getOldSecurityContext();
        } else {
            sc = SecurityContext.getCurrent();
        }
        Set principalSet = null;
        if (sc != null) {
            principalSet = sc.getPrincipalSet();
        }
        ProtectionDomain prdm = this.getCachedProtectionDomain(principalSet, true);
        try {
            ret = this.policy.implies(prdm, (Permission)ejbrr);
        }
        catch (SecurityException se) {
            _logger.log(Level.SEVERE, "JACC: Unexpected security exception isCallerInRole", se);
            ret = false;
        }
        catch (Throwable t) {
            _logger.log(Level.SEVERE, "JACC: Unexpected exception isCallerInRole", t);
            ret = false;
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("JACC: isCallerInRole Result: " + ret + " EJBRoleRefPermission (Name) = " + ejbrr.getName() + " (Action) = " + ejbrr.getActions() + " (Codesource) = " + prdm.getCodeSource());
        }
        return ret;
    }

    public Principal getCallerPrincipal() {
        SecurityContext sc = null;
        if (this.runAs != null) {
            InvocationManager im = this.theSwitch.getInvocationManager();
            ComponentInvocation ci = im.getCurrentInvocation();
            if (ci == null) {
                throw new InvocationException();
            }
            sc = ci.getOldSecurityContext();
        } else {
            sc = SecurityContext.getCurrent();
        }
        Principal prin = sc != null ? sc.getCallerPrincipal() : SecurityContext.getDefaultCallerPrincipal();
        return prin;
    }

    public void destroy() {
        try {
            PolicyConfigurationFactory pcf = EJBSecurityManager.getPolicyFactory();
            boolean wasInService = pcf.inService(this.contextId);
            PolicyConfiguration pc = pcf.getPolicyConfiguration(this.contextId, false);
            if (wasInService) {
                this.policy.refresh();
                PermissionCacheFactory.removePermissionCache(this.uncheckedMethodPermissionCache);
                this.uncheckedMethodPermissionCache = null;
            }
        }
        catch (PolicyContextException pce) {
            String msg = localStrings.getLocalString("ejbsm.could_not_delete", "Could not delete policy file during undeployment");
            _logger.log(Level.WARNING, msg, pce);
        }
        FactoryForSecurityManagerFactory ffsmf = FactoryForSecurityManagerFactoryImpl.getInstance();
        SecurityManagerFactory smf = ffsmf.getSecurityManagerFactory("ejb");
        smf.removeSecurityManager(this.contextId);
    }

    public Subject getCurrentSubject() {
        return SecurityContext.getCurrent().getSubject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object doAsPrivileged(PrivilegedExceptionAction pea) throws Throwable {
        SecurityContext sc = SecurityContext.getCurrent();
        Set principalSet = sc.getPrincipalSet();
        AccessControlContext acc = (AccessControlContext)this.accessControlContextCache.get(principalSet);
        if (acc == null) {
            final ProtectionDomain[] pdArray = new ProtectionDomain[]{this.getCachedProtectionDomain(principalSet, false)};
            try {
                if (principalSet != null) {
                    final Subject s = sc.getSubject();
                    acc = (AccessControlContext)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            return new AccessControlContext(new AccessControlContext(pdArray), new SubjectDomainCombiner(s));
                        }
                    });
                } else {
                    acc = new AccessControlContext(pdArray);
                }
                this.accessControlContextCache.put(new HashSet(principalSet), acc);
                _logger.fine("JACC: new AccessControlContext added to cache");
            }
            catch (Exception e) {
                _logger.log(Level.SEVERE, "java_security.security_context_exception", e);
                acc = null;
                throw e;
            }
        }
        Object rvalue = null;
        String oldContextId = EJBSecurityManager.setPolicyContext(this.contextId);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("JACC: doAsPrivileged contextId(" + this.contextId + ")");
        }
        try {
            rvalue = AccessController.doPrivileged(pea, acc);
        }
        finally {
            EJBSecurityManager.resetPolicyContext(oldContextId, this.contextId);
        }
        return rvalue;
    }

    private static void resetPolicyContext(final String newV, String oldV) throws Throwable {
        if (!(oldV == newV || newV == null || oldV != null && oldV.equals(newV))) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("JACC: Changing Policy Context ID: oldV = " + oldV + " newV = " + newV);
            }
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        PolicyContext.setContextID((String)newV);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                Throwable cause = pae.getCause();
                if (cause instanceof AccessControlException) {
                    _logger.log(Level.SEVERE, "setPolicy SecurityPermission required to call PolicyContext.setContextID", cause);
                } else {
                    _logger.log(Level.SEVERE, "Unexpected Exception while setting PolicyContext", cause);
                }
                throw cause;
            }
        }
    }

    private static String setPolicyContext(String newV) throws Throwable {
        String oldV = PolicyContext.getContextID();
        EJBSecurityManager.resetPolicyContext(newV, oldV);
        return oldV;
    }

    static {
        $assertionsDisabled = !EJBSecurityManager.class.desiredAssertionStatus();
        _logger = null;
        _logger = LogDomains.getLogger("javax.enterprise.system.core.security");
        localStrings = new LocalStringManagerImpl(EJBSecurityManager.class);
        auditManager = AuditManagerFactory.getAuditManagerInstance();
        pcHandlerImpl = (PolicyContextHandlerImpl)PolicyContextHandlerImpl.getInstance();
        pcf = null;
        managerCodeSource = EJBSecurityManager.class.getProtectionDomain().getCodeSource();
    }
}

