/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security;

import com.sun.appserv.server.ServerLifecycleException;
import com.sun.appserv.server.ServerLifecycleImpl;
import com.sun.enterprise.J2EESecurityManager;
import com.sun.enterprise.security.PolicyLoader;
import com.sun.enterprise.security.RealmConfig;
import com.sun.enterprise.security.SSLUtils;
import com.sun.enterprise.security.audit.AuditManagerFactory;
import com.sun.enterprise.security.authorize.PolicyContextHandlerImpl;
import com.sun.enterprise.server.ServerContext;
import com.sun.logging.LogDomains;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextException;
import javax.security.jacc.PolicyContextHandler;

public class SecurityLifecycle
extends ServerLifecycleImpl {
    private static final Logger _logger = LogDomains.getLogger("javax.enterprise.system.core.security");

    public SecurityLifecycle() {
        try {
            File f;
            String serverPolicyFile = System.getProperty("java.security.policy");
            if (serverPolicyFile != null && (f = new File(serverPolicyFile)).canRead()) {
                J2EESecurityManager mgr = new J2EESecurityManager();
                System.setSecurityManager(mgr);
            }
        }
        catch (Exception ex) {
            _logger.log(Level.SEVERE, "java_security.init_securitylifecycle_fail", ex);
            throw new RuntimeException(ex.toString(), ex);
        }
    }

    public void onInitialization(ServerContext sc) throws ServerLifecycleException {
        try {
            SSLUtils.initStoresAtStartup();
            this.registerPolicyHandlers();
            PolicyLoader policyLoader = PolicyLoader.getInstance();
            policyLoader.loadPolicy();
            RealmConfig.createRealms();
            AuditManagerFactory amf = AuditManagerFactory.getInstance();
            amf.getAuditManagerInstance().loadAuditModules();
        }
        catch (Exception ex) {
            throw new ServerLifecycleException(ex);
        }
    }

    private void registerPolicyHandlers() throws PolicyContextException {
        PolicyContextHandler pch = PolicyContextHandlerImpl.getInstance();
        PolicyContext.registerHandler((String)"javax.ejb.EnterpriseBean", (PolicyContextHandler)pch, (boolean)true);
        PolicyContext.registerHandler((String)"javax.security.auth.Subject.container", (PolicyContextHandler)pch, (boolean)true);
        PolicyContext.registerHandler((String)"javax.ejb.arguments", (PolicyContextHandler)pch, (boolean)true);
        PolicyContext.registerHandler((String)"javax.xml.soap.SOAPMessage", (PolicyContextHandler)pch, (boolean)true);
        PolicyContext.registerHandler((String)"javax.servlet.http.HttpServletRequest", (PolicyContextHandler)pch, (boolean)true);
        PolicyContext.registerHandler((String)"java.security.Policy.supportsReuse", (PolicyContextHandler)pch, (boolean)true);
    }
}

