/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security;

import com.sun.enterprise.Switch;
import com.sun.enterprise.naming.NamingManagerImpl;
import com.sun.enterprise.security.IRealmManager;
import com.sun.enterprise.security.RealmConfig;
import com.sun.enterprise.security.auth.RemoteObject;
import com.sun.enterprise.security.auth.realm.Realm;
import com.sun.enterprise.util.ORBManager;
import com.sun.enterprise.util.Utility;
import com.sun.logging.LogDomains;
import java.rmi.RemoteException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;

public class RealmManager
extends RemoteObject
implements IRealmManager {
    private static Logger _logger = null;
    public static String REALM_MANAGER_NAME;

    public void init() throws NamingException, RemoteException {
        RealmConfig.createRealms();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws InterruptedException {
        Object sync;
        Object object = sync = new Object();
        synchronized (object) {
            sync.wait();
        }
    }

    public void refreshRealms(String realmName) throws RemoteException {
        try {
            Realm r = Realm.getInstance(realmName);
            r.refresh();
        }
        catch (Exception e) {
            throw new RemoteException(e.toString());
        }
    }

    public static void main(String[] args) {
        try {
            Utility.checkJVMVersion();
            ORBManager.init(args, null);
            Switch theSwitch = Switch.getSwitch();
            NamingManagerImpl nm = new NamingManagerImpl();
            theSwitch.setNamingManager(nm);
            RealmManager mgr = new RealmManager();
            mgr.init();
            mgr.start();
        }
        catch (Exception ex) {
            _logger.log(Level.SEVERE, "java_security.realm_manager_exception", ex);
        }
    }

    static {
        _logger = LogDomains.getLogger("javax.enterprise.system.core.security");
        REALM_MANAGER_NAME = "Realm_Manager";
    }
}

