/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.test;

import java.io.PrintStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.naming.InitialContext;
import javax.sql.DataSource;

public class JDBCConnectionPoolTest {
    public static String dsName = "jdbc/Vortex";
    public static String sql = "select * from rfx_requests";
    public static String userName = "vortex";
    public static String userPassword = "vortex";
    public static int iterations = 2;
    public static int sleepDuration = 1;
    public static int numOfThreads = 2;
    private static PrintStream commonLog = System.err;

    private static void log(String msg) {
        commonLog.println(msg);
    }

    protected void runTest() {
        JDBCConnectionPoolTest.log("\n\n\n***JDBCConnectionPoolTest***: Starting...");
        for (int i = 0; i < numOfThreads; ++i) {
            SimpleJDBCTest aTest = new SimpleJDBCTest(dsName, sql, userName, userPassword, iterations, sleepDuration, i);
            aTest.start();
        }
    }

    public static void main(String[] args) {
        try {
            JDBCConnectionPoolTest test = new JDBCConnectionPoolTest();
            test.runTest();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    class SimpleJDBCTest
    extends Thread {
        private String dsName;
        private String sql;
        private String userName;
        private String userPassword;
        private int iterations;
        private int sleepDuration;
        private int id;

        SimpleJDBCTest(String dsName, String sql, String userName, String userPassword, int iterations, int sleepDuration, int id) {
            this.dsName = dsName;
            this.sql = sql;
            this.userName = userName;
            this.userPassword = userPassword;
            this.iterations = iterations;
            this.sleepDuration = sleepDuration;
            this.id = id;
        }

        public void run() {
            JDBCConnectionPoolTest.log("* Start id: " + this.id);
            for (int i = 0; i < this.iterations; ++i) {
                this.test();
                try {
                    SimpleJDBCTest.sleep(this.sleepDuration);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            JDBCConnectionPoolTest.log("* End id: " + this.id);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        private void test() {
            block14: {
                Connection con = null;
                Statement st = null;
                JDBCConnectionPoolTest.log("About to getConnetion.");
                InitialContext ic = new InitialContext();
                JDBCConnectionPoolTest.log("About to getConnetion.1 + " + this.dsName);
                DataSource ds = (DataSource)ic.lookup(this.dsName);
                JDBCConnectionPoolTest.log("About to getConnetion.2 + " + this.userName);
                JDBCConnectionPoolTest.log("About to getConnetion.3 + " + this.userPassword);
                con = ds.getConnection(this.userName, this.userPassword);
                JDBCConnectionPoolTest.log("About to getConnetion.4 + " + con);
                JDBCConnectionPoolTest.log("About to getConnetion.5");
                st = con.createStatement();
                JDBCConnectionPoolTest.log("About to getConnetion.6");
                ResultSet rs = st.executeQuery(this.sql);
                JDBCConnectionPoolTest.log("got result.");
                this.readRS(rs);
                Object var7_7 = null;
                try {
                    if (st != null) {
                        st.close();
                    }
                    if (con != null) {
                        con.close();
                    }
                    break block14;
                }
                catch (Exception ex2) {}
                break block14;
                {
                    catch (Exception ex) {
                        JDBCConnectionPoolTest.log("\n\t Error in doTest()" + ex.getMessage());
                        ex.printStackTrace();
                        Object var7_8 = null;
                        try {
                            if (st != null) {
                                st.close();
                            }
                            if (con != null) {
                                con.close();
                            }
                            break block14;
                        }
                        catch (Exception ex2) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    try {
                        if (st != null) {
                            st.close();
                        }
                        if (con != null) {
                            con.close();
                        }
                    }
                    catch (Exception ex2) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }

        private void readRS(ResultSet rs) throws SQLException {
            while (rs.next()) {
                rs.getObject(1);
                rs.getObject(2);
                rs.getObject(3);
                rs.getObject(4);
                rs.getObject(5);
                rs.getObject(6);
                rs.getObject(7);
                rs.getObject(8);
            }
        }
    }
}

