/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.monitor;

import com.sun.enterprise.admin.monitor.stats.ConnectorConnectionPoolStats;
import com.sun.enterprise.admin.monitor.stats.CountStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.JDBCConnectionPoolStats;
import com.sun.enterprise.admin.monitor.stats.MutableCountStatistic;
import com.sun.enterprise.admin.monitor.stats.MutableCountStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.RangeStatisticImpl;
import com.sun.enterprise.resource.IASNonSharedResourcePool;
import com.sun.enterprise.resource.monitor.AbstractStatsImpl;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.util.logging.Logger;
import javax.management.j2ee.statistics.CountStatistic;
import javax.management.j2ee.statistics.RangeStatistic;

public abstract class ConnectionPoolStatsImpl
extends AbstractStatsImpl
implements ConnectorConnectionPoolStats,
JDBCConnectionPoolStats {
    protected IASNonSharedResourcePool pool_;
    private static StringManager localStrings = StringManager.getManager(ConnectionPoolStatsImpl.class);
    private String poolName_;
    private MutableCountStatistic numConnFailedValidation_;
    private MutableCountStatistic numConnTimedOut_;
    private RangeStatistic numConnUsed_;
    private RangeStatistic numConnFree_;
    private RangeStatistic numConnRequestWaitTime_;
    private MutableCountStatistic averageConnWaitTime;
    private MutableCountStatistic waitQueueLength;
    private MutableCountStatistic numConnCreated;
    private MutableCountStatistic numConnDestroyed;
    private MutableCountStatistic numConnAcquired;
    private MutableCountStatistic numConnReleased;
    protected static Logger _logger = LogDomains.getLogger("javax.enterprise.resource.resourceadapter");

    public CountStatistic getNumConnFailedValidation() {
        this.numConnFailedValidation_.setCount(this.pool_.getNumConnFailedValidation());
        return (CountStatistic)this.numConnFailedValidation_.unmodifiableView();
    }

    public CountStatistic getNumConnTimedOut() {
        this.numConnTimedOut_.setCount(this.pool_.getNumConnTimedOut());
        return (CountStatistic)this.numConnTimedOut_.unmodifiableView();
    }

    public RangeStatistic getNumConnUsed() {
        this.numConnUsed_ = this.getUpdatedRangeStatistic(this.numConnUsed_, this.pool_.getNumConnInUse(), this.pool_.getMaxNumConnUsed(), this.pool_.getMinNumConnUsed());
        return this.numConnUsed_;
    }

    protected void initializeStatistics() {
        long time = System.currentTimeMillis();
        CountStatisticImpl cs = null;
        cs = new CountStatisticImpl(0L, this.getLocalizedStringFor("num.conn.failed.validation", "NumConnFailedValidation"), this.getLocalizedStringFor("stat.count", "Count"), this.getLocalizedStringFor("num.conn.failed.validation.desc", "Number Of Connections that failed validation"), time, time);
        this.numConnFailedValidation_ = new MutableCountStatisticImpl((CountStatistic)cs);
        cs = new CountStatisticImpl(0L, this.getLocalizedStringFor("num.conn.timedout", "NumConnTimedOut"), this.getLocalizedStringFor("stat.count", "Count"), this.getLocalizedStringFor("num.conn.timedout.desc", "Number of Connection requests that timed out waiting"), time, time);
        this.numConnTimedOut_ = new MutableCountStatisticImpl((CountStatistic)cs);
        cs = new CountStatisticImpl(0L, this.getLocalizedStringFor("num.conn.created", "NumConnCreated"), this.getLocalizedStringFor("stat.count", "Count"), this.getLocalizedStringFor("num.conn.created.desc", "Number of Connection that have been created"), time, time);
        this.numConnCreated = new MutableCountStatisticImpl((CountStatistic)cs);
        cs = new CountStatisticImpl(0L, this.getLocalizedStringFor("num.conn.destroyed", "NumConnDestroyed"), this.getLocalizedStringFor("stat.count", "Count"), this.getLocalizedStringFor("num.conn.destroyed.desc", "Number of Connection that have been destroyed"), time, time);
        this.numConnDestroyed = new MutableCountStatisticImpl((CountStatistic)cs);
        cs = new CountStatisticImpl(0L, this.getLocalizedStringFor("num.conn.opened", "NumConnOpened"), this.getLocalizedStringFor("stat.count", "Count"), this.getLocalizedStringFor("num.conn.opened.desc", "Number of Connection that have been acquired"), time, time);
        this.numConnAcquired = new MutableCountStatisticImpl((CountStatistic)cs);
        cs = new CountStatisticImpl(0L, this.getLocalizedStringFor("num.conn.closed", "NumConnClosed"), this.getLocalizedStringFor("stat.count", "Count"), this.getLocalizedStringFor("num.conn.closed.desc", "Number of Connection that have been released"), time, time);
        this.numConnReleased = new MutableCountStatisticImpl((CountStatistic)cs);
        cs = new CountStatisticImpl(0L, this.getLocalizedStringFor("avg.conn.wait.time", "AvgConnWaitTime"), this.getLocalizedStringFor("stat.milliseconds", "milliseconds"), this.getLocalizedStringFor("avg.conn.wait.time.desc", "Average wait time-duration per successful connection request"), time, time);
        this.averageConnWaitTime = new MutableCountStatisticImpl((CountStatistic)cs);
        cs = new CountStatisticImpl(0L, this.getLocalizedStringFor("wait.queue.length", "WaitQueueLength"), this.getLocalizedStringFor("stat.count", "Count"), this.getLocalizedStringFor("wait.queue.length.desc", "Connection request Wait Queue length"), time, time);
        this.waitQueueLength = new MutableCountStatisticImpl((CountStatistic)cs);
        this.numConnUsed_ = new RangeStatisticImpl(0L, 0L, 1L, this.getLocalizedStringFor("num.conn.used", "NumConnUsed"), this.getLocalizedStringFor("stat.count", "Count"), this.getLocalizedStringFor("num.conn.used.desc", "Number Of Connections used"), time, time);
        this.numConnFree_ = new RangeStatisticImpl(0L, 0L, 1L, this.getLocalizedStringFor("num.conn.free", "NumConnFree"), this.getLocalizedStringFor("stat.count", "Count"), this.getLocalizedStringFor("num.conn.free.desc", "Number Of Free Connections"), time, time);
        this.numConnRequestWaitTime_ = new RangeStatisticImpl(0L, 0L, 1L, this.getLocalizedStringFor("conn.request.wait.time", "ConnRequestWaitTime"), this.getLocalizedStringFor("stat.milliseconds", "milliseconds"), this.getLocalizedStringFor("conn.request.wait.time.desc", "Max and min connection request wait times"), time, time);
    }

    public RangeStatistic getNumConnFree() {
        this.numConnFree_ = this.getUpdatedRangeStatistic(this.numConnFree_, this.pool_.getNumConnFree(), this.pool_.getMaxNumConnFree(), this.pool_.getMinNumConnFree());
        return this.numConnFree_;
    }

    public CountStatistic getAverageConnWaitTime() {
        long averageWaitTime = 0L;
        averageWaitTime = this.getNumConnAcquired().getCount() != 0L ? this.pool_.getTotalConnectionRequestWaitTime() / this.getNumConnAcquired().getCount() : 0L;
        this.averageConnWaitTime.setCount(averageWaitTime);
        return (CountStatistic)this.averageConnWaitTime.unmodifiableView();
    }

    public RangeStatistic getConnRequestWaitTime() {
        this.numConnRequestWaitTime_ = this.getUpdatedRangeStatistic(this.numConnRequestWaitTime_, 0L, this.pool_.getMaxConnRequestWaitTime(), this.pool_.getMinConnRequestWaitTime());
        return this.numConnRequestWaitTime_;
    }

    public CountStatistic getNumConnCreated() {
        this.numConnCreated.setCount(this.pool_.getNumConnCreated());
        return (CountStatistic)this.numConnCreated.unmodifiableView();
    }

    public CountStatistic getNumConnDestroyed() {
        this.numConnDestroyed.setCount(this.pool_.getNumConnDestroyed());
        return (CountStatistic)this.numConnDestroyed.unmodifiableView();
    }

    public CountStatistic getNumConnAcquired() {
        this.numConnAcquired.setCount(this.pool_.getNumConnAcquired());
        return (CountStatistic)this.numConnAcquired.unmodifiableView();
    }

    public CountStatistic getNumConnReleased() {
        this.numConnReleased.setCount(this.pool_.getNumConnReleased());
        return (CountStatistic)this.numConnReleased.unmodifiableView();
    }

    public CountStatistic getWaitQueueLength() {
        this.waitQueueLength.setCount((long)this.pool_.getNumThreadWaiting());
        return (CountStatistic)this.waitQueueLength.unmodifiableView();
    }

    private String getLocalizedStringFor(String key, String defaultValue) {
        return localStrings.getString(key, defaultValue);
    }
}

