/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource;

import java.io.Serializable;

public class ResourceSpec
implements Serializable {
    private String resourceId;
    private int resourceIdType;
    private boolean pmResource;
    private boolean nonTxResource;
    private boolean shareableXAResource_;
    private String jdbcConnectionPoolResourceName;
    private String connectionPoolName;
    public static final int JDBC_URL = 0;
    public static final int JNDI_NAME = 1;
    public static final int JMS = 2;
    public static final String NON_TX_JNDI_EXTENSION = "__nontx";

    public ResourceSpec(String resourceId, int resourceIdType) {
        if (resourceId == null) {
            throw new NullPointerException();
        }
        this.resourceId = resourceId;
        this.resourceIdType = resourceIdType;
        if (resourceId.endsWith("__pm")) {
            this.pmResource = true;
        }
        if (resourceId.endsWith(NON_TX_JNDI_EXTENSION)) {
            this.nonTxResource = true;
        }
    }

    public void setJDBCConnectionPoolResourceName(String name) {
        this.jdbcConnectionPoolResourceName = name;
    }

    public String getJDBCConnectionPoolResourceName() {
        return this.jdbcConnectionPoolResourceName;
    }

    public String getConnectionPoolName() {
        return this.connectionPoolName;
    }

    public void setConnectionPoolName(String name) {
        this.connectionPoolName = name;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other instanceof ResourceSpec) {
            ResourceSpec obj = (ResourceSpec)other;
            if (this.connectionPoolName == null) {
                return this.resourceId.equals(obj.resourceId) && this.resourceIdType == obj.resourceIdType;
            }
            return this.connectionPoolName.equals(obj.connectionPoolName);
        }
        return false;
    }

    public int hashCode() {
        if (this.connectionPoolName == null) {
            return this.resourceId.hashCode() + this.resourceIdType;
        }
        return this.connectionPoolName.hashCode();
    }

    public String toString() {
        return this.resourceId + "_" + this.resourceIdType;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public boolean isPM() {
        return this.pmResource;
    }

    public boolean isNonTx() {
        return this.nonTxResource;
    }

    public void setShareableXAResource(boolean flag) {
        this.shareableXAResource_ = flag;
    }

    public boolean isShareableXAResource() {
        return this.shareableXAResource_;
    }
}

