/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource;

class PoolCounters {
    long numConnFailedValidation = 0L;
    long numConnTimedOut = 0L;
    long numConnAcquired = 0L;
    long numConnReleased = 0L;
    long maxNumConnUsed = 0L;
    long minNumConnUsed = Long.MAX_VALUE;
    long currNumConnUsed = 0L;
    long maxConnectionRequestWait = 0L;
    long minConnectionRequestWait = Long.MAX_VALUE;
    long totalConnectionRequestWait = 0L;
    long maxNumConnFree = 0L;
    long minNumConnFree = Long.MAX_VALUE;
    long currNumConnFree = 0L;
    long numConnCreated = 0L;
    long numConnDestroyed = 0L;

    public PoolCounters(int freePoolSize) {
        this.currNumConnFree = freePoolSize;
    }

    public void reset(int freePoolSize) {
        this.maxNumConnUsed = 0L;
        this.minNumConnUsed = Long.MAX_VALUE;
        this.currNumConnUsed = 0L;
        this.numConnFailedValidation = 0L;
        this.numConnTimedOut = 0L;
        this.maxConnectionRequestWait = 0L;
        this.minConnectionRequestWait = Long.MAX_VALUE;
        this.totalConnectionRequestWait = 0L;
        this.maxNumConnFree = 0L;
        this.minNumConnFree = Long.MAX_VALUE;
        this.currNumConnFree = freePoolSize;
        this.numConnCreated = 0L;
        this.numConnDestroyed = 0L;
    }

    public synchronized void setWaitTime(long elapsedWaitTime) {
        if (elapsedWaitTime > this.maxConnectionRequestWait) {
            this.maxConnectionRequestWait = elapsedWaitTime;
        }
        if (elapsedWaitTime < this.minConnectionRequestWait) {
            this.minConnectionRequestWait = elapsedWaitTime;
        }
        this.totalConnectionRequestWait += elapsedWaitTime;
    }

    public synchronized void incrementNumConnUsed() {
        this.setNumConnUsed(++this.currNumConnUsed);
        this.setNumConnFree(--this.currNumConnFree);
    }

    public synchronized void decrementNumConnUsed() {
        this.setNumConnUsed(--this.currNumConnUsed);
        this.setNumConnFree(++this.currNumConnFree);
    }

    private void setNumConnUsed(long numConnInUse) {
        if (numConnInUse > this.maxNumConnUsed) {
            this.maxNumConnUsed = numConnInUse;
        }
        if (numConnInUse < this.minNumConnUsed) {
            this.minNumConnUsed = numConnInUse <= 0L ? 0L : numConnInUse;
        }
        this.currNumConnUsed = numConnInUse;
    }

    private void setNumConnFree(long numConnFree) {
        if (numConnFree > this.maxNumConnFree) {
            this.maxNumConnFree = numConnFree;
        }
        if (numConnFree < this.minNumConnFree) {
            this.minNumConnFree = numConnFree <= 0L ? 0L : numConnFree;
        }
        this.currNumConnFree = numConnFree >= 0L ? numConnFree : 0L;
    }

    public String toString() {
        String str = "PoolCounters: ";
        str = str + "\n numConnFailedValidation = " + this.numConnFailedValidation;
        str = str + "\n numConnTimedOut = " + this.numConnTimedOut;
        str = str + "\n numConnAcquired = " + this.numConnAcquired;
        str = str + "\n numConnReleased = " + this.numConnReleased;
        str = str + "\n maxNumConnUsed = " + this.maxNumConnUsed;
        str = str + "\n minNumConnUsed = " + this.minNumConnUsed;
        str = str + "\n currNumConnUsed = " + this.currNumConnUsed;
        str = str + "\n maxConnectionRequestWait = " + this.maxConnectionRequestWait;
        str = str + "\n minConnectionRequestWait = " + this.minConnectionRequestWait;
        str = str + "\n maxNumConnFree =  = " + this.maxNumConnFree;
        str = str + "\n minNumConnFree = " + this.minNumConnFree;
        str = str + "\n currNumConnFree = " + this.currNumConnFree;
        str = str + "\n numConnCreated = " + this.numConnCreated;
        str = str + "\n numConnDestroyed = " + this.numConnDestroyed;
        return str;
    }
}

