/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource;

import com.sun.enterprise.admin.monitor.MonitoredObjectType;
import com.sun.enterprise.admin.monitor.MonitoringHelper;
import com.sun.enterprise.resource.IASNonSharedResourcePool;
import com.sun.enterprise.resource.monitor.IASResourcePoolMonitor;
import com.sun.enterprise.resource.monitor.JDBCPoolMonitorMBean;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;

public class IASResourcePoolMonitorImpl
implements IASResourcePoolMonitor {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.resource.resourceadapter");
    private IASNonSharedResourcePool[] poolArray = new IASNonSharedResourcePool[2];
    private int arraySize = 0;

    public IASResourcePoolMonitorImpl(String name) {
        JDBCPoolMonitorMBean mbean = new JDBCPoolMonitorMBean(this);
        try {
            MonitoringHelper.registerJdbcPoolMonitoringMBean(name, MonitoredObjectType.JDBC_CONN_POOL, mbean);
        }
        catch (InstanceAlreadyExistsException e) {
        }
        catch (MBeanRegistrationException brx) {
            _logger.log(Level.SEVERE, "jdbc.mbean_register", brx);
        }
    }

    public int getNumConnFailedValidation() {
        int failed = 0;
        for (int i = 0; i < this.arraySize; ++i) {
            failed = (int)((long)failed + this.poolArray[i].getNumConnFailedValidation());
        }
        return failed;
    }

    public int getNumConnTimedOut() {
        int timedOut = 0;
        for (int i = 0; i < this.arraySize; ++i) {
            timedOut = (int)((long)timedOut + this.poolArray[i].getNumConnTimedOut());
        }
        return timedOut;
    }

    public int getNumThreadWaiting() {
        int waiting = 0;
        for (int i = 0; i < this.arraySize; ++i) {
            waiting += this.poolArray[i].getNumThreadWaiting();
        }
        return waiting;
    }

    public void addPool(IASNonSharedResourcePool pool) {
        if (this.arraySize >= 2) {
            return;
        }
        this.poolArray[this.arraySize] = pool;
        ++this.arraySize;
    }
}

