/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource;

import com.sun.enterprise.PoolManager;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.resource.AbstractConnectorAllocator;
import com.sun.enterprise.resource.ClientSecurityInfo;
import com.sun.enterprise.resource.PoolingException;
import com.sun.enterprise.resource.ResourceHandle;
import com.sun.enterprise.resource.ResourceSpec;
import java.util.logging.Level;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.security.auth.Subject;
import javax.transaction.xa.XAResource;

public class ConnectorAllocator
extends AbstractConnectorAllocator {
    private boolean shareable;

    public ConnectorAllocator(PoolManager poolMgr, ManagedConnectionFactory mcf, ResourceSpec spec, Subject subject, ConnectionRequestInfo reqInfo, ClientSecurityInfo info, ConnectorDescriptor desc, boolean shareable) {
        super(poolMgr, mcf, spec, subject, reqInfo, info, desc);
        this.shareable = shareable;
    }

    public ResourceHandle createResource() throws PoolingException {
        try {
            ManagedConnection mc = this.mcf.createManagedConnection(this.subject, this.reqInfo);
            ResourceHandle resource = new ResourceHandle(mc, this.spec, this, this.info);
            ConnectionListenerImpl l = new ConnectionListenerImpl(resource);
            mc.addConnectionEventListener((ConnectionEventListener)l);
            return resource;
        }
        catch (ResourceException ex) {
            throw new PoolingException((Exception)((Object)ex));
        }
    }

    public void fillInResourceObjects(ResourceHandle resource) throws PoolingException {
        try {
            ManagedConnection mc = (ManagedConnection)resource.getResource();
            Object con = mc.getConnection(this.subject, this.reqInfo);
            XAResource xares = mc.getXAResource();
            resource.fillInResourceObjects(con, xares);
        }
        catch (ResourceException ex) {
            throw new PoolingException((Exception)((Object)ex));
        }
    }

    public void destroyResource(ResourceHandle resource) throws PoolingException {
        try {
            this.closeUserConnection(resource);
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            ManagedConnection mc = (ManagedConnection)resource.getResource();
            mc.destroy();
        }
        catch (Exception ex) {
            _logger.log(Level.WARNING, ex.getMessage());
            throw new PoolingException(ex);
        }
    }

    public boolean shareableWithinComponent() {
        return this.shareable;
    }

    public Object getSharedConnection(ResourceHandle h) throws PoolingException {
        try {
            ManagedConnection mc = (ManagedConnection)h.getResource();
            Object con = mc.getConnection(this.subject, this.reqInfo);
            h.incrementCount();
            return con;
        }
        catch (ResourceException ex) {
            throw new PoolingException(ex.toString(), (Exception)((Object)ex));
        }
    }

    class ConnectionListenerImpl
    implements ConnectionEventListener {
        private ResourceHandle resource;

        public ConnectionListenerImpl(ResourceHandle resource) {
            this.resource = resource;
        }

        public void connectionClosed(ConnectionEvent evt) {
            if (this.resource.hasConnectionErrorOccurred()) {
                return;
            }
            if (this.resource.getShareCount() == 0) {
                ConnectorAllocator.this.poolMgr.resourceClosed(this.resource);
            } else {
                this.resource.decrementCount();
            }
        }

        public void connectionErrorOccurred(ConnectionEvent evt) {
            this.resource.setConnectionErrorOccurred();
            ManagedConnection mc = (ManagedConnection)evt.getSource();
            mc.removeConnectionEventListener((ConnectionEventListener)this);
            ConnectorAllocator.this.poolMgr.resourceErrorOccurred(this.resource);
            try {
                mc.destroy();
            }
            catch (ResourceException resourceException) {
                // empty catch block
            }
        }

        public void localTransactionStarted(ConnectionEvent evt) {
        }

        public void localTransactionCommitted(ConnectionEvent evt) {
        }

        public void localTransactionRolledback(ConnectionEvent evt) {
        }
    }
}

