/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.repository;

import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DataSourceParser {
    private static Logger _logger = null;
    private static final String DS = "xadatasource";
    private static final String JNDINAME = "jndiname";
    private static final String CLASSNAME = "classname";
    private static final String PROP = "prop";
    private static final String DBUSER = "dbuser";
    private static final String DBPASSWORD = "dbpassword";
    private static LocalStringManagerImpl localStrings;

    private DataSourceParser() {
    }

    public Vector parseProperties(Properties props) {
        Vector<DataSourceInfo> list = new Vector<DataSourceInfo>();
        int count = 0;
        while (true) {
            String jndiName = props.getProperty("xadatasource." + count + "." + JNDINAME);
            String className = props.getProperty("xadatasource." + count + "." + CLASSNAME);
            String dbUser = props.getProperty("xadatasource." + count + "." + DBUSER);
            String dbPassword = props.getProperty("xadatasource." + count + "." + DBPASSWORD);
            if (jndiName == null || className == null) break;
            try {
                DataSourceInfo dsi = new DataSourceInfo();
                dsi.jndiName = jndiName;
                dsi.dbUser = dbUser;
                dsi.dbPassword = dbPassword;
                Object obj = Class.forName(className).newInstance();
                dsi.dataSource = obj;
                list.addElement(dsi);
            }
            catch (Exception ex) {
                Object[] args = new Object[]{className};
                _logger.log(Level.SEVERE, "enterprise.repository_init_class_err", args);
            }
            ++count;
        }
        Enumeration<Object> e = props.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String val = props.getProperty(key);
            if (!key.startsWith(DS) || key.indexOf(PROP) == -1) continue;
            try {
                String s = key.substring(DS.length() + 1, key.indexOf(".", DS.length() + 1));
                int idx = Integer.parseInt(s);
                String prop = key.substring(key.lastIndexOf("prop.") + PROP.length() + 1);
                DataSourceInfo dsi = (DataSourceInfo)list.elementAt(idx);
                Object obj = dsi.dataSource;
                this.invokeSetMethod(obj, prop, val);
            }
            catch (Exception ex) {
                Object[] args = new Object[]{key, val};
                _logger.log(Level.SEVERE, "enterprise.repository_prop_err", args);
            }
        }
        return list;
    }

    private void invokeSetMethod(Object obj, String prop, String value) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Class<?> cl = obj.getClass();
        String setMeth = "set" + prop.substring(0, 1).toUpperCase() + prop.substring(1);
        try {
            Class[] cldef = new Class[]{String.class};
            Method meth = cl.getMethod(setMeth, cldef);
            Object[] params = new Object[]{value};
            meth.invoke(obj, params);
            return;
        }
        catch (NoSuchMethodException ex) {
            Class[] cldef = new Class[]{Integer.TYPE};
            Method meth = cl.getMethod(setMeth, cldef);
            Object[] params = new Object[]{Integer.valueOf(value)};
            meth.invoke(obj, params);
            return;
        }
    }

    static {
        _logger = LogDomains.getLogger("javax.enterprise");
        localStrings = new LocalStringManagerImpl(DataSourceParser.class);
    }

    public static class DataSourceInfo {
        public String jndiName;
        public String dbUser;
        public String dbPassword;
        public Object dataSource;
    }
}

