/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.naming;

import com.sun.appserv.naming.S1ASCtxFactory;
import com.sun.enterprise.naming.SerialContext;
import com.sun.enterprise.util.ORBManager;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;

public class SerialInitContextFactory
implements InitialContextFactory {
    private Hashtable defaultEnv;
    private S1ASCtxFactory s1asCtxFactory;
    private String LBPOLICY = System.getProperty("com.sun.appserv.iiop.loadbalancingpolicy");
    private String ENDPOINTS = System.getProperty("com.sun.appserv.iiop.endpoints");
    private static boolean _initializeOrbManager = true;

    public static void setInitializeOrbManager(boolean init) {
        _initializeOrbManager = init;
    }

    public SerialInitContextFactory() {
        if (this.LBPOLICY != null && !this.LBPOLICY.equals("") || this.ENDPOINTS != null && !this.ENDPOINTS.equals("")) {
            this.s1asCtxFactory = new S1ASCtxFactory();
        } else {
            this.defaultEnv = new Hashtable();
        }
    }

    public Context getInitialContext(Hashtable env) throws NamingException {
        if (_initializeOrbManager && (env == null || env != null && env.get("java.naming.corba.orb") == null)) {
            Properties props = new Properties();
            if (env.get("org.omg.CORBA.ORBInitialHost") != null && env.get("org.omg.CORBA.ORBInitialPort") != null) {
                props.put("org.omg.CORBA.ORBInitialHost", (String)env.get("org.omg.CORBA.ORBInitialHost"));
                props.put("org.omg.CORBA.ORBInitialPort", (String)env.get("org.omg.CORBA.ORBInitialPort"));
            }
            ORBManager.init(null, props);
            if (this.defaultEnv != null) {
                this.defaultEnv.put("java.naming.corba.orb", ORBManager.getORB());
            }
            if (env != null) {
                env.put("java.naming.corba.orb", ORBManager.getORB());
            }
        }
        if (SerialContext.getSticky() != null) {
            Context ctx = SerialContext.getStickyContext();
            return ctx;
        }
        if (this.s1asCtxFactory != null) {
            return this.s1asCtxFactory.getInitialContext(env);
        }
        if (env != null) {
            return new SerialContext(env);
        }
        return new SerialContext(this.defaultEnv);
    }
}

