/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.naming;

import com.sun.corba.ee.impl.orb.ORBImpl;
import com.sun.enterprise.naming.SerialContextProvider;
import com.sun.enterprise.naming.SerialNameParser;
import com.sun.enterprise.naming.java.javaURLContext;
import com.sun.enterprise.util.ORBManager;
import com.sun.logging.LogDomains;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Binding;
import javax.naming.CommunicationException;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.OperationNotSupportedException;
import javax.naming.spi.NamingManager;
import javax.rmi.PortableRemoteObject;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextHelper;

public class SerialContext
implements Context {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core.naming");
    private static Hashtable providerCache = new Hashtable();
    private static NameParser myParser = new SerialNameParser();
    private Hashtable myEnv;
    private SerialContextProvider provider;
    private String myName;
    private javaURLContext javaUrlContext = null;
    private static final String JAVA_URL = "java:";
    private InitialContext cosContext;
    private static Boolean threadlock = new Boolean(true);
    private static ThreadLocal stickyContext = new ThreadLocal();

    public static void setSticky(ThreadLocalIC var) {
        stickyContext.set(var);
    }

    public static ThreadLocalIC getSticky() {
        return (ThreadLocalIC)stickyContext.get();
    }

    public static Context getStickyContext() {
        return SerialContext.getSticky().getStickyContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SerialContextProvider narrowProvider(Object ref) throws Exception {
        NamingContext nctx = NamingContextHelper.narrow((Object)ref);
        NameComponent[] path = new NameComponent[]{new NameComponent("SerialContextProvider", "")};
        Boolean bl = threadlock;
        synchronized (bl) {
            this.provider = (SerialContextProvider)PortableRemoteObject.narrow(nctx.resolve(path), SerialContextProvider.class);
        }
        return this.provider;
    }

    private SerialContextProvider getProvider() throws NamingException {
        ORB orb = (ORB)this.myEnv.get("java.naming.corba.orb");
        if (orb == null) {
            orb = ORBManager.getORB();
        }
        if (_logger.isLoggable(Level.FINE)) {
            this.print(orb);
        }
        if (this.provider == null) {
            try {
                Object ref = null;
                if (this.myEnv.get("com.sun.appserv.ee.iiop.endpointslist") != null) {
                    ref = orb.string_to_object((String)this.myEnv.get("com.sun.appserv.ee.iiop.endpointslist"));
                    this.provider = this.narrowProvider(ref);
                } else {
                    this.provider = (SerialContextProvider)providerCache.get(orb);
                    if (this.provider == null) {
                        ref = orb.resolve_initial_references("NameService");
                        this.provider = this.narrowProvider(ref);
                        providerCache.put(orb, this.provider);
                    }
                }
            }
            catch (Exception ex) {
                CommunicationException ce = new CommunicationException("Can't find SerialContextProvider");
                ce.initCause(ex);
                throw ce;
            }
        }
        return this.provider;
    }

    Context getCosContext() throws NamingException {
        if (this.cosContext == null) {
            Hashtable<String, java.lang.Object> cosNamingEnv = new Hashtable<String, java.lang.Object>();
            cosNamingEnv.put("java.naming.factory.initial", "com.sun.jndi.cosnaming.CNCtxFactory");
            ORB orb = (ORB)this.myEnv.get("java.naming.corba.orb");
            if (orb == null) {
                orb = ORBManager.getORB();
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("SerialContext ==> inside getCosContext()");
                this.print(orb);
            }
            cosNamingEnv.put("java.naming.corba.orb", orb);
            this.cosContext = new InitialContext(cosNamingEnv);
        }
        return this.cosContext;
    }

    public void print(ORB orb) {
        _logger.fine("SerialContext ==> SerialContext instance created : " + this);
        if (orb != null) {
            _logger.fine("SerialContext ==> ORB instance : " + orb);
            String host = ((ORBImpl)((java.lang.Object)orb)).getORBData().getORBInitialHost();
            int port = ((ORBImpl)((java.lang.Object)orb)).getORBData().getORBInitialPort();
            _logger.fine("SerialContext ==> ORB HOST : " + host + ", ORB PORT : " + port);
        } else {
            _logger.fine("orb is null");
        }
    }

    public SerialContext(Hashtable environment) throws NamingException {
        this.myEnv = environment != null ? (Hashtable)environment.clone() : null;
        this.myName = "";
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("SerialContext ==> SerialContext instance created : " + this);
        }
        this.javaUrlContext = new javaURLContext(this.myEnv, this);
    }

    public SerialContext(String name, Hashtable env) throws NamingException {
        this(env);
        this.myName = name;
    }

    public String getNameInNamespace() throws NamingException {
        return this.myName;
    }

    private boolean isjavaURL(String name) {
        return name.startsWith(JAVA_URL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public java.lang.Object lookup(String name) throws NamingException {
        block28: {
            if (this.myEnv.get("com.sun.appserv.ee.iiop.endpointslist") != null) {
                if (SerialContext.getSticky() == null) {
                    ThreadLocalIC threadLocal = new ThreadLocalIC(this, 1);
                    SerialContext.setSticky(threadLocal);
                } else {
                    SerialContext.getSticky().incrementCount();
                }
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("SerialContext ==> doing lookup with " + this);
            }
            if (!name.equals("")) break block28;
            try {
                if (SerialContext.getSticky() != null) {
                    SerialContext.getSticky().decrementCount();
                }
                java.lang.Object var4_5 = null;
            }
            catch (Throwable throwable) {
                java.lang.Object var4_6 = null;
                if (SerialContext.getSticky() != null && SerialContext.getSticky().getStickyCount() == 0) {
                    SerialContext.setSticky(null);
                }
                throw throwable;
            }
            if (SerialContext.getSticky() != null && SerialContext.getSticky().getStickyCount() == 0) {
                SerialContext.setSticky(null);
            }
            return new SerialContext(this.myName, this.myEnv);
        }
        name = this.getRelativeName(name);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("SerialContext ==> looking up : " + name);
        }
        try {
            java.lang.Object obj;
            block30: {
                block29: {
                    if (!this.isjavaURL(name)) break block29;
                    try {
                        if (SerialContext.getSticky() != null) {
                            SerialContext.getSticky().decrementCount();
                        }
                        java.lang.Object var6_10 = null;
                    }
                    catch (Throwable throwable) {
                        java.lang.Object var6_11 = null;
                        if (SerialContext.getSticky() != null && SerialContext.getSticky().getStickyCount() == 0) {
                            SerialContext.setSticky(null);
                        }
                        throw throwable;
                    }
                    if (SerialContext.getSticky() != null && SerialContext.getSticky().getStickyCount() == 0) {
                        SerialContext.setSticky(null);
                    }
                    return this.javaUrlContext.lookup(name);
                }
                obj = this.getProvider().lookup(name);
                if (!(obj instanceof Context)) break block30;
                try {
                    if (SerialContext.getSticky() != null) {
                        SerialContext.getSticky().decrementCount();
                    }
                    java.lang.Object var8_13 = null;
                }
                catch (Throwable throwable) {
                    java.lang.Object var8_14 = null;
                    if (SerialContext.getSticky() != null && SerialContext.getSticky().getStickyCount() == 0) {
                        SerialContext.setSticky(null);
                    }
                    throw throwable;
                }
                if (SerialContext.getSticky() != null && SerialContext.getSticky().getStickyCount() == 0) {
                    SerialContext.setSticky(null);
                }
                return new SerialContext(name, this.myEnv);
            }
            java.lang.Object retObj = NamingManager.getObjectInstance(obj, new CompositeName(name), null, this.myEnv);
            try {
                if (SerialContext.getSticky() != null) {
                    SerialContext.getSticky().decrementCount();
                }
                java.lang.Object var10_16 = null;
            }
            catch (Throwable throwable) {
                java.lang.Object var10_17 = null;
                if (SerialContext.getSticky() != null && SerialContext.getSticky().getStickyCount() == 0) {
                    SerialContext.setSticky(null);
                }
                throw throwable;
            }
            if (SerialContext.getSticky() != null && SerialContext.getSticky().getStickyCount() == 0) {
                SerialContext.setSticky(null);
            }
            return retObj;
        }
        catch (NamingException nnfe) {
            throw nnfe;
        }
        catch (Exception ex) {
            _logger.log(Level.SEVERE, "enterprise_naming.serialctx_communication_exception", ex);
            CommunicationException ce = new CommunicationException("serial context communication ex");
            ce.initCause(ex);
            throw ce;
        }
    }

    public java.lang.Object lookup(Name name) throws NamingException {
        return this.lookup(name.toString());
    }

    public void bind(String name, java.lang.Object obj) throws NamingException {
        if (this.isjavaURL(name = this.getRelativeName(name))) {
            this.javaUrlContext.bind(name, obj);
        } else {
            try {
                this.getProvider().bind(name, obj);
            }
            catch (RemoteException ex) {
                throw new CommunicationException(ex.toString());
            }
        }
    }

    public void bind(Name name, java.lang.Object obj) throws NamingException {
        this.bind(name.toString(), obj);
    }

    public void rebind(String name, java.lang.Object obj) throws NamingException {
        if (this.isjavaURL(name = this.getRelativeName(name))) {
            this.javaUrlContext.rebind(name, obj);
        } else {
            try {
                this.getProvider().rebind(name, obj);
            }
            catch (RemoteException ex) {
                throw new CommunicationException(ex.toString());
            }
        }
    }

    public void rebind(Name name, java.lang.Object obj) throws NamingException {
        this.rebind(name.toString(), obj);
    }

    public void unbind(String name) throws NamingException {
        if (this.isjavaURL(name = this.getRelativeName(name))) {
            this.javaUrlContext.unbind(name);
        } else {
            try {
                this.getProvider().unbind(name);
            }
            catch (RemoteException ex) {
                throw new CommunicationException(ex.toString());
            }
        }
    }

    public void unbind(Name name) throws NamingException {
        this.unbind(name.toString());
    }

    public void rename(String oldname, String newname) throws NamingException {
        oldname = this.getRelativeName(oldname);
        newname = this.getRelativeName(newname);
        if (this.isjavaURL(oldname)) {
            this.javaUrlContext.rename(oldname, newname);
        } else {
            try {
                this.getProvider().rename(oldname, newname);
            }
            catch (RemoteException ex) {
                throw new CommunicationException(ex.toString());
            }
        }
    }

    public void rename(Name oldname, Name newname) throws NamingException {
        this.rename(oldname.toString(), newname.toString());
    }

    public NamingEnumeration list(String name) throws NamingException {
        if (name.equals("")) {
            try {
                Hashtable bindings = this.getProvider().list(this.myName);
                return new RepNames(bindings);
            }
            catch (RemoteException ex) {
                throw new CommunicationException(ex.toString());
            }
        }
        if (this.isjavaURL(name = this.getRelativeName(name))) {
            return this.javaUrlContext.list(name);
        }
        java.lang.Object target = this.lookup(name);
        if (target instanceof Context) {
            return ((Context)target).list("");
        }
        throw new NotContextException(name + " cannot be listed");
    }

    public NamingEnumeration list(Name name) throws NamingException {
        return this.list(name.toString());
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        if (name.equals("")) {
            try {
                Hashtable bindings = this.getProvider().list(this.myName);
                return new RepBindings(bindings);
            }
            catch (RemoteException ex) {
                CommunicationException ce = new CommunicationException(ex.toString());
                ce.initCause(ex);
                throw ce;
            }
        }
        if (this.isjavaURL(name = this.getRelativeName(name))) {
            return this.javaUrlContext.listBindings(name);
        }
        java.lang.Object target = this.lookup(name);
        if (target instanceof Context) {
            return ((Context)target).listBindings("");
        }
        throw new NotContextException(name + " cannot be listed");
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        return this.listBindings(name.toString());
    }

    public void destroySubcontext(String name) throws NamingException {
        if (this.isjavaURL(name = this.getRelativeName(name))) {
            this.javaUrlContext.destroySubcontext(name);
        } else {
            try {
                this.getProvider().destroySubcontext(name);
            }
            catch (RemoteException e) {
                CommunicationException ce = new CommunicationException(e.toString());
                ce.initCause(e);
                throw ce;
            }
        }
    }

    public void destroySubcontext(Name name) throws NamingException {
        this.destroySubcontext(name.toString());
    }

    public Context createSubcontext(String name) throws NamingException {
        Context c = null;
        if (this.isjavaURL(name = this.getRelativeName(name))) {
            return this.javaUrlContext.createSubcontext(name);
        }
        try {
            c = this.getProvider().createSubcontext(name);
            if (c instanceof Context) {
                c = new SerialContext(name, this.myEnv);
            }
        }
        catch (RemoteException e) {
            CommunicationException ce = new CommunicationException(e.toString());
            ce.initCause(e);
            throw ce;
        }
        return c;
    }

    public Context createSubcontext(Name name) throws NamingException {
        return this.createSubcontext(name.toString());
    }

    public java.lang.Object lookupLink(String name) throws NamingException {
        if (this.isjavaURL(name = this.getRelativeName(name))) {
            return this.javaUrlContext.lookupLink(name);
        }
        return this.lookup(name);
    }

    public java.lang.Object lookupLink(Name name) throws NamingException {
        return this.lookupLink(name.toString());
    }

    public NameParser getNameParser(String name) throws NamingException {
        return myParser;
    }

    public NameParser getNameParser(Name name) throws NamingException {
        return this.getNameParser(name.toString());
    }

    public String composeName(String name, String prefix) throws NamingException {
        Name result = this.composeName(new CompositeName(name), new CompositeName(prefix));
        return result.toString();
    }

    public Name composeName(Name name, Name prefix) throws NamingException {
        Name result = (Name)prefix.clone();
        result.addAll(name);
        return result;
    }

    public java.lang.Object addToEnvironment(String propName, java.lang.Object propVal) throws NamingException {
        if (this.myEnv == null) {
            this.myEnv = new Hashtable(5, 0.75f);
        }
        return this.myEnv.put(propName, propVal);
    }

    public java.lang.Object removeFromEnvironment(String propName) throws NamingException {
        if (this.myEnv == null) {
            return null;
        }
        return this.myEnv.remove(propName);
    }

    public Hashtable getEnvironment() throws NamingException {
        if (this.myEnv == null) {
            this.myEnv = new Hashtable(3, 0.75f);
        }
        return this.myEnv;
    }

    public void close() throws NamingException {
        this.myEnv = null;
    }

    private String getRelativeName(String name) {
        if (!this.myName.equals("")) {
            name = this.myName + "/" + name;
        }
        return name;
    }

    class ThreadLocalIC {
        Context ctx;
        int count = 0;

        public ThreadLocalIC(Context ctx, int count) {
            this.ctx = ctx;
            this.count = count;
        }

        public void setStickyContext(Context ctx) {
        }

        public Context getStickyContext() {
            return this.ctx;
        }

        public void setStickyCount(int count) {
        }

        public int getStickyCount() {
            return this.count;
        }

        public void incrementCount() {
            ++this.count;
        }

        public void decrementCount() {
            --this.count;
        }
    }

    class RepBindings
    implements NamingEnumeration {
        Enumeration names;
        Hashtable bindings;

        RepBindings(Hashtable bindings) {
            this.bindings = bindings;
            this.names = bindings.keys();
        }

        public boolean hasMoreElements() {
            return this.names.hasMoreElements();
        }

        public boolean hasMore() throws NamingException {
            return this.hasMoreElements();
        }

        public java.lang.Object nextElement() {
            if (this.hasMoreElements()) {
                String name = (String)this.names.nextElement();
                return new Binding(name, this.bindings.get(name));
            }
            return null;
        }

        public java.lang.Object next() throws NamingException {
            return this.nextElement();
        }

        public void close() throws NamingException {
            throw new OperationNotSupportedException("close() not implemented");
        }
    }

    class RepNames
    implements NamingEnumeration {
        Hashtable bindings;
        Enumeration names;

        RepNames(Hashtable bindings) {
            this.bindings = bindings;
            this.names = bindings.keys();
        }

        public boolean hasMoreElements() {
            return this.names.hasMoreElements();
        }

        public boolean hasMore() throws NamingException {
            return this.hasMoreElements();
        }

        public java.lang.Object nextElement() {
            if (this.names.hasMoreElements()) {
                String name = (String)this.names.nextElement();
                String className = this.bindings.get(name).getClass().getName();
                return new NameClassPair(name, className);
            }
            return null;
        }

        public java.lang.Object next() throws NamingException {
            return this.nextElement();
        }

        public void close() throws NamingException {
            throw new OperationNotSupportedException("close() not implemented");
        }
    }
}

