/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.naming;

import com.sun.ejb.Container;
import com.sun.enterprise.ComponentInvocation;
import com.sun.enterprise.InvocationException;
import com.sun.enterprise.InvocationManager;
import com.sun.enterprise.NamingManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbReferenceDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.JmsDestinationReferenceDescriptor;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import com.sun.enterprise.deployment.MailConfiguration;
import com.sun.enterprise.deployment.MessageDestinationReferenceDescriptor;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.ServiceRefPortInfo;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.naming.BindingsEnum;
import com.sun.enterprise.naming.J2EEEnvWrapper;
import com.sun.enterprise.naming.MailLogOutputStream;
import com.sun.enterprise.naming.NamePairsEnum;
import com.sun.enterprise.naming.SerialContext;
import com.sun.enterprise.naming.SerialNameParser;
import com.sun.enterprise.naming.java.javaURLContext;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.ORBManager;
import com.sun.enterprise.util.ObjectInputStreamWithLoader;
import com.sun.enterprise.webservice.ServiceInvocationHandler;
import com.sun.enterprise.webservice.WsUtil;
import com.sun.logging.LogDomains;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.Remote;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Queue;
import javax.jms.Topic;
import javax.mail.Session;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.xml.namespace.QName;
import javax.xml.rpc.Service;
import javax.xml.rpc.ServiceFactory;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;

public final class NamingManagerImpl
implements NamingManager {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core.naming");
    public static final String IIOPOBJECT_FACTORY = "com.sun.enterprise.naming.factory.IIOPObjectFactory";
    public static final String JAVA_COMP_STRING = "java:comp/env/";
    private static final String CONTEXT_SEPARATOR = "/";
    private static final String ID_SEPARATOR = "_";
    private static final int UNKNOWN_COMPONENT = 0;
    private static final int EJB_COMPONENT = 1;
    private static final int WEB_COMPONENT = 2;
    private static final int APP_CLIENT_COMPONENT = 3;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(NamingManagerImpl.class);
    private InitialContext initialContext;
    private InitialContext cosContext;
    private InvocationManager im = null;
    private Switch theSwitch = null;
    private NameParser nameParser = new SerialNameParser();
    private Hashtable namespaces;
    public static final String EIS_STRING = "/eis/";
    private static final String CORBANAME = "corbaname:";

    public NamingManagerImpl() throws NamingException {
        this(new InitialContext());
    }

    public NamingManagerImpl(InitialContext ic) throws NamingException {
        this.initialContext = ic;
        this.namespaces = new Hashtable();
        this.theSwitch = Switch.getSwitch();
        this.im = this.theSwitch.getInvocationManager();
    }

    public Context getInitialContext() {
        return this.initialContext;
    }

    public NameParser getNameParser() {
        return this.nameParser;
    }

    private InitialContext getCosContext() throws NamingException {
        if (this.cosContext == null) {
            Hashtable<String, java.lang.Object> cosNamingEnv = new Hashtable<String, java.lang.Object>();
            cosNamingEnv.put("java.naming.factory.initial", "com.sun.jndi.cosnaming.CNCtxFactory");
            ORB orb = ORBManager.getORB();
            cosNamingEnv.put("java.naming.corba.orb", orb);
            this.cosContext = new InitialContext(cosNamingEnv);
        }
        return this.cosContext;
    }

    public void publishObject(String name, java.lang.Object obj, boolean rebind) throws NamingException {
        CompositeName nameobj = new CompositeName(name);
        this.publishObject(nameobj, obj, rebind);
    }

    public void publishObject(Name name, java.lang.Object obj, boolean rebind) throws NamingException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Publish object " + obj + " using name " + name);
        }
        java.lang.Object serialObj = obj;
        if (this.isCOSNamingObj(obj)) {
            this.createSubContexts(name, this.getCosContext());
            if (rebind) {
                this.getCosContext().rebind(name, obj);
            } else {
                this.getCosContext().bind(name, obj);
            }
            serialObj = new Reference("reference", new StringRefAddr("url", name.toString()), IIOPOBJECT_FACTORY, null);
        }
        if (rebind) {
            this.initialContext.rebind(name, serialObj);
        } else {
            this.initialContext.bind(name, serialObj);
        }
    }

    public void unpublishObject(String name) throws NamingException {
        java.lang.Object obj = this.initialContext.lookup(name);
        if (this.isCOSNamingObj(obj)) {
            this.getCosContext().unbind(name);
        }
        this.initialContext.unbind(name);
    }

    public void unpublishObject(Name name) throws NamingException {
        this.unpublishObject(name.toString());
    }

    private void createSubContexts(Name name, Context rootCtx) throws NamingException {
        int numSubContexts = name.size() - 1;
        Context currentCtx = rootCtx;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Creating sub contexts for " + name);
        }
        for (int subCtxIndex = 0; subCtxIndex < numSubContexts; ++subCtxIndex) {
            Context newCtx;
            String subCtxName = name.get(subCtxIndex);
            try {
                java.lang.Object obj = currentCtx.lookup(subCtxName);
                if (obj == null) {
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.log(Level.FINE, "name == null");
                    }
                    currentCtx = newCtx = currentCtx.createSubcontext(subCtxName);
                    continue;
                }
                if (obj instanceof Context) {
                    currentCtx = (Context)obj;
                    continue;
                }
                throw new NameAlreadyBoundException(subCtxName);
            }
            catch (NameNotFoundException e) {
                _logger.log(Level.FINE, "name not found", e);
                currentCtx = newCtx = currentCtx.createSubcontext(subCtxName);
            }
        }
    }

    public synchronized String bindObjects(JndiNameEnvironment env) throws NamingException {
        String destinationName;
        String logicalJndiName;
        EnvironmentProperty next;
        String componentId = this.getMangledIdName(env);
        HashMap<String, java.lang.Object> namespace = new HashMap<String, java.lang.Object>();
        this.namespaces.put(componentId, namespace);
        namespace.put("java:", new javaURLContext("java:", null));
        namespace.put("java:comp", new javaURLContext("java:comp", null));
        namespace.put("java:comp/env", new javaURLContext("java:comp/env", null));
        Iterator itr = env.getEnvironmentProperties().iterator();
        while (itr.hasNext()) {
            next = (EnvironmentProperty)itr.next();
            logicalJndiName = this.descriptorToLogicalJndiName(next);
            java.lang.Object valueObject = next.getValueObject();
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, localStrings.getLocalString("naming.bind", "Binding name:{0}", new java.lang.Object[]{logicalJndiName}));
            }
            if (namespace.put(logicalJndiName, valueObject) != null) {
                _logger.log(Level.WARNING, localStrings.getLocalString("naming.alreadyexists", "Reference name [{0}] already exists in {1}", new java.lang.Object[]{next.getName(), this.getApplicationName(env)}));
            }
            this.bindIntermediateContexts(namespace, logicalJndiName);
        }
        itr = env.getJmsDestinationReferenceDescriptors().iterator();
        while (itr.hasNext()) {
            next = (JmsDestinationReferenceDescriptor)itr.next();
            logicalJndiName = this.descriptorToLogicalJndiName(next);
            destinationName = ((JmsDestinationReferenceDescriptor)next).getJndiName();
            java.lang.Object destinationObject = null;
            try {
                destinationObject = this.initialContext.lookup(destinationName);
            }
            catch (NamingException ne) {
                _logger.log(Level.SEVERE, "enterprise_naming.notfound_jmsdestination", destinationName);
                _logger.log(Level.SEVERE, ne.getClass().getName(), ne);
                destinationObject = null;
            }
            if (destinationObject == null) {
                destinationObject = new J2EEEnvWrapper(destinationName, 5);
            }
            if (destinationObject instanceof Queue ? !((JmsDestinationReferenceDescriptor)next).getRefType().equals("javax.jms.Queue") : destinationObject instanceof Topic && !((JmsDestinationReferenceDescriptor)next).getRefType().equals("javax.jms.Topic")) {
                throw new InvalidNameException(localStrings.getLocalString("naming.destinationRefTypeMismatch", "", new java.lang.Object[]{next.getName(), ((JmsDestinationReferenceDescriptor)next).getRefType()}));
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, localStrings.getLocalString("naming.bind", "Binding name:{0}", new java.lang.Object[]{logicalJndiName}));
            }
            if (namespace.put(logicalJndiName, destinationObject) != null) {
                _logger.log(Level.WARNING, localStrings.getLocalString("naming.alreadyexists", "Reference name [{0}] already exists in {1}", new java.lang.Object[]{next.getName(), this.getApplicationName(env)}));
            }
            this.bindIntermediateContexts(namespace, logicalJndiName);
        }
        itr = env.getEjbReferenceDescriptors().iterator();
        while (itr.hasNext()) {
            next = (EjbReferenceDescriptor)itr.next();
            logicalJndiName = this.descriptorToLogicalJndiName(next);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, localStrings.getLocalString("naming.bind", "Binding name:{0}", new java.lang.Object[]{logicalJndiName}));
            }
            String jndiName = ((EjbReferenceDescriptor)next).getValue();
            J2EEEnvWrapper home = null;
            home = ((EjbReferenceDescriptor)next).isLocal() ? new J2EEEnvWrapper(jndiName, 4) : new J2EEEnvWrapper(jndiName, 3);
            if (namespace.put(logicalJndiName, home) != null) {
                _logger.log(Level.WARNING, localStrings.getLocalString("naming.alreadyexists", "Reference name [{0}] already exists in {1}", new java.lang.Object[]{next.getName(), this.getApplicationName(env)}));
            }
            this.bindIntermediateContexts(namespace, logicalJndiName);
        }
        itr = env.getMessageDestinationReferenceDescriptors().iterator();
        while (itr.hasNext()) {
            next = (MessageDestinationReferenceDescriptor)itr.next();
            logicalJndiName = this.descriptorToLogicalJndiName(next);
            if (!((MessageDestinationReferenceDescriptor)next).isLinkedToMessageDestination()) {
                String msg = localStrings.getLocalString("naming.unresolvedmsgdestref", "Message Destination Reference {0} has not been linked to a Message Destination", new java.lang.Object[]{logicalJndiName});
                _logger.log(Level.SEVERE, "naming.unresolvedmsgdestref", new java.lang.Object[]{logicalJndiName});
                throw new NamingException(msg);
            }
            destinationName = ((MessageDestinationReferenceDescriptor)next).getMessageDestination().getJndiName();
            try {
                java.lang.Object adminObject = this.initialContext.lookup(destinationName);
                _logger.log(Level.INFO, localStrings.getLocalString("naming.bind", "Binding name:`{0}`", new java.lang.Object[]{logicalJndiName}));
                namespace.put(logicalJndiName, adminObject);
                this.bindIntermediateContexts(namespace, logicalJndiName);
            }
            catch (Exception e) {
                String msg = localStrings.getLocalString("naming.invalidDestination", "Invalid Destination:`{0} for {1}`", new java.lang.Object[]{destinationName, logicalJndiName});
                _logger.log(Level.SEVERE, "naming.invalidDestination", new java.lang.Object[]{destinationName, logicalJndiName});
                NamingException ne = new NamingException();
                ne.initCause(e);
                throw ne;
            }
        }
        itr = env.getResourceReferenceDescriptors().iterator();
        while (itr.hasNext()) {
            String msg;
            java.lang.Object res;
            String resJndi;
            next = (ResourceReferenceDescriptor)itr.next();
            ((ResourceReferenceDescriptor)next).checkType();
            String logicalResRef = next.getName();
            String logicalJndiName2 = this.descriptorToLogicalJndiName(next);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, localStrings.getLocalString("naming.bind", "Binding name:{0}", new java.lang.Object[]{logicalJndiName2}));
            }
            if ((resJndi = next.getValue()) == null || resJndi.equals("")) {
                throw new InvalidNameException("Real JNDI name cannot be empty for " + logicalResRef);
            }
            java.lang.Object obj = null;
            if (((ResourceReferenceDescriptor)next).isMailResource()) {
                obj = new J2EEEnvWrapper(resJndi, 2);
            } else if (((ResourceReferenceDescriptor)next).isURLResource()) {
                String url = ((ResourceReferenceDescriptor)next).getJndiName();
                try {
                    obj = new URL(url);
                }
                catch (MalformedURLException e) {
                    throw new InvalidNameException(localStrings.getLocalString("naming.malformedURL", "Malformed URL:'{0}'", new java.lang.Object[]{url}));
                }
                obj = new J2EEEnvWrapper(obj, 1);
            } else if (this.isConnector(logicalJndiName2)) {
                obj = new J2EEEnvWrapper(resJndi, 7);
            } else if (((ResourceReferenceDescriptor)next).isJDBCResource()) {
                try {
                    res = this.initialContext.lookup(resJndi);
                    obj = new J2EEEnvWrapper(res, 8);
                }
                catch (NamingException ne) {
                    msg = localStrings.getLocalString("naming.unresolved.warning", "", new java.lang.Object[]{logicalJndiName2, resJndi});
                    _logger.log(Level.FINE, msg);
                }
                if (obj == null) {
                    obj = new J2EEEnvWrapper(resJndi, 5);
                }
            } else {
                try {
                    res = this.initialContext.lookup(resJndi);
                    obj = new J2EEEnvWrapper(res, 1);
                }
                catch (NamingException ne) {
                    msg = localStrings.getLocalString("naming.unresolved.warning", "", new java.lang.Object[]{logicalJndiName2, resJndi});
                    _logger.log(Level.FINE, msg);
                }
                if (obj == null) {
                    obj = new J2EEEnvWrapper(resJndi, 5);
                }
            }
            if (namespace.put(logicalJndiName2, obj) != null) {
                _logger.log(Level.WARNING, localStrings.getLocalString("naming.alreadyexists", "Reference name [{0}] already exists in {1}", new java.lang.Object[]{next.getName(), this.getApplicationName(env)}));
            }
            this.bindIntermediateContexts(namespace, logicalJndiName2);
        }
        itr = env.getServiceReferenceDescriptors().iterator();
        while (itr.hasNext()) {
            next = (ServiceReferenceDescriptor)itr.next();
            logicalJndiName = this.descriptorToLogicalJndiName(next);
            if (((ServiceReferenceDescriptor)next).hasWsdlFile() && !((ServiceReferenceDescriptor)next).hasServiceName()) {
                throw new NamingException("Deployment error for service-ref " + logicalJndiName + ".  Can't find service-qname.");
            }
            J2EEEnvWrapper serviceRefObject = new J2EEEnvWrapper(next, 9);
            _logger.log(Level.INFO, "naming.bind", new java.lang.Object[]{logicalJndiName});
            namespace.put(logicalJndiName, serviceRefObject);
            this.bindIntermediateContexts(namespace, logicalJndiName);
        }
        return componentId;
    }

    private void bindIntermediateContexts(HashMap namespace, String name) throws NamingException {
        name = name.substring("java:comp/".length());
        StringTokenizer toks = new StringTokenizer(name, CONTEXT_SEPARATOR, false);
        String partialName = "java:comp";
        while (toks.hasMoreTokens()) {
            String tok = toks.nextToken();
            if (namespace.get(partialName = partialName + CONTEXT_SEPARATOR + tok) != null) continue;
            namespace.put(partialName, new javaURLContext(partialName, null));
        }
    }

    public void unbindObjects(JndiNameEnvironment env) throws NamingException {
        String componentId = this.getMangledIdName(env);
        this.namespaces.remove(componentId);
    }

    public Context restoreJavaCompEnvContext(String contextName) throws NamingException {
        if (!contextName.startsWith("java:")) {
            throw new NamingException("Invalid context name [" + contextName + "]. Name must start with java:");
        }
        return new javaURLContext(contextName, null);
    }

    public java.lang.Object lookup(String name) throws NamingException {
        return this.lookup(name, null);
    }

    public java.lang.Object lookup(String name, SerialContext serialContext) throws NamingException {
        String componentId;
        HashMap namespace;
        java.lang.Object obj;
        _logger.fine("serialcontext in NamingManagerImpl.." + serialContext);
        Context ic = null;
        ic = serialContext != null ? serialContext : this.initialContext;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "NamingManagerImpl : looking up name : " + name);
        }
        if ((obj = (namespace = (HashMap)this.namespaces.get(componentId = this.getComponentId())).get(name)) == null) {
            throw new NameNotFoundException("No object bound to name " + name);
        }
        if (obj instanceof J2EEEnvWrapper) {
            J2EEEnvWrapper wr = (J2EEEnvWrapper)obj;
            switch (wr.type) {
                case 1: {
                    obj = this.copyMutableObject(wr.object);
                    break;
                }
                case 8: {
                    obj = wr.object;
                    break;
                }
                case 2: {
                    String resJndi = (String)wr.object;
                    MailConfiguration config = (MailConfiguration)ic.lookup(resJndi);
                    Session s = Session.getInstance((Properties)config.getMailProperties(), null);
                    s.setDebugOut(new PrintStream(new MailLogOutputStream()));
                    s.setDebug(true);
                    obj = s;
                    break;
                }
                case 3: {
                    _logger.fine("EJB_REF..." + wr.object);
                    if (((String)wr.object).startsWith(CORBANAME)) {
                        ORB orb = ORBManager.getORB();
                        obj = orb.string_to_object((String)wr.object);
                    } else {
                        obj = ic.lookup((String)wr.object);
                    }
                    if (serialContext != null) break;
                    namespace.put(name, obj);
                    break;
                }
                case 4: {
                    obj = this.theSwitch.getLocalHome((String)wr.object);
                    if (obj == null) {
                        throw new NamingException("EJBLocalHome lookup failed for " + (String)wr.object);
                    }
                    namespace.put(name, obj);
                    break;
                }
                case 5: {
                    obj = ic.lookup((String)wr.object);
                    wr = new J2EEEnvWrapper(obj, 1);
                    if (serialContext != null) break;
                    namespace.put(name, wr);
                    break;
                }
                case 6: {
                    obj = wr.object;
                    break;
                }
                case 7: {
                    obj = ic.lookup((String)wr.object);
                    break;
                }
                case 9: {
                    ServiceReferenceDescriptor desc = (ServiceReferenceDescriptor)wr.object;
                    obj = this.getClientServiceObject(desc);
                    namespace.put(name, obj);
                }
            }
        }
        if (obj instanceof javaURLContext && serialContext != null) {
            return ((javaURLContext)obj).addStickyContext(serialContext);
        }
        return obj;
    }

    private java.lang.Object copyMutableObject(java.lang.Object obj) {
        if (obj instanceof Serializable) {
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(bos);
                oos.writeObject(obj);
                oos.flush();
                byte[] data = bos.toByteArray();
                oos.close();
                bos.close();
                ByteArrayInputStream bis = new ByteArrayInputStream(data);
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                ObjectInputStreamWithLoader ois = new ObjectInputStreamWithLoader(bis, cl);
                return ois.readObject();
            }
            catch (Exception ex) {
                _logger.log(Level.SEVERE, "enterprise_naming.excep_in_copymutableobj", ex);
                RuntimeException re = new RuntimeException("Cant copy Serializable object:");
                re.initCause(ex);
                throw re;
            }
        }
        return obj;
    }

    private void resolvePortComponentLinks(ServiceReferenceDescriptor desc) throws Exception {
        Iterator iter = desc.getPortsInfo().iterator();
        while (iter.hasNext()) {
            ServiceRefPortInfo portInfo = (ServiceRefPortInfo)iter.next();
            if (!portInfo.isLinkedToPortComponent()) continue;
            WebServiceEndpoint linkedPortComponent = portInfo.getPortComponentLink();
            if (portInfo.hasWsdlPort()) continue;
            portInfo.setWsdlPort(linkedPortComponent.getWsdlPort());
        }
    }

    private java.lang.Object getClientServiceObject(ServiceReferenceDescriptor desc) throws NamingException {
        Class<?> serviceInterfaceClass = null;
        java.lang.Object returnObj = null;
        WsUtil wsUtil = new WsUtil();
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            serviceInterfaceClass = cl.loadClass(desc.getServiceInterface());
            this.resolvePortComponentLinks(desc);
            Service serviceDelegate = null;
            if (desc.hasGeneratedServiceInterface() || desc.hasWsdlFile()) {
                String serviceImplName = desc.getServiceImplClassName();
                Class<?> serviceImplClass = cl.loadClass(serviceImplName);
                serviceDelegate = (Service)serviceImplClass.newInstance();
                if (desc.hasHandlers()) {
                    Service configuredService = wsUtil.createConfiguredService(desc);
                    Iterator ports = configuredService.getPorts();
                    wsUtil.configureHandlerChain(desc, serviceDelegate, ports, cl);
                }
            } else {
                QName serviceName = desc.getServiceName();
                if (serviceName == null) {
                    serviceName = new QName("urn:noservice", "servicename");
                }
                ServiceFactory serviceFac = ServiceFactory.newInstance();
                serviceDelegate = serviceFac.createService(serviceName);
            }
            ServiceInvocationHandler handler = new ServiceInvocationHandler(desc, serviceDelegate, cl);
            returnObj = Proxy.newProxyInstance(cl, new Class[]{serviceInterfaceClass}, (InvocationHandler)handler);
        }
        catch (PrivilegedActionException pae) {
            _logger.log(Level.WARNING, "", pae);
            NamingException ne = new NamingException();
            ne.initCause(pae.getCause());
            throw ne;
        }
        catch (Exception e) {
            _logger.log(Level.WARNING, "", e);
            NamingException ne = new NamingException();
            ne.initCause(e);
            throw ne;
        }
        return returnObj;
    }

    public NamingEnumeration list(String name) throws NamingException {
        ArrayList list = this.listNames(name);
        return new NamePairsEnum(this, list.iterator());
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        ArrayList list = this.listNames(name);
        return new BindingsEnum(this, list.iterator());
    }

    private ArrayList listNames(String name) throws NamingException {
        String componentId = this.getComponentId();
        HashMap namespace = (HashMap)this.namespaces.get(componentId);
        java.lang.Object obj = namespace.get(name);
        if (obj == null) {
            throw new NameNotFoundException("No object bound to name " + name);
        }
        if (!(obj instanceof javaURLContext)) {
            throw new NotContextException(name + " cannot be listed");
        }
        ArrayList<String> list = new ArrayList<String>();
        Iterator itr = namespace.keySet().iterator();
        if (!name.endsWith(CONTEXT_SEPARATOR)) {
            name = name + CONTEXT_SEPARATOR;
        }
        while (itr.hasNext()) {
            String key = (String)itr.next();
            if (!key.startsWith(name) || key.indexOf(47, name.length()) != -1) continue;
            list.add(key);
        }
        return list;
    }

    private String getComponentId() throws NamingException {
        String id = null;
        ComponentInvocation ci = this.im.getCurrentInvocation();
        if (ci == null) {
            throw new NamingException("invocation exception ");
        }
        try {
            java.lang.Object containerContext = ci.getContainerContext();
            if (containerContext == null) {
                throw new NamingException("No container context");
            }
            if (containerContext instanceof Container) {
                return ((Container)containerContext).getComponentId();
            }
            JndiNameEnvironment desc = (JndiNameEnvironment)this.theSwitch.getDescriptorFor(containerContext);
            id = this.getMangledIdName(desc);
        }
        catch (InvocationException e) {
            NamingException ine = new NamingException("invocation exception");
            ine.initCause(e);
            throw ine;
        }
        return id;
    }

    private String descriptorToLogicalJndiName(Descriptor descriptor) {
        return JAVA_COMP_STRING + descriptor.getName();
    }

    private int getComponentType(JndiNameEnvironment env) {
        int componentType = 0;
        if (env instanceof EjbDescriptor) {
            componentType = 1;
        } else if (env instanceof WebBundleDescriptor) {
            componentType = 2;
        } else if (env instanceof ApplicationClientDescriptor) {
            componentType = 3;
        } else {
            throw new IllegalArgumentException("Unknown component type" + env);
        }
        return componentType;
    }

    private String getMangledIdName(JndiNameEnvironment env) {
        String id = null;
        int componentType = this.getComponentType(env);
        switch (componentType) {
            case 1: {
                EjbDescriptor ejbEnv = (EjbDescriptor)env;
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "Application:" + ejbEnv.getApplication());
                }
                String flattedJndiName = ejbEnv.getJndiName().replace('/', '.');
                EjbBundleDescriptor ejbBundle = ejbEnv.getEjbBundleDescriptor();
                id = ejbEnv.getApplication().getName() + ID_SEPARATOR + ejbBundle.getModuleDescriptor().getArchiveUri() + ID_SEPARATOR + ejbEnv.getName() + ID_SEPARATOR + flattedJndiName;
                break;
            }
            case 2: {
                WebBundleDescriptor webEnv = (WebBundleDescriptor)env;
                id = webEnv.getApplication().getName() + ID_SEPARATOR + webEnv.getContextRoot();
                break;
            }
            case 3: {
                ApplicationClientDescriptor appEnv = (ApplicationClientDescriptor)env;
                id = "client_" + appEnv.getName() + ID_SEPARATOR + appEnv.getMainClassName();
            }
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Component Id: " + id);
        }
        return id;
    }

    private boolean isCOSNamingObj(java.lang.Object obj) {
        return obj instanceof Remote || obj instanceof Object;
    }

    private String getApplicationName(JndiNameEnvironment env) {
        String appName = "";
        int componentType = this.getComponentType(env);
        String moduleName = "";
        switch (componentType) {
            case 1: {
                EjbDescriptor ejbEnv = (EjbDescriptor)env;
                EjbBundleDescriptor ejbBundle = ejbEnv.getEjbBundleDescriptor();
                appName = "ejb [" + ejbEnv.getApplication().getRegistrationName();
                moduleName = ejbEnv.getName();
                if (moduleName == null || moduleName.equals("")) {
                    appName = appName + "]";
                    break;
                }
                appName = appName + ":" + ejbEnv.getName() + "]";
                break;
            }
            case 2: {
                WebBundleDescriptor webEnv = (WebBundleDescriptor)env;
                appName = "web module [" + webEnv.getApplication().getRegistrationName();
                moduleName = webEnv.getContextRoot();
                if (moduleName == null || moduleName.equals("")) {
                    appName = appName + "]";
                    break;
                }
                appName = appName + ":" + webEnv.getContextRoot() + "]";
                break;
            }
            case 3: {
                ApplicationClientDescriptor appEnv = (ApplicationClientDescriptor)env;
                appName = "client [" + appEnv.getName() + ":" + appEnv.getMainClassName() + "]";
            }
        }
        return appName;
    }

    private boolean isConnector(String logicalJndiName) {
        return logicalJndiName.indexOf(EIS_STRING) != -1;
    }
}

