/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.instance;

import com.sun.enterprise.deployment.backend.DeployableObjectType;
import com.sun.enterprise.instance.ExceptionType;
import com.sun.enterprise.instance.InstanceEnvironment;
import com.sun.enterprise.instance.Localizer;
import com.sun.enterprise.util.StringUtils;

public class ModuleEnvironment {
    private String mModuleName = null;
    private String mModulePath = null;
    private String mModuleBackupPath = null;
    private String mModuleGeneratedXMLPath = null;
    private String mModuleStubPath = null;
    private String mModuleJSPPath = null;
    private InstanceEnvironment mInstance = null;
    private DeployableObjectType mType = null;

    public ModuleEnvironment(InstanceEnvironment instance, String moduleName, DeployableObjectType type) {
        if (instance == null || moduleName == null) {
            throw new IllegalArgumentException();
        }
        if (type == null) {
            throw new IllegalArgumentException(Localizer.getValue(ExceptionType.NULL_MODULE_TYPE));
        }
        this.mType = type;
        this.mInstance = instance;
        this.mModuleName = moduleName;
        this.createModulePath();
        this.createModuleBackupPath();
        this.createModuleStubPath();
        this.createModuleJSPPath();
        this.createModuleGeneratedXMLPath();
    }

    private void createModulePath() {
        String moduleRepositoryDirPath = this.mInstance.getModuleRepositoryPath();
        String[] onlyFolderNames = new String[]{moduleRepositoryDirPath, this.mModuleName};
        this.mModulePath = StringUtils.makeFilePath((String[])onlyFolderNames, (boolean)false);
    }

    public String getModulePath() {
        return this.mModulePath;
    }

    public void createModuleGeneratedXMLPath() {
        String[] onlyFolderNames = new String[]{this.mInstance.getModuleGeneratedXMLPath(), this.mModuleName};
        this.mModuleGeneratedXMLPath = StringUtils.makeFilePath((String[])onlyFolderNames, (boolean)false);
    }

    public String getModuleGeneratedXMLPath() {
        return this.mModuleGeneratedXMLPath;
    }

    public void createModuleStubPath() {
        String[] onlyFolderNames = new String[]{this.mInstance.getModuleStubPath(), this.mModuleName};
        this.mModuleStubPath = StringUtils.makeFilePath((String[])onlyFolderNames, (boolean)false);
    }

    public String getModuleStubPath() {
        return this.mModuleStubPath;
    }

    public void createModuleJSPPath() {
        String[] onlyFolderNames = new String[]{this.mInstance.getWebModuleCompileJspPath(), this.mModuleName};
        this.mModuleJSPPath = StringUtils.makeFilePath((String[])onlyFolderNames, (boolean)false);
    }

    public String getModuleJSPPath() {
        return this.mModuleJSPPath;
    }

    public String getModuleBackupPath() {
        return this.mModuleBackupPath;
    }

    public void createModuleBackupPath() {
        String[] onlyFolderNames = new String[]{this.mInstance.getModuleBackupRepositoryPath(), this.mModuleName};
        this.mModuleBackupPath = StringUtils.makeFilePath((String[])onlyFolderNames, (boolean)false);
    }

    public String verify() {
        return null;
    }
}

