/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.instance;

import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigBeansFactory;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.ConfigFactory;
import com.sun.enterprise.config.serverbeans.ServerTags;
import com.sun.enterprise.config.serverbeans.ServerXPathHelper;
import com.sun.enterprise.instance.ExceptionType;
import com.sun.enterprise.instance.InstanceEnvironment;
import com.sun.enterprise.instance.Localizer;
import com.sun.enterprise.instance.ServerManager;
import com.sun.enterprise.util.OS;
import com.sun.enterprise.util.StringUtils;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class InstanceDefinition {
    public static final int DEFAULT_PORT = 80;
    public static final int DEFAULT_JMS_PORT = 7676;
    public static final String DEFAULT_JMS_USER = "admin";
    public static final String DEFAULT_JMS_PW = "admin";
    public static final String SPACE = " ";
    public static final String WINDOWS_BIN_EXT = ".exe";
    public static final String BIN_DIR_NAME = "bin";
    public static final String LIB_DIR_NAME = "lib";
    private String mJavaHome = System.getProperty("java.home");
    private String mImqHome = null;
    private String mServerName = null;
    private int mHttpPort = 80;
    private String mIdentifier = null;
    private String mMailHost = null;
    private String mUser = null;
    private String mDocRoot = null;
    private String mPortString = null;
    private int mJMSPort = 7676;
    private String mJMSPortString = null;
    private String mJMSUser = null;
    private String mJMSPasswd = null;
    public static final String UNIX_START_COMMAND_NAME = "startserv";
    public static final String UNIX_STOP_COMMAND_NAME = "stopserv";
    public static final String UNIX_GETTOKENS_COMMAND_NAME = "gettokens";
    public static final String UNIX_RESTART_COMMAND_NAME = "restartserv";
    public static final String WIN_START_COMMAND_NAME = "startsec.exe";
    public static final String WIN_STOP_COMMAND_NAME = "stopserv.bat";
    public static final String WIN_GETTOKENS_COMMAND_NAME = "gettokens.exe";
    public final String JMS_NODE_PATH = ServerXPathHelper.XPATH_JMS_SERVICE;

    public InstanceDefinition(String serverName, int httpPort, String identifier, String mailHost, String user, String docRoot, int jmsPort, String jmsUser, String jmsPasswd) {
        this.initialize(serverName, httpPort, identifier, mailHost, user, docRoot, jmsPort, jmsUser, jmsPasswd);
    }

    public InstanceDefinition(String id, int port) {
        if (id == null || port <= 0) {
            throw new IllegalArgumentException(Localizer.getValue(ExceptionType.ILLEGAL_PORT));
        }
        String serverName = this.createLocalHostName();
        String mailHost = this.createLocalHostName();
        String user = System.getProperty("user.name");
        String docRoot = ServerManager.INSTANCE_CFG_ROOT + "/" + "docroot";
        this.initialize(serverName, port, id, mailHost, user, docRoot, 7676, "admin", "admin");
    }

    private void initialize(String serverName, int httpPort, String identifier, String mailHost, String user, String docRoot, int jmsPort, String jmsUser, String jmsPasswd) {
        if (serverName == null || identifier == null || mailHost == null || user == null || user == null || docRoot == null || jmsUser == null || jmsPasswd == null) {
            throw new IllegalArgumentException();
        }
        if (httpPort <= 0 || jmsPort <= 0) {
            throw new IllegalArgumentException();
        }
        this.mServerName = serverName;
        this.mHttpPort = httpPort;
        this.mIdentifier = identifier;
        this.mMailHost = mailHost;
        this.mUser = user;
        this.mDocRoot = docRoot;
        this.mPortString = "" + this.mHttpPort;
        this.mJMSPort = jmsPort;
        this.mJMSPortString = jmsPort + "";
        this.mJMSUser = jmsUser;
        this.mJMSPasswd = jmsPasswd;
    }

    public String getID() {
        return this.mIdentifier;
    }

    public int getPort() {
        return this.mHttpPort;
    }

    public String getServerName() {
        return this.mServerName;
    }

    public String getAdminJavaHome() throws ConfigException {
        InstanceEnvironment instanceEnvironment = new InstanceEnvironment("admin-server");
        String fileUrl = instanceEnvironment.getConfigFilePath();
        ConfigContext configContext = ConfigFactory.createConfigContext(fileUrl);
        ConfigBean configbean = ConfigBeansFactory.getConfigBeanByXPath(configContext, ServerXPathHelper.XPATH_JAVACONFIG);
        this.mJavaHome = configbean.getAttributeValue(ServerTags.JAVA_HOME);
        return this.mJavaHome;
    }

    public String getDocRoot() {
        return this.mDocRoot;
    }

    private String createLocalHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException ue) {
            return "localhost";
        }
    }

    public String[] getStartCommand() {
        String[] startCommand = null;
        startCommand = OS.isWindows() ? this.getCompleteWindowsStartCommand() : this.getCompleteNonWindowsStartCommand();
        return startCommand;
    }

    private String[] getCompleteWindowsStartCommand() {
        String[] names = new String[]{System.getProperty("com.sun.aas.installRoot"), BIN_DIR_NAME, WIN_START_COMMAND_NAME};
        String programName = StringUtils.makeFilePath((String[])names, (boolean)false);
        return new String[]{programName, this.mIdentifier, System.getProperty("com.sun.aas.instanceRoot")};
    }

    private String[] getCompleteNonWindowsStartCommand() {
        String[] names = new String[]{System.getProperty("com.sun.aas.instanceRoot"), BIN_DIR_NAME, UNIX_START_COMMAND_NAME};
        String programName = StringUtils.makeFilePath((String[])names, (boolean)false);
        return new String[]{programName};
    }

    public String[] getGetSecurityTokensCommand() {
        String[] command = null;
        String onlyCommand = null;
        onlyCommand = OS.isWindows() ? this.getWindowsSecTokensCommand() : this.getNonWindowsSecTokensCommand();
        command = new String[]{onlyCommand, this.mIdentifier, System.getProperty("com.sun.aas.instanceRoot")};
        return command;
    }

    private String getWindowsSecTokensCommand() {
        String[] names = new String[]{System.getProperty("com.sun.aas.installRoot"), BIN_DIR_NAME, WIN_GETTOKENS_COMMAND_NAME};
        return StringUtils.makeFilePath((String[])names, (boolean)false);
    }

    private String getNonWindowsSecTokensCommand() {
        String[] names = new String[]{System.getProperty("com.sun.aas.installRoot"), LIB_DIR_NAME, UNIX_GETTOKENS_COMMAND_NAME};
        return StringUtils.makeFilePath((String[])names, (boolean)false);
    }

    public String[] getStopCommand() {
        String[] stopCommand = new String[1];
        String command = null;
        command = OS.isWindows() ? WIN_STOP_COMMAND_NAME : UNIX_STOP_COMMAND_NAME;
        String[] names = new String[]{System.getProperty("com.sun.aas.instanceRoot"), BIN_DIR_NAME, command};
        stopCommand[0] = StringUtils.makeFilePath((String[])names, (boolean)false);
        return stopCommand;
    }

    public String[] getRestartCommand() {
        if (OS.isWindows()) {
            throw new UnsupportedOperationException(Localizer.getValue(ExceptionType.ILLEGAL_RESTART));
        }
        String[] restartCommand = new String[1];
        String[] names = new String[]{System.getProperty("com.sun.aas.instanceRoot"), BIN_DIR_NAME, UNIX_RESTART_COMMAND_NAME};
        restartCommand[0] = StringUtils.makeFilePath((String[])names, (boolean)false);
        return restartCommand;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.mServerName);
        sb.append(SPACE + this.mPortString);
        sb.append(SPACE + this.mIdentifier);
        sb.append(SPACE + this.mMailHost);
        sb.append(SPACE + this.mUser);
        sb.append(SPACE + this.mDocRoot);
        return sb.toString();
    }

    public void setUser(String user) {
        if (user != null && user.length() > 0) {
            this.mUser = user;
        }
    }

    public String getUser() {
        return this.mUser;
    }
}

