/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.iiop.security;

import com.sun.corba.ee.org.omg.CSIIOP.AS_ContextSec;
import com.sun.corba.ee.org.omg.CSIIOP.CompoundSecMech;
import com.sun.corba.ee.org.omg.CSIIOP.SAS_ContextSec;
import com.sun.corba.ee.org.omg.CSIIOP.TLS_SEC_TRANS;
import com.sun.corba.ee.spi.ior.IOR;
import com.sun.corba.ee.spi.ior.iiop.IIOPAddress;
import com.sun.corba.ee.spi.ior.iiop.IIOPProfileTemplate;
import com.sun.corba.ee.spi.transport.SocketInfo;
import com.sun.enterprise.ComponentInvocation;
import com.sun.enterprise.InvocationManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.appclient.AppContainer;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbIORConfigurationDescriptor;
import com.sun.enterprise.iiop.CSIV2TaggedComponentInfo;
import com.sun.enterprise.iiop.IORToSocketInfoImpl;
import com.sun.enterprise.iiop.POAProtocolMgr;
import com.sun.enterprise.iiop.security.AnonCredential;
import com.sun.enterprise.iiop.security.ConnectionContext;
import com.sun.enterprise.iiop.security.ConnectionExecutionContext;
import com.sun.enterprise.iiop.security.GSSUPName;
import com.sun.enterprise.iiop.security.GSSUtils;
import com.sun.enterprise.iiop.security.InvalidIdentityTokenException;
import com.sun.enterprise.iiop.security.InvalidMechanismException;
import com.sun.enterprise.iiop.security.SecServerRequestInterceptor;
import com.sun.enterprise.iiop.security.SecurityContext;
import com.sun.enterprise.iiop.security.SecurityMechanismException;
import com.sun.enterprise.iiop.security.ServerConnectionContext;
import com.sun.enterprise.security.ClientSecurityContext;
import com.sun.enterprise.security.SSLUtils;
import com.sun.enterprise.security.auth.LoginContextDriver;
import com.sun.enterprise.security.auth.login.PasswordCredential;
import com.sun.enterprise.security.auth.login.X509CertificateCredential;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.ORBManager;
import com.sun.enterprise.util.TypeUtil;
import com.sun.enterprise.util.Utility;
import com.sun.logging.LogDomains;
import java.net.InetAddress;
import java.net.Socket;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.security.auth.Subject;
import org.omg.CORBA.ORB;
import sun.security.x509.X500Name;

public final class SecurityMechanismSelector {
    private static Logger _logger = null;
    public static final String CLIENT_CONNECTION_CONTEXT = "ClientConnContext";
    public static final String SERVER_CONNECTION_CONTEXT = "ServerConnContext";
    private static Set corbaIORDescSet;
    private static boolean sslRequired;
    private static String[] serverTrustedHosts;
    private static LocalStringManagerImpl localStrings;
    private static POAProtocolMgr protocolMgr;
    private CompoundSecMech mechanism = null;
    private ORB orb = ORBManager.getORB();
    private CSIV2TaggedComponentInfo ctc = new CSIV2TaggedComponentInfo(this.orb);

    public static ServerConnectionContext getServerConnectionContext() {
        Hashtable h = ConnectionExecutionContext.getContext();
        ServerConnectionContext scc = (ServerConnectionContext)h.get(SERVER_CONNECTION_CONTEXT);
        return scc;
    }

    public static void setServerConnectionContext(ServerConnectionContext scc) {
        Hashtable h = ConnectionExecutionContext.getContext();
        h.put(SERVER_CONNECTION_CONTEXT, scc);
    }

    public ConnectionContext getClientConnectionContext() {
        Hashtable h = ConnectionExecutionContext.getContext();
        ConnectionContext scc = (ConnectionContext)h.get(CLIENT_CONNECTION_CONTEXT);
        return scc;
    }

    public void setClientConnectionContext(ConnectionContext scc) {
        Hashtable h = ConnectionExecutionContext.getContext();
        h.put(CLIENT_CONNECTION_CONTEXT, scc);
    }

    public SocketInfo getSSLPort(IOR ior, ConnectionContext ctx) {
        SocketInfo info = null;
        try {
            this.mechanism = this.selectSecurityMechanism(ior);
        }
        catch (SecurityMechanismException sme) {
            throw new RuntimeException(sme.getMessage());
        }
        ctx.setIOR(ior);
        ctx.setMechanism(this.mechanism);
        TLS_SEC_TRANS ssl = null;
        if (this.mechanism != null) {
            ssl = this.ctc.getSSLInformation(this.mechanism);
        }
        if (ssl == null) {
            if (sslRequired) {
                IIOPProfileTemplate templ = (IIOPProfileTemplate)ior.getProfile().getTaggedProfileTemplate();
                IIOPAddress addr = templ.getPrimaryAddress();
                info = IORToSocketInfoImpl.createSocketInfo("SecurityMechanismSelector1", "SSL", addr.getHost(), ORBManager.getORBInitialPort());
                return info;
            }
            return null;
        }
        short targetRequires = ssl.target_requires;
        short targetSupports = ssl.target_supports;
        if (this.isSet(targetRequires, 2) || this.isSet(targetRequires, 4) || this.isSet(targetRequires, 64)) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Target requires SSL");
            }
            ctx.setSSLUsed(true);
            String type = "SSL";
            if (this.isSet(targetRequires, 64)) {
                type = "SSL_MUTUALAUTH";
                ctx.setSSLClientAuthenticationOccurred(true);
            }
            short sslport = ssl.addresses[0].port;
            int ssl_port = Utility.shortToInt(sslport);
            String host_name = ssl.addresses[0].host_name;
            info = IORToSocketInfoImpl.createSocketInfo("SecurityMechanismSelector2", type, host_name, ssl_port);
            return info;
        }
        if (this.isSet(targetSupports, 2) || this.isSet(targetSupports, 4) || this.isSet(targetSupports, 64)) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Target supports SSL");
            }
            if (sslRequired) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "Client is configured to require SSL for the target");
                }
                ctx.setSSLUsed(true);
                short sslport = ssl.addresses[0].port;
                String host_name = ssl.addresses[0].host_name;
                int ssl_port = Utility.shortToInt(sslport);
                info = IORToSocketInfoImpl.createSocketInfo("SecurityMechanismSelector3", "SSL", host_name, ssl_port);
                return info;
            }
            return null;
        }
        if (sslRequired) {
            throw new RuntimeException("SSL required by client but not supported by server.");
        }
        return null;
    }

    public SecurityContext selectSecurityContext(IOR ior) throws InvalidIdentityTokenException, InvalidMechanismException, SecurityMechanismException {
        SecurityContext context = null;
        ConnectionContext cc = this.getClientConnectionContext();
        if (cc == null) {
            return null;
        }
        this.mechanism = cc.getMechanism();
        if (this.mechanism == null) {
            return null;
        }
        boolean sslUsed = cc.getSSLUsed();
        boolean clientAuthOccurred = cc.getSSLClientAuthenticationOccurred();
        InvocationManager im = Switch.getSwitch().getInvocationManager();
        if (im == null) {
            context = this.getSecurityContextForAppClient(null, sslUsed, clientAuthOccurred);
            return context;
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "SSL used:" + sslUsed + " SSL Mutual auth:" + clientAuthOccurred);
        }
        ComponentInvocation ci = null;
        ci = im.getCurrentInvocation();
        if (ci == null) {
            return null;
        }
        Object obj = ci.getContainerContext();
        context = obj instanceof AppContainer ? this.getSecurityContextForAppClient(ci, sslUsed, clientAuthOccurred) : this.getSecurityContextForWebOrEJB(ci, sslUsed, clientAuthOccurred);
        return context;
    }

    public SecurityContext getSecurityContextForAppClient(ComponentInvocation ci, boolean sslUsed, boolean clientAuthOccurred) throws InvalidMechanismException, InvalidIdentityTokenException, SecurityMechanismException {
        return this.sendUsernameAndPassword(ci, sslUsed, clientAuthOccurred);
    }

    public SecurityContext getSecurityContextForWebOrEJB(ComponentInvocation ci, boolean sslUsed, boolean clientAuthOccurred) throws InvalidMechanismException, InvalidIdentityTokenException, SecurityMechanismException {
        SecurityContext ctx = null;
        ctx = !sslUsed ? this.propagateIdentity(false, ci) : this.propagateIdentity(clientAuthOccurred, ci);
        return ctx;
    }

    private boolean isMechanismSupported(SAS_ContextSec sas) {
        byte[][] mechanisms = sas.supported_naming_mechanisms;
        byte[] mechSupported = new byte[]{};
        try {
            mechSupported = GSSUtils.getDER(GSSUtils.GSSUP_MECH_OID);
        }
        catch (Exception e) {
            return false;
        }
        if (mechanisms[0].length != mechSupported.length) {
            return false;
        }
        for (int i = 0; i < mechanisms[0].length; ++i) {
            if (mechanisms[0][i] == mechSupported[i]) continue;
            return false;
        }
        return true;
    }

    public boolean isIdentityTypeSupported(SAS_ContextSec sas) {
        int ident_token = sas.supported_identity_types;
        int value = ident_token & 0xF;
        return value != 0;
    }

    private SecurityContext sendUsernameAndPassword(ComponentInvocation ci, boolean sslUsed, boolean clientAuthOccurred) throws SecurityMechanismException {
        SecurityContext ctx = null;
        if (this.mechanism == null) {
            return null;
        }
        AS_ContextSec asContext = this.mechanism.as_context_mech;
        if (this.isSet(asContext.target_requires, 64) || this.isSet(this.mechanism.target_requires, 64) && !clientAuthOccurred) {
            ctx = this.getUsernameAndPassword(ci);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Sending Username/Password");
            }
        } else {
            return null;
        }
        return ctx;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private SecurityContext propagateIdentity(boolean clientAuth, ComponentInvocation ci) throws InvalidIdentityTokenException, InvalidMechanismException, SecurityMechanismException {
        SecurityContext ctx = null;
        if (this.mechanism == null) {
            return null;
        }
        AS_ContextSec asContext = this.mechanism.as_context_mech;
        SAS_ContextSec sasContext = this.mechanism.sas_context_mech;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "SAS CONTEXT's target_requires=" + sasContext.target_requires);
            _logger.log(Level.FINE, "SAS CONTEXT's target_supports=" + sasContext.target_supports);
        }
        if (this.isSet(asContext.target_requires, 64)) {
            ctx = this.getUsernameAndPassword(ci);
            if (ctx.authcls != null) return ctx;
            String errmsg = localStrings.getLocalString("securitymechansimselector.runas_cannot_propagate_username_password", "Cannot propagate username/password required by target when using run as identity");
            _logger.log(Level.SEVERE, "iiop.runas_error", errmsg);
            throw new SecurityMechanismException(errmsg);
        }
        if (this.isSet(sasContext.target_supports, 1024) || this.isSet(sasContext.target_requires, 1024)) {
            if (!this.isIdentityTypeSupported(sasContext)) {
                String errmsg = localStrings.getLocalString("securitymechanismselector.invalid_identity_type", "The given identity token is unsupported.");
                throw new InvalidIdentityTokenException(errmsg);
            }
            if (sasContext.target_supports != 1024) return this.getIdentity();
            if (this.isMechanismSupported(sasContext)) return this.getIdentity();
            String errmsg = localStrings.getLocalString("securitymechanismselector.invalid_mechanism", "The given mechanism type is unsupported.");
            _logger.log(Level.SEVERE, "iiop.unsupported_type_error", errmsg);
            throw new InvalidMechanismException(errmsg);
        }
        if (!this.isSet(asContext.target_supports, 64)) return null;
        if (!clientAuth) return null;
        ctx = this.getUsernameAndPassword(ci);
        if (ctx.authcls != null) return ctx;
        return null;
    }

    private boolean isServerTrusted() {
        String star = "*";
        for (int i = 0; i < serverTrustedHosts.length; ++i) {
            if (serverTrustedHosts[i].length() != 1 || !serverTrustedHosts[i].equals(star)) continue;
            return true;
        }
        ConnectionContext scc = this.getClientConnectionContext();
        if (scc != null) {
            Socket skt = scc.getSocket();
            InetAddress adr = skt.getInetAddress();
            return this.isDomainInTrustedList(adr, serverTrustedHosts);
        }
        return false;
    }

    private boolean isDomainInTrustedList(InetAddress inetAddress, String[] trusted) throws SecurityException {
        boolean isTrusted = false;
        String domain = null;
        String star = "*";
        String dot = ".";
        try {
            domain = inetAddress.getHostName();
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "iiop.domain_lookup_failed", inetAddress.getHostAddress());
            return false;
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, " Verifying if domain address =" + inetAddress.toString() + " is in the Trusted list ");
            _logger.log(Level.FINE, " the domain name is = " + domain);
        }
        String[] domainTok = TypeUtil.stringToArray(domain, dot);
        for (int i = 0; i < trusted.length; ++i) {
            String[] toksList = TypeUtil.stringToArray(trusted[i], dot);
            if (toksList.length != domainTok.length) {
                isTrusted = false;
                continue;
            }
            for (int j = toksList.length - 1; j >= 0; --j) {
                if (toksList[j].equals(domainTok[j])) {
                    isTrusted = true;
                    continue;
                }
                if (toksList[j].equals(star)) {
                    isTrusted = true;
                    continue;
                }
                isTrusted = false;
                break;
            }
            if (!isTrusted) continue;
            return isTrusted;
        }
        return isTrusted;
    }

    private SecurityContext getUsernameAndPassword(ComponentInvocation ci) throws SecurityMechanismException {
        try {
            Subject s = null;
            if (ci == null) {
                ClientSecurityContext sc = ClientSecurityContext.getCurrent();
                if (sc == null) {
                    return null;
                }
                s = sc.getSubject();
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "SUBJECT:" + s);
                }
            } else {
                ClientSecurityContext sc;
                Object obj = ci.getContainerContext();
                s = obj instanceof AppContainer ? ((sc = ClientSecurityContext.getCurrent()) == null ? LoginContextDriver.doClientLogin(1, AppContainer.getCallbackHandler()) : sc.getSubject()) : this.getSubjectFromSecurityCurrent();
            }
            SecurityContext ctx = new SecurityContext();
            final Subject sub = s;
            ctx.subject = s;
            Set privateCredSet = (Set)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return sub.getPrivateCredentials();
                }
            });
            if (privateCredSet.isEmpty()) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "no private credential run as mode");
                }
                ctx.authcls = null;
                ctx.identcls = GSSUPName.class;
            } else {
                AS_ContextSec asContext = this.mechanism.as_context_mech;
                byte[] target_name = asContext.target_name;
                byte[] _realm = GSSUtils.importName(GSSUtils.GSSUP_MECH_OID, target_name);
                final String realm_name = new String(_realm);
                final Iterator it = privateCredSet.iterator();
                while (it.hasNext()) {
                    AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            PasswordCredential pc = (PasswordCredential)it.next();
                            pc.setRealm(realm_name);
                            return null;
                        }
                    });
                }
                ctx.authcls = PasswordCredential.class;
            }
            return ctx;
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "iiop.user_password_exception", e);
            return null;
        }
    }

    private SecurityContext getIdentity() throws SecurityMechanismException {
        Subject s;
        SecurityContext ctx;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Getting PRINCIPAL/DN from TLS");
        }
        final SecurityContext sCtx = ctx = new SecurityContext();
        com.sun.enterprise.security.SecurityContext scontext = com.sun.enterprise.security.SecurityContext.getCurrent();
        if (scontext == null || scontext.didServerGenerateCredentials()) {
            sCtx.identcls = AnonCredential.class;
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Subject sub;
                    sCtx.subject = sub = new Subject();
                    sCtx.subject.getPublicCredentials().add(new AnonCredential());
                    return null;
                }
            });
            return sCtx;
        }
        ctx.subject = s = this.getSubjectFromSecurityCurrent();
        final Subject sub = s;
        Set<Object> credSet = (Set<Object>)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return sub.getPrivateCredentials(class$com$sun$enterprise$security$auth$login$PasswordCredential == null ? (class$com$sun$enterprise$security$auth$login$PasswordCredential = SecurityMechanismSelector.class$("com.sun.enterprise.security.auth.login.PasswordCredential")) : class$com$sun$enterprise$security$auth$login$PasswordCredential);
            }
        });
        if (credSet.size() == 1) {
            Subject subj;
            ctx.identcls = GSSUPName.class;
            final Set<Object> cs = credSet;
            ctx.subject = subj = (Subject)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Subject ss = new Subject();
                    Iterator iter = cs.iterator();
                    PasswordCredential pc = (PasswordCredential)iter.next();
                    GSSUPName gssname = new GSSUPName(pc.getUser(), pc.getRealm());
                    ss.getPublicCredentials().add(gssname);
                    return ss;
                }
            });
            return ctx;
        }
        credSet = s.getPublicCredentials();
        if (credSet.size() != 1) {
            _logger.log(Level.SEVERE, "iiop.principal_error");
            return null;
        }
        Iterator<Object> credIter = credSet.iterator();
        if (credIter.hasNext()) {
            Object o = credIter.next();
            ctx.identcls = o instanceof GSSUPName ? GSSUPName.class : (o instanceof X500Name ? X500Name.class : X509CertificateCredential.class);
        } else {
            _logger.log(Level.SEVERE, "iiop.credential_error");
            return null;
        }
        return ctx;
    }

    private Subject getSubjectFromSecurityCurrent() throws SecurityMechanismException {
        com.sun.enterprise.security.SecurityContext sc = null;
        sc = com.sun.enterprise.security.SecurityContext.getCurrent();
        if (sc == null) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, " SETTING GUEST ---");
            }
            sc = com.sun.enterprise.security.SecurityContext.init();
        }
        if (sc == null) {
            throw new SecurityMechanismException("Could not find  security information");
        }
        Subject s = sc.getSubject();
        if (s == null) {
            throw new SecurityMechanismException("Could not find  subject information in the security context.");
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Subject in security current:" + s);
        }
        return s;
    }

    public CompoundSecMech selectSecurityMechanism(IOR ior) throws SecurityMechanismException {
        CompoundSecMech[] mechList = this.ctc.getSecurityMechanisms(ior);
        CompoundSecMech mech = this.selectSecurityMechanism(mechList);
        return mech;
    }

    private CompoundSecMech selectSecurityMechanism(CompoundSecMech[] mechList) throws SecurityMechanismException {
        if (mechList == null || mechList.length == 0) {
            return null;
        }
        CompoundSecMech mech = null;
        for (int i = 0; i < mechList.length; ++i) {
            mech = mechList[i];
            boolean useMech = this.useMechanism(mech);
            if (!useMech) continue;
            return mech;
        }
        throw new SecurityMechanismException("Cannot use any of the  target's supported mechanisms");
    }

    private boolean useMechanism(CompoundSecMech mech) {
        boolean val = true;
        TLS_SEC_TRANS tls = this.ctc.getSSLInformation(mech);
        if (tls == null) {
            return true;
        }
        short targetRequires = tls.target_requires;
        if (this.isSet(targetRequires, 64) && !SSLUtils.isKeyAvailable()) {
            val = false;
        }
        return val;
    }

    private byte[] getTargetName(Subject subj) {
        byte[] tgt_name = new byte[]{};
        final Subject sub = subj;
        final Set credset = (Set)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return sub.getPrivateCredentials(class$com$sun$enterprise$security$auth$login$PasswordCredential == null ? (class$com$sun$enterprise$security$auth$login$PasswordCredential = SecurityMechanismSelector.class$("com.sun.enterprise.security.auth.login.PasswordCredential")) : class$com$sun$enterprise$security$auth$login$PasswordCredential);
            }
        });
        if (credset.size() == 1) {
            tgt_name = (byte[])AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Iterator iter = credset.iterator();
                    PasswordCredential pc = (PasswordCredential)iter.next();
                    return pc.getTargetName();
                }
            });
        }
        return tgt_name;
    }

    private boolean evaluate_client_conformance_ssl(EjbIORConfigurationDescriptor iordesc, boolean ssl_used, X509Certificate[] certchain) {
        boolean ssl_required = false;
        boolean ssl_supported = false;
        int ssl_target_requires = 0;
        int ssl_target_supports = 0;
        ssl_target_requires = this.ctc.getTargetRequires(iordesc);
        ssl_target_supports = this.ctc.getTargetSupports(iordesc);
        ssl_required = this.isSet(ssl_target_requires, 2) || this.isSet(ssl_target_requires, 4) || this.isSet(ssl_target_requires, 64);
        ssl_supported = ssl_target_supports != 0;
        if (ssl_used ? !ssl_required && !ssl_supported : ssl_required) {
            return false;
        }
        return !(certchain != null ? !this.isSet(ssl_target_requires, 64) && !this.isSet(ssl_target_supports, 64) : this.isSet(ssl_target_requires, 64));
    }

    private boolean evaluate_client_conformance_ascontext(SecurityContext ctx, EjbIORConfigurationDescriptor iordesc) {
        boolean client_authenticated = false;
        AS_ContextSec ascontext = null;
        try {
            ascontext = this.ctc.createASContextSec(iordesc);
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "iiop.createcontextsec_exception", e);
            return false;
        }
        if (ascontext == null) {
            return false;
        }
        client_authenticated = ctx != null && ctx.authcls != null && ctx.subject != null;
        if (client_authenticated) {
            if (!this.isSet(ascontext.target_requires, 64) && !this.isSet(ascontext.target_supports, 64)) {
                return false;
            }
            byte[] client_tgtname = this.getTargetName(ctx.subject);
            if (ascontext.target_name.length != client_tgtname.length) {
                return false;
            }
            for (int i = 0; i < ascontext.target_name.length; ++i) {
                if (ascontext.target_name[i] == client_tgtname[i]) continue;
                return false;
            }
        } else if (this.isSet(ascontext.target_requires, 64)) {
            return false;
        }
        return true;
    }

    private boolean evaluate_client_conformance_sascontext(SecurityContext ctx, EjbIORConfigurationDescriptor iordesc) {
        boolean caller_propagated = false;
        SAS_ContextSec sascontext = null;
        try {
            sascontext = this.ctc.createSASContextSec(iordesc);
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "iiop.createcontextsec_exception", e);
            return false;
        }
        if (sascontext == null) {
            return false;
        }
        caller_propagated = ctx != null && ctx.identcls != null && ctx.subject != null;
        if (caller_propagated) {
            return this.isSet(sascontext.target_supports, 1024);
        }
        return true;
    }

    private boolean evaluate_client_conformance(SecurityContext ctx, byte[] object_id, boolean ssl_used, X509Certificate[] certchain) {
        if (object_id == null) {
            return true;
        }
        if (protocolMgr == null) {
            protocolMgr = (POAProtocolMgr)Switch.getSwitch().getProtocolManager();
        }
        if (protocolMgr == null) {
            return true;
        }
        EjbDescriptor ejbDesc = protocolMgr.getEjbDescriptor(object_id);
        Set iorDescSet = null;
        iorDescSet = ejbDesc != null ? ejbDesc.getIORConfigurationDescriptors() : corbaIORDescSet;
        if (iorDescSet.isEmpty()) {
            return true;
        }
        boolean checkSkipped = false;
        Iterator itr = iorDescSet.iterator();
        while (itr.hasNext()) {
            EjbIORConfigurationDescriptor iorDesc = (EjbIORConfigurationDescriptor)itr.next();
            if (this.skip_client_conformance(iorDesc)) {
                checkSkipped = true;
                continue;
            }
            if (!this.evaluate_client_conformance_ssl(iorDesc, ssl_used, certchain)) {
                checkSkipped = false;
                continue;
            }
            if (!this.evaluate_client_conformance_ascontext(ctx, iorDesc)) {
                checkSkipped = false;
                continue;
            }
            if (!this.evaluate_client_conformance_sascontext(ctx, iorDesc)) {
                checkSkipped = false;
                continue;
            }
            return true;
        }
        return checkSkipped;
    }

    private boolean skip_client_conformance(EjbIORConfigurationDescriptor ior) {
        String none = "NONE";
        if (ior == null) {
            return false;
        }
        if (!none.equalsIgnoreCase(ior.getIntegrity())) {
            return false;
        }
        if (!none.equalsIgnoreCase(ior.getConfidentiality())) {
            return false;
        }
        if (!none.equalsIgnoreCase(ior.getEstablishTrustInClient())) {
            return false;
        }
        if (ior.isAuthMethodRequired()) {
            return false;
        }
        return none.equalsIgnoreCase(ior.getCallerPropagation());
    }

    public SecurityContext evaluateTrust(SecurityContext ctx, byte[] object_id) throws SecurityMechanismException {
        X509Certificate[] certChain;
        boolean ssl_used;
        Socket socket;
        SecurityContext ssc;
        block11: {
            ssc = null;
            socket = null;
            ssl_used = false;
            certChain = null;
            ServerConnectionContext scc = SecurityMechanismSelector.getServerConnectionContext();
            if (scc != null && (socket = scc.getSocket()) != null && socket instanceof SSLSocket) {
                ssl_used = true;
                SSLSocket sslSock = (SSLSocket)socket;
                SSLSession sslSession = sslSock.getSession();
                try {
                    certChain = (X509Certificate[])sslSession.getPeerCertificates();
                }
                catch (Exception e) {
                    if (!_logger.isLoggable(Level.FINE)) break block11;
                    _logger.log(Level.FINE, "iiop.cannot_get_peercert", e);
                }
            }
        }
        if (socket == null && ctx == null) {
            return null;
        }
        if (!this.evaluate_client_conformance(ctx, object_id, ssl_used, certChain)) {
            String msg = "Trust evaluation failed because ";
            msg = msg + "client does not conform to configured security policies";
            throw new SecurityMechanismException(msg);
        }
        if (ctx == null) {
            if (socket == null || !ssl_used || certChain == null) {
                return null;
            }
            ssc = new SecurityContext();
            X500Name x500Name = (X500Name)certChain[0].getSubjectDN();
            ssc.subject = new Subject();
            ssc.subject.getPublicCredentials().add(x500Name);
            ssc.identcls = X500Name.class;
            ssc.authcls = null;
            return ssc;
        }
        ssc = ctx;
        Class authCls = ctx.authcls;
        Class identCls = ctx.identcls;
        ssc.subject = ctx.subject;
        ssc.authcls = null;
        ssc.identcls = null;
        if (identCls != null) {
            ssc.identcls = identCls;
        } else if (authCls != null) {
            ssc.authcls = authCls;
        } else {
            ssc.identcls = AnonCredential.class;
        }
        return ssc;
    }

    private boolean isSet(int val1, int val2) {
        return (val1 & val2) == val2;
    }

    static {
        _logger = LogDomains.getLogger("javax.enterprise.resource.corba");
        corbaIORDescSet = null;
        sslRequired = false;
        serverTrustedHosts = null;
        localStrings = new LocalStringManagerImpl(SecServerRequestInterceptor.class);
        protocolMgr = null;
        try {
            String clientAuthReq;
            String s = (String)ORBManager.getCSIv2Props().get("com.sun.CSIV2.ssl.client.required");
            if (s != null && s.equals("true")) {
                sslRequired = true;
            }
            corbaIORDescSet = new HashSet();
            EjbIORConfigurationDescriptor iorDesc = new EjbIORConfigurationDescriptor();
            EjbIORConfigurationDescriptor iorDesc2 = new EjbIORConfigurationDescriptor();
            String serverSslReqd = (String)ORBManager.getCSIv2Props().get("com.sun.CSIV2.ssl.server.required");
            if (serverSslReqd != null && serverSslReqd.equals("true")) {
                iorDesc.setIntegrity("REQUIRED");
                iorDesc.setConfidentiality("REQUIRED");
                iorDesc2.setIntegrity("REQUIRED");
                iorDesc2.setConfidentiality("REQUIRED");
            }
            if ((clientAuthReq = (String)ORBManager.getCSIv2Props().get("com.sun.CSIV2.client.auth.required")) != null && clientAuthReq.equals("true")) {
                iorDesc.setEstablishTrustInClient("REQUIRED");
                iorDesc2.setAuthMethodRequired(true);
                corbaIORDescSet.add(iorDesc2);
            }
            corbaIORDescSet.add(iorDesc);
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "iiop.Exception", e);
        }
    }
}

