/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.distributedtx;

import com.sun.enterprise.distributedtx.J2EETransactionManagerOpt;
import com.sun.enterprise.resource.ResourceHandle;
import com.sun.enterprise.util.Utility;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.util.HashMap;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public final class J2EETransaction
extends TimerTask
implements Transaction {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.resource.jta");
    private static StringManager sm = StringManager.getManager(J2EETransaction.class);
    private static long txIdCounter = 1L;
    private long txId;
    private J2EEXid xid;
    static J2EETransactionManagerOpt j2eeTM;
    private Transaction jtsTx;
    private ResourceHandle nonXAResource;
    private ResourceHandle laoResource;
    private int localTxStatus = 0;
    private Vector syncs = new Vector();
    private boolean commitStarted = false;
    private long startTime;
    private boolean isTimedOut = false;
    private boolean isTimerTask = false;
    private int timeout;
    private boolean imported = false;
    private HashMap resourceTable;
    private Object activeTxCache;
    private static boolean isTimerInitialized;
    private static Timer timer;
    private static final byte[] bqual;

    private static synchronized void initializeTimer() {
        if (isTimerInitialized) {
            return;
        }
        timer = new Timer(true);
        isTimerInitialized = true;
    }

    J2EETransaction() {
        this.txId = J2EETransaction.getNewTxId();
        this.xid = new J2EEXid(this.txId);
        this.resourceTable = new HashMap();
        this.startTime = System.currentTimeMillis();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "--Created new J2EETransaction, txId = " + this.txId);
        }
    }

    J2EETransaction(int timeout) {
        this();
        if (!isTimerInitialized) {
            J2EETransaction.initializeTimer();
        }
        timer.schedule((TimerTask)this, timeout * 1000);
        this.isTimerTask = true;
        this.timeout = timeout;
    }

    J2EETransaction(Transaction jtsTx) {
        this();
        this.jtsTx = jtsTx;
    }

    public void run() {
        this.isTimedOut = true;
        try {
            this.setRollbackOnly();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    boolean isAssociatedTimeout() {
        return this.isTimerTask;
    }

    int cancelTimerTask() {
        this.cancel();
        return this.timeout;
    }

    boolean isTimedout() {
        return this.isTimedOut;
    }

    private static synchronized long getNewTxId() {
        long newTxId = txIdCounter++;
        return newTxId;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof J2EETransaction) {
            J2EETransaction othertx = (J2EETransaction)other;
            return this.txId == othertx.txId;
        }
        return false;
    }

    public int hashCode() {
        return (int)this.txId;
    }

    Xid getLocalXid() {
        return this.xid;
    }

    public ResourceHandle getNonXAResource() {
        return this.nonXAResource;
    }

    void setNonXAResource(ResourceHandle h) {
        this.nonXAResource = h;
    }

    ResourceHandle getLAOResource() {
        return this.laoResource;
    }

    void setLAOResource(ResourceHandle h) {
        this.laoResource = h;
    }

    void setImportedTransaction() {
        this.imported = true;
    }

    boolean isImportedTransaction() {
        return this.imported;
    }

    boolean isLocalTx() {
        return this.jtsTx == null;
    }

    void setJTSTx(Transaction jtsTx) throws RollbackException, SystemException {
        this.jtsTx = jtsTx;
        if (!this.commitStarted) {
            for (int i = 0; i < this.syncs.size(); ++i) {
                jtsTx.registerSynchronization((Synchronization)this.syncs.elementAt(i));
            }
        }
    }

    Transaction getJTSTx() {
        return this.jtsTx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        block30: {
            if (this.isTimerTask) {
                this.cancel();
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "--In J2EETransaction.commit, jtsTx=" + this.jtsTx + " nonXAResource=" + this.nonXAResource);
            }
            this.commitStarted = true;
            if (this.jtsTx != null) {
                try {
                    this.jtsTx.commit();
                }
                finally {
                    j2eeTM.clearThreadTx();
                }
            }
            try {
                block29: {
                    if (this.isTimedOut) {
                        if (this.nonXAResource != null) {
                            this.nonXAResource.getXAResource().rollback(this.xid);
                        }
                        this.localTxStatus = 4;
                        throw new RollbackException(sm.getString("enterprise_distributedtx.rollback_timeout"));
                    }
                    if (this.isRollbackOnly()) {
                        if (this.nonXAResource != null) {
                            this.nonXAResource.getXAResource().rollback(this.xid);
                        }
                        this.localTxStatus = 4;
                        throw new RollbackException(sm.getString("enterprise_distributedtx.mark_rollback"));
                    }
                    for (int i = 0; i < this.syncs.size(); ++i) {
                        try {
                            Synchronization sync = (Synchronization)this.syncs.elementAt(i);
                            sync.beforeCompletion();
                            continue;
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                    }
                    if (this.isRollbackOnly()) {
                        if (this.jtsTx == null) {
                            if (this.nonXAResource != null) {
                                this.nonXAResource.getXAResource().rollback(this.xid);
                            }
                            this.localTxStatus = 4;
                            throw new RollbackException(sm.getString("enterprise_distributedtx.mark_rollback"));
                        }
                        this.jtsTx.rollback();
                        this.localTxStatus = 4;
                        throw new RollbackException(sm.getString("enterprise_distributedtx.mark_rollback"));
                    }
                    if (this.jtsTx != null) {
                        this.jtsTx.commit();
                        this.localTxStatus = 3;
                        break block29;
                    }
                    if (this.nonXAResource != null) {
                        this.nonXAResource.getXAResource().commit(this.xid, true);
                    }
                    this.localTxStatus = 3;
                }
                Object var4_9 = null;
                j2eeTM.clearThreadTx();
            }
            catch (Throwable throwable) {
                Object var4_10 = null;
                j2eeTM.clearThreadTx();
                for (int i = 0; i < this.syncs.size(); ++i) {
                    try {
                        Synchronization sync = (Synchronization)this.syncs.elementAt(i);
                        sync.afterCompletion(this.localTxStatus);
                        continue;
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            for (int i = 0; i < this.syncs.size(); ++i) {
                try {
                    Synchronization sync = (Synchronization)this.syncs.elementAt(i);
                    sync.afterCompletion(this.localTxStatus);
                    continue;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            {
                break block30;
                catch (RollbackException ex) {
                    this.localTxStatus = 4;
                    throw ex;
                }
                catch (SystemException ex) {
                    this.localTxStatus = 8;
                    throw ex;
                }
                catch (Exception ex) {
                    this.localTxStatus = 4;
                    SystemException exc = new SystemException();
                    exc.initCause((Throwable)ex);
                    throw exc;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void rollback() throws IllegalStateException, SystemException {
        if (this.isTimerTask) {
            this.cancel();
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "--In J2EETransaction.rollback, jtsTx=" + this.jtsTx + " nonXAResource=" + this.nonXAResource);
        }
        try {
            block15: {
                if (this.jtsTx != null) {
                    this.jtsTx.rollback();
                    break block15;
                }
                if (this.nonXAResource != null) {
                    this.nonXAResource.getXAResource().rollback(this.xid);
                }
                this.localTxStatus = 4;
            }
            Object var3_1 = null;
            j2eeTM.clearThreadTx();
            if (this.jtsTx != null) return;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            j2eeTM.clearThreadTx();
            if (this.jtsTx != null) throw throwable;
            for (int i = 0; i < this.syncs.size(); ++i) {
                try {
                    Synchronization sync = (Synchronization)this.syncs.elementAt(i);
                    sync.afterCompletion(4);
                    continue;
                }
                catch (Exception ex2) {
                    // empty catch block
                }
            }
            throw throwable;
        }
        for (int i = 0; i < this.syncs.size(); ++i) {
            try {
                Synchronization sync = (Synchronization)this.syncs.elementAt(i);
                sync.afterCompletion(4);
                continue;
            }
            catch (Exception ex2) {
                // empty catch block
            }
        }
        {
            return;
            catch (Exception ex) {
                this.localTxStatus = 4;
                Object var3_2 = null;
                j2eeTM.clearThreadTx();
                if (this.jtsTx != null) return;
                for (int i = 0; i < this.syncs.size(); ++i) {
                    try {
                        Synchronization sync = (Synchronization)this.syncs.elementAt(i);
                        sync.afterCompletion(4);
                        continue;
                    }
                    catch (Exception ex2) {
                        // empty catch block
                    }
                }
                return;
            }
        }
    }

    public boolean delistResource(XAResource xaRes, int flag) throws IllegalStateException, SystemException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "--In J2EETransaction.delistResource, jtsTx=" + this.jtsTx + " nonXAResource=" + this.nonXAResource);
        }
        if (this.jtsTx != null) {
            return this.jtsTx.delistResource(xaRes, flag);
        }
        throw new IllegalStateException(sm.getString("enterprise_distributedtx.deleteresource_for_localtx"));
    }

    public boolean enlistResource(XAResource xaRes) throws RollbackException, IllegalStateException, SystemException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "--In J2EETransaction.enlistResource, jtsTx=" + this.jtsTx + " nonXAResource=" + this.nonXAResource);
        }
        if (this.jtsTx != null) {
            return this.jtsTx.enlistResource(xaRes);
        }
        if (this.nonXAResource != null) {
            throw new IllegalStateException(sm.getString("enterprise_distributedtx.already_has_nonxa"));
        }
        j2eeTM.startJTSTx(this);
        return this.jtsTx.enlistResource(xaRes);
    }

    public int getStatus() throws SystemException {
        if (this.jtsTx != null) {
            return this.jtsTx.getStatus();
        }
        return this.localTxStatus;
    }

    public void registerSynchronization(Synchronization sync) throws RollbackException, IllegalStateException, SystemException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "--In J2EETransaction.registerSynchronization, jtsTx=" + this.jtsTx + " nonXAResource=" + this.nonXAResource);
        }
        if (this.jtsTx != null) {
            this.jtsTx.registerSynchronization(sync);
        } else {
            this.syncs.add(sync);
        }
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        if (this.jtsTx != null) {
            this.jtsTx.setRollbackOnly();
        } else {
            this.localTxStatus = 1;
        }
    }

    private boolean isRollbackOnly() throws IllegalStateException, SystemException {
        int status = this.jtsTx != null ? this.jtsTx.getStatus() : this.localTxStatus;
        return status == 1;
    }

    public String toString() {
        return "J2EETransaction: txId=" + this.txId + " nonXAResource=" + this.nonXAResource + " jtsTx=" + this.jtsTx + " localTxStatus=" + this.localTxStatus + " syncs=" + this.syncs;
    }

    public String getTransactionId() {
        return this.xid.toString();
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setResources(Set resources, String poolName) {
        this.resourceTable.put(poolName, resources);
    }

    public Set getResources(String poolName) {
        return (Set)this.resourceTable.get(poolName);
    }

    public void setActiveTxCache(Object cache) {
        this.activeTxCache = cache;
    }

    public Object getActiveTxCache() {
        return this.activeTxCache;
    }

    static {
        isTimerInitialized = false;
        timer = null;
        bqual = new byte[]{0};
    }

    private class J2EEXid
    implements Xid {
        private static final int formatId = 987654321;
        private byte[] gtrId = new byte[8];
        private String stringForm = null;

        J2EEXid(long txId) {
            Utility.longToBytes(txId, this.gtrId, 0);
        }

        public int getFormatId() {
            return 987654321;
        }

        public byte[] getGlobalTransactionId() {
            return this.gtrId;
        }

        public byte[] getBranchQualifier() {
            return bqual;
        }

        public String toString() {
            if (this.stringForm != null) {
                return this.stringForm;
            }
            char[] buff = new char[this.gtrId.length * 2 + 3];
            int pos = 0;
            int globalLen = this.gtrId.length;
            for (int i = 0; i < globalLen; ++i) {
                int currCharHigh = (this.gtrId[i] & 0xF0) >> 4;
                int currCharLow = this.gtrId[i] & 0xF;
                buff[pos++] = (char)(currCharHigh + (currCharHigh > 9 ? 55 : 48));
                buff[pos++] = (char)(currCharLow + (currCharLow > 9 ? 55 : 48));
            }
            buff[pos++] = 95;
            int currCharHigh = 0;
            int currCharLow = 0;
            buff[pos++] = (char)(currCharHigh + (currCharHigh > 9 ? 55 : 48));
            buff[pos++] = (char)(currCharLow + (currCharLow > 9 ? 55 : 48));
            this.stringForm = new String(buff);
            return this.stringForm;
        }
    }
}

