/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.util;

import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.WebService;
import com.sun.enterprise.deployment.archivist.AbstractArchive;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.deployment.util.DefaultDOLVisitor;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.IOException;
import java.io.InputStream;

public class ModuleContentValidator
extends DefaultDOLVisitor {
    private AbstractArchive archive_;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ModuleContentValidator.class);

    public ModuleContentValidator(AbstractArchive archive) {
        this.archive_ = archive;
    }

    public void accept(ServiceReferenceDescriptor serviceRef) {
        block9: {
            if (serviceRef.hasWsdlFile()) {
                String wsdlFileUri = serviceRef.getWsdlFileUri();
                try {
                    InputStream wsdlFileInputStream = this.archive_.getEntry(wsdlFileUri);
                    if (wsdlFileInputStream != null) {
                        wsdlFileInputStream.close();
                        BundleDescriptor bundle = serviceRef.getBundleDescriptor();
                        if (!this.isWsdlContent(wsdlFileUri, bundle)) {
                            String msg = localStrings.getLocalString("enterprise.deployment.util.wsdlpackagedinwrongreflocation", "wsdl file {0} for service-ref {1} must be packaged in or below {2}", new Object[]{wsdlFileUri, serviceRef.getName(), bundle.getWsdlDir()});
                            DOLUtils.getDefaultLogger().severe(msg);
                            throw new RuntimeException(msg);
                        }
                        break block9;
                    }
                    String msg = localStrings.getLocalString("enterprise.deployment.util.wsdlfilenotfound", "wsdl file {0} does not exist for service-ref {1}", new Object[]{wsdlFileUri, serviceRef.getName()});
                    DOLUtils.getDefaultLogger().severe(msg);
                    throw new RuntimeException(msg);
                }
                catch (IOException ioe) {
                    String msg = localStrings.getLocalString("enterprise.deployment.util.wsdlfilenotreadable", "wsdl file {0}  for service-ref {1} cannot be opened : {2}", new Object[]{wsdlFileUri, serviceRef.getName(), ioe.getMessage()});
                    DOLUtils.getDefaultLogger().severe(msg);
                    throw new RuntimeException(ioe);
                }
            }
        }
        if (serviceRef.hasMappingFile()) {
            String msg;
            String mappingFileUri = serviceRef.getMappingFileUri();
            try {
                InputStream mappingFileInputStream = this.archive_.getEntry(mappingFileUri);
                if (mappingFileInputStream == null) {
                    msg = localStrings.getLocalString("enterprise.deployment.util.mappingfilenotfound", "mapping file {0} does not exist for service-ref {1}", new Object[]{mappingFileUri, serviceRef.getName()});
                    DOLUtils.getDefaultLogger().severe(msg);
                    throw new RuntimeException(msg);
                }
                mappingFileInputStream.close();
            }
            catch (IOException ioe) {
                msg = localStrings.getLocalString("enterprise.deployment.util.mappingfilenotreadable", "mapping file {0}  for service-ref {1} cannot be opened : {2}", new Object[]{mappingFileUri, serviceRef.getName(), ioe.getMessage()});
                DOLUtils.getDefaultLogger().severe(msg);
                throw new RuntimeException(ioe);
            }
        }
    }

    public void accept(WebService webService) {
        String msg;
        block7: {
            try {
                String wsdlFileUri = webService.getWsdlFileUri();
                InputStream wsdlFileInputStream = this.archive_.getEntry(wsdlFileUri);
                if (wsdlFileInputStream != null) {
                    wsdlFileInputStream.close();
                    BundleDescriptor bundle = webService.getBundleDescriptor();
                    if (!this.isWsdlContent(wsdlFileUri, bundle)) {
                        String msg2 = localStrings.getLocalString("enterprise.deployment.util.wsdlpackagedinwrongservicelocation", "wsdl file {0} for web service {1} must be packaged in or below {2}", new Object[]{wsdlFileUri, webService.getWebServiceName(), bundle.getWsdlDir()});
                        DOLUtils.getDefaultLogger().severe(msg2);
                        throw new RuntimeException(msg2);
                    }
                    break block7;
                }
                String msg3 = localStrings.getLocalString("enterprise.deployment.util.servicewsdlfilenotfound", "wsdl file {0} does not exist for web service {1}", new Object[]{wsdlFileUri, webService.getWebServiceName()});
                DOLUtils.getDefaultLogger().severe(msg3);
                throw new RuntimeException(msg3);
            }
            catch (IOException ioe) {
                String msg4 = localStrings.getLocalString("enterprise.deployment.util.servicewsdlfilenotreadable", "wsdl file {0}  for service-ref {1} cannot be opened : {2}", new Object[]{webService.getWsdlFileUri(), webService.getWebServiceName(), ioe.getMessage()});
                DOLUtils.getDefaultLogger().severe(msg4);
                throw new RuntimeException(ioe);
            }
        }
        try {
            InputStream mappingFileInputStream = this.archive_.getEntry(webService.getMappingFileUri());
            if (mappingFileInputStream == null) {
                msg = localStrings.getLocalString("enterprise.deployment.util.servicemappingfilenotfound", "Web Service mapping file {0} for web service {1} not found", new Object[]{webService.getMappingFileUri(), webService.getWebServiceName()});
                DOLUtils.getDefaultLogger().severe(msg);
                throw new RuntimeException(msg);
            }
            mappingFileInputStream.close();
        }
        catch (IOException ioe) {
            msg = localStrings.getLocalString("enterprise.deployment.util.servicemappingfilenotreadable", "Web Service mapping file {0} for web service {1} not found {2} ", new Object[]{webService.getMappingFileUri(), webService.getWebServiceName(), ioe});
            DOLUtils.getDefaultLogger().severe(msg);
            throw new RuntimeException(ioe);
        }
    }

    public boolean isWsdlContent(String uri, BundleDescriptor bundle) {
        String wsdlDir = bundle.getWsdlDir();
        return uri != null && uri.startsWith(wsdlDir);
    }
}

