/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.ui;

import com.sun.enterprise.deployment.backend.IASDeploymentException;
import com.sun.enterprise.util.diagnostics.SystemProps;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;

public class SimpleXMLParser {
    private File domainXML;
    private String[] classpath = null;

    public SimpleXMLParser(String instanceName) throws IASDeploymentException {
        try {
            this.domainXML = new File(System.getProperty("com.sun.aas.instanceRoot") + "/config/domain.xml");
            this.debug("Domain.xml: " + this.domainXML);
            this.parseSystemProps();
        }
        catch (IASDeploymentException e) {
            e.printStackTrace();
            throw e;
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new IASDeploymentException("Error in constructor", t);
        }
    }

    private void parseSystemProps() throws IASDeploymentException, IOException {
        String s;
        BufferedReader reader = new BufferedReader(new FileReader(this.domainXML));
        while ((s = reader.readLine()) != null) {
            if (s.indexOf("<jvm-options>-D") >= 0) {
                this.setProp(s);
                continue;
            }
            if (s.indexOf("<jacc-provider") >= 0) {
                while (s.indexOf("</jacc-provider>") < 0) {
                    s = s + " " + reader.readLine();
                }
                this.setSecurityProp(s);
                continue;
            }
            if (s.indexOf("<java-config") < 0) continue;
            this.parseClasspath(s);
        }
    }

    private void setProp(String s) throws IASDeploymentException {
        String both = this.trim(s);
        int index = both.indexOf("=");
        if (index < 0) {
            throw new IASDeploymentException("Bad Property in domain.xml: " + both);
        }
        String key = both.substring(0, index);
        String value = both.substring(index + 1);
        this.debug("PARSED System Property:  key: " + key + ", value: " + value);
        System.setProperty(key, value);
    }

    private void setSecurityProp(String s) throws IASDeploymentException {
        String FACTORY_TAG = "PolicyConfigurationFactory-provider";
        String FACTORY_PROP_KEY = "javax.security.jacc.PolicyConfigurationFactory.provider";
        String cantFind = "Can't find PolicyConfigurationFactory-provider value in <jacc-provider>";
        int index = s.indexOf("PolicyConfigurationFactory-provider");
        if (index < 0) {
            throw new IASDeploymentException("Can't find PolicyConfigurationFactory-provider value in <jacc-provider>");
        }
        int eq = (s = s.substring(index)).indexOf(61);
        if (eq < 0) {
            throw new IASDeploymentException("Can't find PolicyConfigurationFactory-provider value in <jacc-provider>");
        }
        int start = s.indexOf(34, eq);
        int end = s.indexOf(34, start + 1);
        String value = s.substring(start + 1, end);
        System.setProperty("javax.security.jacc.PolicyConfigurationFactory.provider", value);
    }

    private void parseClasspath(String s) {
        String tag = "server-classpath=";
        int index = s.indexOf("server-classpath=");
        if (index < 0) {
            return;
        }
        s = s.substring(index + "server-classpath=".length());
        StringTokenizer st = new StringTokenizer(s, "<>\"" + File.pathSeparatorChar);
        this.classpath = new String[st.countTokens()];
        System.out.println("*** START CLASSPATH ***");
        int i = 0;
        while (st.hasMoreTokens()) {
            this.classpath[i] = this.expandMacro(st.nextToken()).replace('\\', '/');
            System.out.println(this.classpath[i]);
            ++i;
        }
        System.out.println("*** END CLASSPATH ***");
    }

    private String expandMacro(String s) {
        String expanded;
        if (!s.startsWith("${")) {
            return s;
        }
        int rightBrace = s.indexOf(125);
        if (rightBrace < 0) {
            return s;
        }
        int len = s.length();
        String javaVar = s.substring(2, rightBrace);
        String theRest = "";
        if (len > rightBrace + 1) {
            theRest = s.substring(rightBrace + 1);
        }
        if ((expanded = javaVar.equals("java.home") ? System.getProperty("com.sun.aas.installRoot") + "/jdk" : System.getProperty(javaVar)) == null) {
            throw new RuntimeException("Can't find java-variable that is embedded in the path: " + s.substring(0, rightBrace + 1));
        }
        String ret = expanded + theRest;
        return ret;
    }

    private String trim(String s) {
        int index = s.indexOf(">-D");
        String ret = s.substring(index + 3);
        ret = ret.substring(0, ret.indexOf("<"));
        return ret;
    }

    public String toString() {
        return SystemProps.toStringStatic();
    }

    private void debug(String s) {
        System.out.println(s);
    }

    public static void main(String[] args) {
        try {
            System.setProperty("com.sun.aas.instanceRoot", "D:/temp");
            System.setProperty("com.sun.aas.installRoot", "D:/ias8");
            SimpleXMLParser sx = new SimpleXMLParser("server");
            System.out.println(sx);
            String cp = sx.classpath[0];
            for (int i = 1; i < sx.classpath.length; ++i) {
                cp = cp + ';' + sx.classpath[i];
            }
            System.out.println(cp);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

