/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.phasing;

import com.sun.enterprise.admin.common.constant.DeploymentConstants;
import com.sun.enterprise.deployment.backend.DeploymentEvent;
import com.sun.enterprise.deployment.backend.DeploymentEventManager;
import com.sun.enterprise.deployment.backend.DeploymentRequest;
import com.sun.enterprise.deployment.backend.DeploymentStatus;
import com.sun.enterprise.deployment.backend.IASDeploymentException;
import com.sun.enterprise.deployment.phasing.DeploymentContext;
import com.sun.enterprise.deployment.phasing.DeploymentPhaseContext;
import com.sun.enterprise.deployment.phasing.DeploymentPhaseException;
import com.sun.enterprise.deployment.phasing.DeploymentTarget;
import com.sun.enterprise.deployment.phasing.DeploymentTargetFactory;
import com.sun.enterprise.deployment.phasing.StandardDeploymentPhaseContext;
import com.sun.enterprise.util.i18n.StringManager;

public abstract class DeploymentPhase
implements DeploymentConstants {
    public static final String J2EEC = "J2EEC";
    public static final String ASSOCIATE = "Associate";
    public static final String DISASSOCIATE = "Disassociate";
    public static final String START = "Start";
    public static final String STOP = "Stop";
    public static final String UNDEPLOY = "Undeploy";
    protected DeploymentContext deploymentCtx;
    private static StringManager localStrings = StringManager.getManager(DeploymentPhase.class);
    String name = null;

    public final DeploymentPhaseContext executePhase(DeploymentRequest req, DeploymentStatus status) throws DeploymentPhaseException {
        DeploymentPhaseContext phaseCtx = this.getPhaseContext();
        phaseCtx.setDeploymentRequest(req);
        phaseCtx.setDeploymentStatus(status);
        this.prePhase(phaseCtx);
        if (status.getStatus() > 0) {
            this.runPhase(phaseCtx);
        }
        if (status.getStatus() > 0) {
            this.postPhase(phaseCtx);
        }
        return phaseCtx;
    }

    public void rollback(DeploymentPhaseContext phaseCtx) throws DeploymentPhaseException {
    }

    public abstract void runPhase(DeploymentPhaseContext var1) throws DeploymentPhaseException;

    public void prePhase(DeploymentPhaseContext phaseCtx) throws DeploymentPhaseException {
    }

    public void postPhase(DeploymentPhaseContext phaseCtx) throws DeploymentPhaseException {
    }

    public void prePhaseNotify(DeploymentEvent event) {
        DeploymentEventManager.notifyDeploymentEvent(event);
    }

    public void postPhaseNotify(DeploymentEvent event) {
        DeploymentEventManager.notifyDeploymentEvent(event);
    }

    public String getName() {
        return this.name;
    }

    void setName(String name) {
        this.name = name;
    }

    protected DeploymentTarget getTarget(String targetName) throws DeploymentPhaseException {
        try {
            DeploymentTarget target = this.getTargetFactory().getTarget(this.deploymentCtx.getConfigContext(), targetName);
            return target;
        }
        catch (IASDeploymentException de) {
            String msg = localStrings.getString("enterprise.deployment.phasing.phase.targetnotfound");
            throw new DeploymentPhaseException(this.getName(), msg, de);
        }
    }

    protected DeploymentPhaseContext getPhaseContext() {
        return new StandardDeploymentPhaseContext();
    }

    private DeploymentTargetFactory getTargetFactory() {
        return DeploymentTargetFactory.getDeploymentTargetFactory();
    }
}

