/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.node.ejb;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.deployment.EjbMessageBeanDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.MethodPermission;
import com.sun.enterprise.deployment.MethodPermissionDescriptor;
import com.sun.enterprise.deployment.RelationshipDescriptor;
import com.sun.enterprise.deployment.Role;
import com.sun.enterprise.deployment.node.BundleNode;
import com.sun.enterprise.deployment.node.ContainerTransactionNode;
import com.sun.enterprise.deployment.node.DescriptorFactory;
import com.sun.enterprise.deployment.node.MessageDestinationNode;
import com.sun.enterprise.deployment.node.RootXMLNode;
import com.sun.enterprise.deployment.node.SecurityRoleNode;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.node.ejb.EjbEntityNode;
import com.sun.enterprise.deployment.node.ejb.EjbNode;
import com.sun.enterprise.deployment.node.ejb.EjbSessionNode;
import com.sun.enterprise.deployment.node.ejb.ExcludeListNode;
import com.sun.enterprise.deployment.node.ejb.MessageDrivenBeanNode;
import com.sun.enterprise.deployment.node.ejb.MethodPermissionNode;
import com.sun.enterprise.deployment.node.ejb.RelationshipsNode;
import com.sun.enterprise.deployment.util.DOLUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EjbBundleNode
extends BundleNode
implements RootXMLNode {
    public static final XMLElement tag = new XMLElement("ejb-jar");
    public static final String PUBLIC_DTD_ID = "-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 2.0//EN";
    public static final String PUBLIC_DTD_ID_12 = "-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 1.1//EN";
    public static final String SYSTEM_ID = "http://java.sun.com/dtd/ejb-jar_2_0.dtd";
    public static final String SYSTEM_ID_12 = "http://java.sun.com/dtd/ejb-jar_1_1.dtd";
    public static final String SCHEMA_ID = "ejb-jar_2_1.xsd";
    public static final String SPEC_VERSION = "2.1";
    private EjbBundleDescriptor descriptor;

    public static String registerBundle(Map publicIDToDTD) {
        publicIDToDTD.put(PUBLIC_DTD_ID, SYSTEM_ID);
        publicIDToDTD.put(PUBLIC_DTD_ID_12, SYSTEM_ID_12);
        return tag.getQName();
    }

    public EjbBundleNode() {
        this.registerElementHandler(new XMLElement("session"), EjbSessionNode.class);
        this.registerElementHandler(new XMLElement("entity"), EjbEntityNode.class);
        this.registerElementHandler(new XMLElement("message-driven"), MessageDrivenBeanNode.class);
        this.registerElementHandler(new XMLElement("method-permission"), MethodPermissionNode.class);
        this.registerElementHandler(new XMLElement("security-role"), SecurityRoleNode.class, "addRole");
        this.registerElementHandler(new XMLElement("container-transaction"), ContainerTransactionNode.class);
        this.registerElementHandler(new XMLElement("exclude-list"), ExcludeListNode.class);
        this.registerElementHandler(new XMLElement("relationships"), RelationshipsNode.class);
        this.registerElementHandler(new XMLElement("message-destination"), MessageDestinationNode.class, "addMessageDestination");
    }

    public void addDescriptor(Object newDescriptor) {
        if (newDescriptor instanceof EjbDescriptor) {
            this.descriptor.addEjb((EjbDescriptor)newDescriptor);
        } else if (newDescriptor instanceof RelationshipDescriptor) {
            this.descriptor.addRelationship((RelationshipDescriptor)newDescriptor);
        } else if (newDescriptor instanceof MethodPermissionDescriptor) {
            MethodPermissionDescriptor nd = (MethodPermissionDescriptor)newDescriptor;
            MethodDescriptor[] array = nd.getMethods();
            for (int i = 0; i < array.length; ++i) {
                EjbDescriptor target = this.descriptor.getEjbByName(array[i].getEjbName());
                MethodPermission[] mps = nd.getMethodPermissions();
                for (int j = 0; j < mps.length; ++j) {
                    DOLUtils.getDefaultLogger().fine("Adding mp " + mps[j] + " to " + array[i] + " for ejb " + array[i].getEjbName());
                    target.addPermissionedMethod(mps[j], array[i]);
                }
            }
        } else {
            super.addDescriptor(newDescriptor);
        }
    }

    public Object getDescriptor() {
        if (this.descriptor == null) {
            this.descriptor = (EjbBundleDescriptor)DescriptorFactory.getDescriptor(this.getXMLPath());
        }
        return this.descriptor;
    }

    protected XMLElement getXMLRootTag() {
        return tag;
    }

    protected Map getDispatchTable() {
        Map table = super.getDispatchTable();
        table.put("ejb-client-jar", "setEjbClientJarUri");
        return table;
    }

    public Node writeDescriptor(Node parent, Descriptor descriptor) {
        if (!(descriptor instanceof EjbBundleDescriptor)) {
            throw new IllegalArgumentException(this.getClass() + " cannot handles descriptors of type " + descriptor.getClass());
        }
        EjbBundleDescriptor ejbDesc = (EjbBundleDescriptor)descriptor;
        Node jarNode = super.writeDescriptor(parent, ejbDesc);
        Element entrepriseBeansNode = EjbBundleNode.appendChild(jarNode, "enterprise-beans");
        Iterator ejbs = ejbDesc.getEjbs().iterator();
        while (ejbs.hasNext()) {
            EjbNode subNode;
            EjbDescriptor ejb = (EjbDescriptor)ejbs.next();
            if ("Session".equals(ejb.getType())) {
                subNode = new EjbSessionNode();
                subNode.writeDescriptor(entrepriseBeansNode, "session", ejb);
                continue;
            }
            if (EjbEntityDescriptor.TYPE.equals(ejb.getType())) {
                subNode = new EjbEntityNode();
                subNode.writeDescriptor(entrepriseBeansNode, "entity", ejb);
                continue;
            }
            if ("Message-driven".equals(ejb.getType())) {
                subNode = new MessageDrivenBeanNode();
                subNode.writeDescriptor(entrepriseBeansNode, "message-driven", ejb);
                continue;
            }
            throw new IllegalStateException("Unknow ejb type " + ejb.getType());
        }
        if (ejbDesc.hasRelationships()) {
            new RelationshipsNode().writeDescriptor(jarNode, "relationships", ejbDesc);
        }
        this.writeAssemblyDescriptor(jarNode, ejbDesc);
        EjbBundleNode.appendTextChild(jarNode, "ejb-client-jar", ejbDesc.getEjbClientJarUri());
        return jarNode;
    }

    public String getDocType() {
        return null;
    }

    public String getSystemID() {
        return SCHEMA_ID;
    }

    private void writeAssemblyDescriptor(Node parentNode, EjbBundleDescriptor bundleDescriptor) {
        Element assemblyNode = parentNode.getOwnerDocument().createElement("assembly-descriptor");
        SecurityRoleNode roleNode = new SecurityRoleNode();
        Iterator e = bundleDescriptor.getRoles().iterator();
        while (e.hasNext()) {
            roleNode.writeDescriptor((Node)assemblyNode, "security-role", (Role)e.next());
        }
        HashMap excludedMethodsByEjb = new HashMap();
        MethodPermissionNode mpNode = new MethodPermissionNode();
        Iterator e2 = bundleDescriptor.getEjbs().iterator();
        while (e2.hasNext()) {
            EjbDescriptor ejbDesc = (EjbDescriptor)e2.next();
            if (ejbDesc instanceof EjbMessageBeanDescriptor) continue;
            Vector excludedMethods = new Vector();
            this.addMethodPermissions(ejbDesc, ejbDesc.getPermissionedMethodsByPermission(), excludedMethods, mpNode, assemblyNode);
            this.addMethodPermissions(ejbDesc, ejbDesc.getStyledPermissionedMethodsByPermission(), excludedMethods, mpNode, assemblyNode);
            if (excludedMethods.size() <= 0) continue;
            excludedMethodsByEjb.put(ejbDesc, excludedMethods);
        }
        ContainerTransactionNode ctNode = new ContainerTransactionNode();
        Iterator e3 = bundleDescriptor.getEjbs().iterator();
        while (e3.hasNext()) {
            EjbDescriptor ejbDesc = (EjbDescriptor)e3.next();
            ctNode.writeDescriptor((Node)assemblyNode, "container-transaction", ejbDesc);
        }
        this.writeMessageDestinations(assemblyNode, bundleDescriptor.getMessageDestinations().iterator());
        if (excludedMethodsByEjb.size() > 0) {
            Element excludeListNode = EjbBundleNode.appendChild(assemblyNode, "exclude-list");
            Iterator ejbs = excludedMethodsByEjb.keySet().iterator();
            while (ejbs.hasNext()) {
                EjbDescriptor ejbDesc = (EjbDescriptor)ejbs.next();
                Vector excludedMethods = (Vector)excludedMethodsByEjb.get(ejbDesc);
                MethodPermissionDescriptor mpd = new MethodPermissionDescriptor();
                mpd.addMethodPermission(MethodPermission.getExcludedMethodPermission());
                mpd.addMethods(excludedMethods);
                mpNode.writeDescriptorInNode(excludeListNode, mpd, ejbDesc);
            }
        }
        if (assemblyNode.hasChildNodes()) {
            parentNode.appendChild(assemblyNode);
        }
    }

    private void addMethodPermissions(EjbDescriptor ejb, Map mpToMethods, Vector excludedMethods, MethodPermissionNode mpNode, Node assemblyNode) {
        if (mpToMethods == null || mpToMethods.size() == 0) {
            return;
        }
        Iterator mpIterator = mpToMethods.keySet().iterator();
        while (mpIterator.hasNext()) {
            MethodPermission mp = (MethodPermission)mpIterator.next();
            if (mp.isExcluded()) {
                Set methods = (Set)mpToMethods.get(mp);
                excludedMethods.addAll(methods);
                continue;
            }
            MethodPermissionDescriptor mpd = new MethodPermissionDescriptor();
            mpd.addMethodPermission(mp);
            mpd.addMethods((Set)mpToMethods.get(mp));
            mpNode.writeDescriptor(assemblyNode, "method-permission", mpd, ejb);
        }
    }

    public String getSpecVersion() {
        return SPEC_VERSION;
    }
}

