/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.node;

import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.WebService;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.WebServicesDescriptor;
import com.sun.enterprise.deployment.node.BundleNode;
import com.sun.enterprise.deployment.node.RootXMLNode;
import com.sun.enterprise.deployment.node.WebServiceNode;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.util.DOLUtils;
import java.util.Collection;
import java.util.Iterator;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class WebServicesDescriptorNode
extends BundleNode
implements RootXMLNode {
    public static final XMLElement ROOT_ELEMENT = new XMLElement("webservices");
    public static final String SCHEMA_ID = "j2ee_web_services_1_1.xsd";
    private BundleDescriptor bundleDescriptor;

    public WebServicesDescriptorNode(BundleDescriptor descriptor) {
        this.bundleDescriptor = descriptor;
        this.registerElementHandler(new XMLElement("webservice-description"), WebServiceNode.class);
    }

    public WebServicesDescriptorNode() {
        this(null);
    }

    public String getDocType() {
        return null;
    }

    public String getSystemID() {
        return SCHEMA_ID;
    }

    protected String getSchemaURL() {
        return "http://www.ibm.com/webservices/xsd/" + this.getSystemID();
    }

    protected XMLElement getXMLRootTag() {
        return ROOT_ELEMENT;
    }

    public void setElementValue(XMLElement element, String value) {
        if ("version".equals(element.getQName())) {
            this.bundleDescriptor.getWebServices().setSpecVersion(value);
        } else {
            super.setElementValue(element, value);
        }
    }

    public void addDescriptor(Object descriptor) {
        WebServicesDescriptor webServicesDesc = this.bundleDescriptor.getWebServices();
        WebService webService = (WebService)descriptor;
        webServicesDesc.addWebService(webService);
        Iterator iter = webService.getEndpoints().iterator();
        while (iter.hasNext()) {
            WebServiceEndpoint next = (WebServiceEndpoint)iter.next();
            if (next.resolveComponentLink()) continue;
            DOLUtils.getDefaultLogger().info("Warning: Web service endpoint " + next.getEndpointName() + " component link " + next.getLinkName() + " is not valid");
        }
    }

    public Object getDescriptor() {
        return this.bundleDescriptor;
    }

    public Node writeDescriptor(Node parent, Descriptor descriptor) {
        Node topNode = parent;
        if (parent instanceof Document) {
            BundleDescriptor bundleDesc = (BundleDescriptor)descriptor;
            WebServicesDescriptor webServicesDesc = bundleDesc.getWebServices();
            topNode = super.writeDescriptor(parent, webServicesDesc);
            Collection services = webServicesDesc.getWebServices();
            Iterator iter = services.iterator();
            while (iter.hasNext()) {
                WebService next = (WebService)iter.next();
                WebServiceNode wsNode = new WebServiceNode();
                wsNode.writeDescriptor(topNode, "webservice-description", next);
            }
        }
        return parent;
    }

    public String getSpecVersion() {
        return "1.1";
    }
}

