/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.backend;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.WebService;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.backend.DeploymentRequest;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.webservice.WsUtil;
import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;

public class WebServiceDeployer {
    private static StringManager localStrings = StringManager.getManager(WebServiceDeployer.class);
    private DeploymentRequest request;
    static /* synthetic */ Class class$javax$servlet$SingleThreadModel;

    public WebServiceDeployer(DeploymentRequest request) {
        this.request = request;
    }

    public void doWebServiceDeployment(Application app, File appDir) throws Exception {
        Descriptor next;
        ClassLoader loader = app.getClassLoader();
        HashSet webBundles = new HashSet();
        HashSet webServices = new HashSet();
        webBundles.addAll(app.getWebBundleDescriptors());
        webServices.addAll(app.getWebServiceDescriptors());
        if (this.request.getContextRoot() != null && app.isVirtual()) {
            ((WebBundleDescriptor)webBundles.iterator().next()).setContextRoot(this.request.getContextRoot());
        }
        Iterator iter = webBundles.iterator();
        while (iter.hasNext()) {
            next = (WebBundleDescriptor)iter.next();
            this.doWebServiceDeployment((WebBundleDescriptor)next, appDir);
        }
        iter = webServices.iterator();
        while (iter.hasNext()) {
            next = (WebService)iter.next();
            URL clientPublishLocation = ((WebService)next).getClientPublishUrl();
            URL url = ((WebService)next).getWsdlFileUrl();
            File originalWsdlFile = new File(url.getPath());
            File tmpWsdlFile = File.createTempFile("final", "wsdl", originalWsdlFile.getParentFile());
            WsUtil wsUtil = new WsUtil();
            wsUtil.generateFinalWsdl(url, (WebService)next, wsUtil.getWebServerInfo(this.request), tmpWsdlFile);
            File renamedFile = new File(originalWsdlFile.getPath() + "__orig");
            if (renamedFile.exists()) {
                renamedFile.delete();
            }
            originalWsdlFile.renameTo(renamedFile);
            tmpWsdlFile.renameTo(originalWsdlFile);
        }
    }

    public void doWebServiceDeployment(WebBundleDescriptor web, File outDir) throws Exception {
        Collection endpoints = web.getWebServices().getEndpoints();
        ClassLoader loader = web.getClassLoader();
        boolean writeModule = !endpoints.isEmpty();
        Iterator endpointIter = endpoints.iterator();
        while (endpointIter.hasNext()) {
            WebServiceEndpoint nextEndpoint = (WebServiceEndpoint)endpointIter.next();
            WebComponentDescriptor webComp = nextEndpoint.getWebComponentImpl();
            String servletImplClass = nextEndpoint.getServletImplClass();
            if (!nextEndpoint.hasServletImplClass()) {
                throw new Exception(localStrings.getStringWithDefault("enterprise.deployment.backend.cannot_find_servlet", "Runtime settings error.  Cannot find servlet-impl-class for endpoint {0} ", new Object[]{nextEndpoint.getEndpointName()}));
            }
            if (!nextEndpoint.getWebService().hasFilePublishing()) {
                String publishingUri = nextEndpoint.getPublishingUri();
                String publishingUrlPattern = publishingUri.charAt(0) == '/' ? publishingUri : "/" + publishingUri + "/*";
                webComp.addUrlPattern(publishingUrlPattern);
            }
            Class<?> servletImplClazz = loader.loadClass(servletImplClass);
            String containerServlet = (class$javax$servlet$SingleThreadModel == null ? WebServiceDeployer.class$("javax.servlet.SingleThreadModel") : class$javax$servlet$SingleThreadModel).isAssignableFrom(servletImplClazz) ? "com.sun.enterprise.webservice.SingleThreadJAXRPCServlet" : "com.sun.enterprise.webservice.JAXRPCServlet";
            webComp.setWebComponentImplementation(containerServlet);
        }
    }
}

