/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.backend;

import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.backend.DeploymentLogger;
import com.sun.enterprise.deployment.backend.IASDeploymentException;
import com.sun.enterprise.deployment.runtime.web.JspConfig;
import com.sun.enterprise.deployment.runtime.web.SunWebApp;
import com.sun.enterprise.deployment.runtime.web.WebProperty;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import org.apache.jasper.JspC;

public class JSPCompiler {
    private static String startMessage;
    private static String finishMessage;
    private static Logger logger;

    public static void compile(File inWebDir, File outWebDir, WebBundleDescriptor wbd) throws IASDeploymentException {
        JSPCompiler.compile(inWebDir, outWebDir, wbd, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void compile(File inWebDir, File outWebDir, WebBundleDescriptor wbd, List classpathList) throws IASDeploymentException {
        block12: {
            block10: {
                String[] files2222;
                String classpath;
                JspC jspc = new JspC();
                if (classpathList != null && (classpath = JSPCompiler.getClasspath(classpathList)) != null) {
                    jspc.setClassPath(classpath);
                }
                JSPCompiler.verify(inWebDir, outWebDir);
                JSPCompiler.configureJspc(jspc, wbd);
                jspc.setOutputDir(outWebDir.getAbsolutePath());
                jspc.setUriroot(inWebDir.getAbsolutePath());
                jspc.setCompile(true);
                logger.info(startMessage);
                try {
                    try {
                        jspc.execute();
                    }
                    catch (Exception je) {
                        throw new IASDeploymentException("JSP Compilation Error: " + je, je);
                    }
                    Object var7_7 = null;
                    files2222 = outWebDir.list();
                    if (files2222 == null) break block10;
                }
                catch (Throwable throwable) {
                    Object var7_8 = null;
                    String[] files2222 = outWebDir.list();
                    if (files2222 == null || files2222.length <= 0) {
                        outWebDir.delete();
                    }
                    logger.info(finishMessage);
                    throw throwable;
                }
                if (files2222.length > 0) break block12;
            }
            outWebDir.delete();
        }
        logger.info(finishMessage);
    }

    private static void verify(File inWebDir, File outWebDir) throws IASDeploymentException {
        if (!FileUtils.safeIsDirectory(inWebDir)) {
            throw new IASDeploymentException("inWebDir is not a directory: " + inWebDir);
        }
        if (!FileUtils.safeIsDirectory(outWebDir)) {
            outWebDir.mkdirs();
            if (!FileUtils.safeIsDirectory(outWebDir)) {
                throw new IASDeploymentException("outWebDir is not a directory, and it can't be created: " + outWebDir);
            }
        }
    }

    private static String getClasspath(List paths) {
        if (paths == null) {
            return null;
        }
        String classpath = null;
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        Iterator it = paths.iterator();
        while (it.hasNext()) {
            String path = (String)it.next();
            if (first) {
                first = false;
            } else {
                sb.append(File.pathSeparatorChar);
            }
            sb.append(path);
        }
        if (sb.length() > 0) {
            classpath = sb.toString();
        }
        return classpath;
    }

    private static void configureJspc(JspC jspc, WebBundleDescriptor wbd) {
        SunWebApp sunWebApp = wbd.getSunDescriptor();
        if (sunWebApp == null) {
            return;
        }
        JspConfig jspConfig = sunWebApp.getJspConfig();
        if (jspConfig == null) {
            return;
        }
        WebProperty[] props = jspConfig.getWebProperty();
        for (int i = 0; props != null && i < props.length; ++i) {
            String pName = props[i].getAttributeValue("name");
            String pValue = props[i].getAttributeValue("value");
            if (pName == null || pValue == null) {
                throw new IllegalArgumentException("Missing jsp-config property name or value");
            }
            if ("xpoweredBy".equals(pName)) {
                jspc.setXpoweredBy(Boolean.valueOf(pValue));
                continue;
            }
            if ("classdebuginfo".equals(pName)) {
                jspc.setClassDebugInfo(Boolean.valueOf(pValue));
                continue;
            }
            if ("enablePooling".equals(pName)) {
                jspc.setPoolingEnabled(Boolean.valueOf(pValue));
                continue;
            }
            if ("ieClassId".equals(pName)) {
                jspc.setIeClassId(pValue);
                continue;
            }
            if ("trimSpaces".equals(pName)) {
                jspc.setTrimSpaces(Boolean.valueOf(pValue));
                continue;
            }
            if ("genStrAsCharArray".equals(pName)) {
                jspc.setGenStringAsCharArray(Boolean.valueOf(pValue));
                continue;
            }
            if (!"errorOnUseBeanInvalidClassAttribute".equals(pName)) continue;
            jspc.setErrorOnUseBeanInvalidClassAttribute(Boolean.valueOf(pValue));
        }
    }

    static {
        logger = DeploymentLogger.get();
        StringManager localStrings = StringManager.getManager(JSPCompiler.class);
        startMessage = localStrings.getStringWithDefault("enterprise.deployment.backend.start_jspc", "Beginning JSP Precompile...");
        finishMessage = localStrings.getStringWithDefault("enterprise.deployment.backend.finish_jspc", "Finished JSP Precompile");
    }
}

