/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.backend;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.RootDeploymentDescriptor;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.WebService;
import com.sun.enterprise.deployment.WebServicesDescriptor;
import com.sun.enterprise.deployment.archivist.AbstractArchive;
import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.deployment.archivist.ArchivistFactory;
import com.sun.enterprise.deployment.interfaces.ClientJarMaker;
import com.sun.enterprise.deployment.util.ModuleDescriptor;
import com.sun.enterprise.util.zip.ZipItem;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.zip.ZipException;

class ClientJarMakerImpl
implements ClientJarMaker {
    protected Properties props;

    public ClientJarMakerImpl(Properties props) {
        this.props = props;
    }

    public void create(RootDeploymentDescriptor descriptor, AbstractArchive source, AbstractArchive target, ZipItem[] stubs, Properties props) throws IOException {
        this.create(descriptor, source, source, target, stubs, props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create(RootDeploymentDescriptor descriptor, AbstractArchive source, AbstractArchive source2, AbstractArchive target, ZipItem[] stubs, Properties props) throws IOException {
        Object subEntries;
        HashSet<String> elements = new HashSet<String>();
        for (int i = 0; i < stubs.length; ++i) {
            OutputStream os;
            block23: {
                Object var13_13;
                ZipItem item = stubs[i];
                if (elements.contains(item.getName())) continue;
                elements.add(item.getName());
                os = null;
                InputStream is = null;
                try {
                    os = target.addEntry(item.getName());
                    is = new BufferedInputStream(new FileInputStream(item.getFile()));
                    Archivist.copyWithoutClose(is, os);
                    var13_13 = null;
                    if (is == null) break block23;
                }
                catch (Throwable throwable) {
                    var13_13 = null;
                    if (is != null) {
                        is.close();
                    }
                    if (os != null) {
                        target.closeEntry(os);
                    }
                    throw throwable;
                }
                is.close();
            }
            if (os == null) continue;
            target.closeEntry(os);
            {
                continue;
            }
        }
        Vector<String> moduleNames = new Vector<String>();
        if (descriptor.isApplication()) {
            Application app = (Application)descriptor;
            Iterator modules = app.getModules();
            while (modules.hasNext()) {
                ModuleDescriptor md = (ModuleDescriptor)modules.next();
                Archivist moduleArchivist = ArchivistFactory.getArchivistForType(md.getModuleType());
                AbstractArchive subSource = source.getEmbeddedArchive(md.getArchiveUri());
                AbstractArchive subSource2 = source2.getEmbeddedArchive(md.getArchiveUri());
                moduleNames.add(md.getArchiveUri());
                subEntries = new Vector<String>();
                ((Vector)subEntries).add("META-INF/MANIFEST.MF");
                WebServicesDescriptor wsd = md.getDescriptor().getWebServices();
                if (wsd != null) {
                    Iterator itr = wsd.getWebServices().iterator();
                    while (itr.hasNext()) {
                        WebService ws = (WebService)itr.next();
                        ((Vector)subEntries).add(ws.getMappingFileUri());
                    }
                }
                Set refs = md.getDescriptor().getServiceReferenceDescriptors();
                Iterator itr = refs.iterator();
                while (itr.hasNext()) {
                    ServiceReferenceDescriptor srd = (ServiceReferenceDescriptor)itr.next();
                    ((Vector)subEntries).add(srd.getMappingFileUri());
                }
                ArrayList<String> embeddedFiles = new ArrayList<String>();
                Enumeration e = subSource.entries();
                while (e.hasMoreElements()) {
                    String entryName = (String)e.nextElement();
                    if (entryName.endsWith(".xml") || ((Vector)subEntries).contains(entryName) || entryName.startsWith(md.getDescriptor().getWsdlDir())) {
                        embeddedFiles.add(entryName);
                        continue;
                    }
                    try {
                        this.copy(subSource, target, entryName);
                    }
                    catch (IOException ioe) {}
                }
                AbstractArchive subTarget = target.getEmbeddedArchive(md.getArchiveUri());
                Iterator itr2 = embeddedFiles.iterator();
                while (itr2.hasNext()) {
                    String entryName = (String)itr2.next();
                    this.copyWithOverride(subSource, subSource2, subTarget, entryName);
                }
                this.copy(subSource, subTarget, "META-INF/MANIFEST.MF");
                target.closeEntry(subTarget);
                source.closeEntry(subSource);
                source2.closeEntry(subSource2);
            }
        }
        Archivist archivist = ArchivistFactory.getArchivistForType(descriptor.getModuleType());
        String appClientFileName = target.getArchiveUri().substring(target.getArchiveUri().lastIndexOf(File.separatorChar) + 1);
        this.copy(source, target, "META-INF/MANIFEST.MF");
        ArrayList<String> xmlFiles = new ArrayList<String>();
        Enumeration e = source.entries(moduleNames.elements());
        while (e.hasMoreElements()) {
            String entryName = (String)e.nextElement();
            if (entryName.equals(appClientFileName)) continue;
            if (entryName.endsWith(".jar")) {
                AbstractArchive subSource = null;
                try {
                    subSource = source.getEmbeddedArchive(entryName);
                    subEntries = subSource.entries();
                    while (subEntries.hasMoreElements()) {
                        String subEntryName = (String)subEntries.nextElement();
                        this.copy(subSource, target, subEntryName);
                    }
                    continue;
                }
                finally {
                    if (subSource != null) {
                        source.closeEntry(subSource);
                    }
                    continue;
                }
            }
            if (entryName.endsWith(".xml")) {
                xmlFiles.add(entryName);
            }
            this.copyWithOverride(source, source2, target, entryName);
        }
        this.copy(source, source2, target, archivist.getStandardDDFile().getDeploymentDescriptorPath(), xmlFiles);
        this.copy(source, source2, target, archivist.getConfigurationDDFile().getDeploymentDescriptorPath(), xmlFiles);
    }

    private void copy(AbstractArchive source, AbstractArchive source2, AbstractArchive target, String fileEntryName, List xmlFiles) throws IOException {
        if (!xmlFiles.contains(fileEntryName)) {
            this.copyWithOverride(source, source2, target, fileEntryName);
        }
    }

    /*
     * Loose catch block
     */
    private void copy(AbstractArchive source, AbstractArchive target, String entryName) throws IOException {
        block21: {
            IOException closeEntryIOException2222;
            OutputStream os;
            InputStream is;
            block20: {
                block18: {
                    is = null;
                    os = null;
                    is = source.getEntry(entryName);
                    if (is == null) break block18;
                    try {
                        os = target.addEntry(entryName);
                    }
                    catch (ZipException ze) {
                        Object var8_8 = null;
                        IOException closeEntryIOException2222 = null;
                        if (os != null) {
                            try {
                                target.closeEntry(os);
                            }
                            catch (IOException ioe) {
                                closeEntryIOException2222 = ioe;
                            }
                        }
                        if (is != null) {
                            is.close();
                        }
                        if (closeEntryIOException2222 != null) {
                            throw closeEntryIOException2222;
                        }
                        return;
                    }
                    Archivist.copyWithoutClose(is, os);
                }
                Object var8_9 = null;
                closeEntryIOException2222 = null;
                if (os == null) break block20;
                try {
                    target.closeEntry(os);
                }
                catch (IOException ioe) {
                    closeEntryIOException2222 = ioe;
                }
            }
            if (is != null) {
                is.close();
            }
            if (closeEntryIOException2222 != null) {
                throw closeEntryIOException2222;
            }
            break block21;
            {
                catch (IOException ioe) {
                    throw ioe;
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                closeEntryIOException2222 = null;
                if (os != null) {
                    try {
                        target.closeEntry(os);
                    }
                    catch (IOException ioe) {
                        closeEntryIOException2222 = ioe;
                    }
                }
                if (is != null) {
                    is.close();
                }
                if (closeEntryIOException2222 != null) {
                    throw closeEntryIOException2222;
                }
                throw throwable;
            }
        }
    }

    private void copyWithOverride(AbstractArchive normalSource, AbstractArchive overridingSource, AbstractArchive target, String entryName) throws IOException {
        boolean result;
        InputStream is = overridingSource.getEntry(entryName);
        boolean bl = result = is != null;
        if (is != null) {
            is.close();
            this.copy(overridingSource, target, entryName);
        } else {
            this.copy(normalSource, target, entryName);
        }
    }
}

