/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.backend;

import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.backend.AppDeployerBase;
import com.sun.enterprise.deployment.backend.AppInfo;
import com.sun.enterprise.deployment.backend.ContextRootChecker;
import com.sun.enterprise.deployment.backend.DeploymentEvent;
import com.sun.enterprise.deployment.backend.DeploymentEventInfo;
import com.sun.enterprise.deployment.backend.DeploymentEventManager;
import com.sun.enterprise.deployment.backend.DeploymentRequest;
import com.sun.enterprise.deployment.backend.DeploymentUtils;
import com.sun.enterprise.deployment.backend.IASDeploymentException;
import com.sun.enterprise.deployment.phasing.DeploymentServiceUtils;
import com.sun.enterprise.instance.InstanceEnvironment;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.util.logging.Level;

public class AppUnDeployer
extends AppDeployerBase {
    private String failureMessage = "Undeployment Failed -- rolled back undeployment";
    private String successMessage = "Undeployment Successful for ";
    private boolean isMaybeCMPDropTables = false;
    private Application applicationDD = null;
    private static StringManager localStrings;
    static final /* synthetic */ boolean $assertionsDisabled;

    AppUnDeployer(DeploymentRequest r) throws IASDeploymentException {
        super(r);
    }

    public void doRequest() throws IASDeploymentException {
        this.doRequestPrepare();
        this.doRequestFinish();
    }

    public void doRequestPrepare() throws IASDeploymentException {
        try {
            this.begin();
        }
        catch (IASDeploymentException e) {
            throw e;
        }
        catch (Exception e) {
            String msg = localStrings.getString("enterprise.deployment.backend.dorequest_exception");
            this.logger.log(Level.WARNING, msg, e);
            throw new IASDeploymentException(msg, e);
        }
    }

    public void doRequestFinish() throws IASDeploymentException {
        try {
            this.predeploy();
            this.localBegin();
            this.undeploy();
            this.removePolicy();
        }
        catch (IASDeploymentException e) {
            throw e;
        }
        catch (Exception e) {
            String msg = localStrings.getString("enterprise.deployment.backend.dorequest_exception");
            this.logger.log(Level.WARNING, msg, e);
            throw new IASDeploymentException(msg, e);
        }
        finally {
            this.finish();
        }
    }

    public void cleanup_internal() {
        try {
            if (this.isMaybeCMPDropTables) {
                this.dropTables();
            }
            this.liquidate();
        }
        catch (Exception e) {
            this.logger.warning("Caught an Exception in cleanup_internal: " + e);
        }
    }

    protected AppInfo createAppInfo() throws IASDeploymentException {
        if (!$assertionsDisabled && this.getAppDir() == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.getAppName() == null) {
            throw new AssertionError();
        }
        return new AppInfo(this.getAppDir(), this.getAppName());
    }

    protected final File setAppDir() throws IASDeploymentException {
        try {
            return new File(DeploymentServiceUtils.getLocation(this.getAppName(), this.request.getType()));
        }
        catch (Exception e) {
            String msg = localStrings.getString("enterprise.deployment.backend.error_getting_app_directory", e);
            throw new IASDeploymentException(msg, e);
        }
    }

    private void undeploy() throws IASDeploymentException {
        try {
            this.getManager().unregisterDescriptor(this.getAppName());
            ContextRootChecker.undeploy(this.getInstanceEnv(), this.getAppName());
            this.addToSummary(this.successMessage + this.getAppName());
        }
        catch (Exception e) {
            if (e instanceof IASDeploymentException) {
                throw (IASDeploymentException)e;
            }
            throw new IASDeploymentException(e);
        }
    }

    private void liquidate() throws IASDeploymentException, ConfigException {
        InstanceEnvironment iEnv = this.getInstanceEnv();
        File aDir = this.getAppDir();
        File sDir = this.getStubsDir();
        File jDir = this.getJSPDir();
        File xDir = this.getXMLDir();
        if (!($assertionsDisabled || iEnv != null && aDir != null && sDir != null && jDir != null)) {
            throw new AssertionError();
        }
        if (iEnv.isIASOwned(aDir)) {
            if (FileUtils.safeIsDirectory(aDir)) {
                FileUtils.whack(aDir);
                this.logger.fine("Deleted Application Directory: " + aDir.getPath());
            } else {
                this.logger.warning("Can't delete Application Directory -- it isn't a directory: " + aDir.getPath());
            }
        } else {
            this.logger.fine("Did NOT delete Application Directory (Directory-Deployment): " + aDir);
        }
        if (FileUtils.safeIsDirectory(sDir)) {
            FileUtils.whack(sDir);
        } else {
            this.logger.finest("Can't delete Stubs Directory -- it isn't a directory: " + FileUtils.safeGetCanonicalPath(sDir));
        }
        if (FileUtils.safeIsDirectory(jDir)) {
            FileUtils.whack(jDir);
        } else {
            this.logger.finest("Can't delete JSP Directory -- it isn't a directory: " + FileUtils.safeGetCanonicalPath(jDir));
        }
        if (FileUtils.safeIsDirectory(xDir)) {
            FileUtils.whack(xDir);
        } else {
            this.logger.finest("Can't delete XML Directory -- it isn't a directory: " + FileUtils.safeGetCanonicalPath(xDir));
        }
    }

    private void localBegin() {
        try {
            if (this.getRequest().isMaybeCMPDropTables()) {
                this.isMaybeCMPDropTables = true;
                this.applicationDD = FileUtils.safeIsDirectory(this.getXMLDir()) ? DeploymentUtils.getAppDescriptor(this.getXMLDir().getAbsolutePath()) : DeploymentUtils.getAppDescriptor(this.getAppDir().getAbsolutePath());
                this.applicationDD.setRegistrationName(this.getAppName());
            }
        }
        catch (Exception e) {
            this.logger.warning("Caught an Exception in localBegin: " + e);
        }
    }

    private void dropTables() {
        if (!$assertionsDisabled && !this.isMaybeCMPDropTables) {
            throw new AssertionError();
        }
        try {
            DeploymentEventInfo info = new DeploymentEventInfo(this.getAppDir(), this.getStubsDir(), this.applicationDD, this.getRequest());
            DeploymentEvent ev = new DeploymentEvent(3, info);
            DeploymentEventManager.notifyDeploymentEvent(ev);
        }
        catch (Throwable t) {
            this.logger.warning("Caught a Throwable in dropTables: " + t);
        }
    }

    static {
        $assertionsDisabled = !AppUnDeployer.class.desiredAssertionStatus();
        localStrings = StringManager.getManager(AppUnDeployer.class);
    }
}

