/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.backend;

import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.deployment.backend.AppDeployer;
import com.sun.enterprise.deployment.backend.ContextRootChecker;
import com.sun.enterprise.deployment.backend.DeploymentRequest;
import com.sun.enterprise.deployment.backend.IASDeploymentException;
import com.sun.enterprise.deployment.phasing.DeploymentServiceUtils;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.util.io.FileSource;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.util.logging.Level;

public class AppReDeployer
extends AppDeployer {
    private String failureMessage = "\n*********************\n****Redeployment Failed -- rolled back redeployment";
    private String successMessage = "\n*********************\n****Redeployment Successful for ";
    private File oldAppDir = null;
    private File oldStubsDir = null;
    private File oldJSPDir = null;
    private File oldXMLDir = null;
    private File originalAppDir = null;
    private boolean appdirWasRenamed = false;
    private boolean appWasUnregistered = false;
    private static StringManager localStrings;
    static final /* synthetic */ boolean $assertionsDisabled;

    AppReDeployer(DeploymentRequest r) throws IASDeploymentException {
        super(r);
    }

    public void cleanup_internal() {
        try {
            if (this.isArchive() && this.oldAppDir != null) {
                FileUtils.whack(this.oldAppDir);
                if (this.oldAppDir.exists()) {
                    this.logger.info("Unable to delete previous deployment directory: " + this.oldAppDir.getPath());
                } else {
                    this.logger.info("Deleted previous deployment directory: " + this.oldAppDir.getPath());
                }
            }
        }
        catch (Exception e) {
            this.logger.info("Unable to delete previous deployment directory: " + this.oldAppDir.getPath());
        }
    }

    protected void begin() throws IASDeploymentException {
        super.begin();
        try {
            this.originalAppDir = new File(DeploymentServiceUtils.getLocation(this.getAppName(), this.request.getType()));
            this.getManager().unregisterDescriptor(this.getAppName());
            ContextRootChecker.undeploy(this.getInstanceEnv(), this.getAppName());
            this.removePolicy();
        }
        catch (Exception e) {
            String msg = localStrings.getString("enterprise.deployment.backend.error_getting_app_location", this.getAppName());
            throw new IASDeploymentException(msg, e);
        }
    }

    protected final void predeploy() throws IASDeploymentException {
        this.appWasUnregistered = true;
        super.predeploy();
        this.setOldDirs();
    }

    protected final File setAppDir() throws IASDeploymentException {
        File newAppDir = null;
        if (this.isArchive()) {
            newAppDir = this.setAppDirArchive();
        } else if (this.isDirectory()) {
            newAppDir = this.setAppDirDirectory();
        } else {
            String msg = localStrings.getString("enterprise.deployment.backend.redeployment_not_dir_or_archive");
            throw new IASDeploymentException(msg);
        }
        newAppDir.mkdirs();
        return newAppDir;
    }

    protected final File getOldStubsDir() {
        return this.oldStubsDir;
    }

    protected final File getOldAppDir() {
        return this.oldAppDir;
    }

    protected void postDeploy() throws ConfigException, IASDeploymentException {
        super.postDeploy();
        if (FileUtils.safeIsDirectory(this.oldStubsDir)) {
            FileUtils.whack(this.oldStubsDir);
        }
        if (FileUtils.safeIsDirectory(this.oldJSPDir)) {
            FileUtils.whack(this.oldJSPDir);
        }
        if (FileUtils.safeIsDirectory(this.oldXMLDir)) {
            FileUtils.whack(this.oldXMLDir);
        }
    }

    protected final void rollback() {
        try {
            if (this.isArchive()) {
                this.rollbackArchive();
            } else {
                this.rollbackDirectory();
            }
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "enterprise.deployment_rollback_error", e);
        }
    }

    protected String whatAreYou() {
        return "Redeployment";
    }

    private final void rollbackArchive() throws IASDeploymentException, ConfigException {
        if (this.appdirWasRenamed) {
            this.DeleteOrKeepFailedStubs(this.getStubsDir());
            if (FileUtils.safeIsDirectory(this.getJSPDir())) {
                FileUtils.whack(this.getJSPDir());
            }
            if (FileUtils.safeIsDirectory(this.getXMLDir())) {
                FileUtils.whack(this.getXMLDir());
            }
            if (FileUtils.safeIsDirectory(this.oldStubsDir)) {
                this.oldStubsDir.renameTo(this.getStubsDir());
            }
            if (FileUtils.safeIsDirectory(this.oldJSPDir)) {
                this.oldJSPDir.renameTo(this.getJSPDir());
            }
            if (FileUtils.safeIsDirectory(this.oldXMLDir)) {
                this.oldXMLDir.renameTo(this.getXMLDir());
            }
            boolean success = false;
            File appdir = this.getAppDir();
            if (FileUtils.safeIsDirectory(appdir) && FileUtils.safeIsDirectory(this.oldAppDir)) {
                FileUtils.whack(appdir);
                success = this.oldAppDir.renameTo(appdir);
            }
            if (!success) {
                FileUtils.whack(this.oldAppDir);
                this.logger.log(Level.SEVERE, "enterprise.deployment.backend.directoryRenameFailure", new Object[]{this.oldAppDir.getAbsolutePath(), appdir.getAbsolutePath()});
                ContextRootChecker.undeploy(this.getInstanceEnv(), this.getAppName());
            }
        } else if (this.getAppInfo() == null) {
            this.setAppInfo(this.originalAppDir, this.getAppName());
        }
        this.getManager().registerDescriptor(this.request.getName(), this.request.getDescriptor());
    }

    private final void rollbackDirectory() {
        this.request.setReRegisterOnFailure(false);
    }

    private final File setAppDirDirectory() throws IASDeploymentException {
        FileSource fileSource = this.request.getFileSource();
        if (!fileSource.exists()) {
            String msg = localStrings.getString("enterprise.deployment.backend.file_source_does_not_exist", fileSource);
            throw new IASDeploymentException(msg);
        }
        if (!$assertionsDisabled && !fileSource.isDirectory()) {
            throw new AssertionError();
        }
        File appDirectory = fileSource.getFile();
        return appDirectory;
    }

    private final File setAppDirArchive() throws IASDeploymentException {
        if (!$assertionsDisabled && this.originalAppDir == null) {
            throw new AssertionError();
        }
        File newAppDirectory = this.originalAppDir;
        this.oldAppDir = new File(newAppDirectory.getAbsolutePath() + "_old");
        FileUtils.whack(this.oldAppDir);
        this.appdirWasRenamed = FileUtils.renameFile(newAppDirectory, this.oldAppDir);
        if (!this.appdirWasRenamed) {
            String msg = localStrings.getString("enterprise.deployment.backend.directory_rename_error", newAppDirectory.getAbsolutePath(), this.oldAppDir.getAbsolutePath());
            throw new IASDeploymentException(msg);
        }
        return newAppDirectory;
    }

    private final void setOldDirs() throws IASDeploymentException {
        File stubsDirectory = this.getStubsDir();
        File jspDirectory = this.getJSPDir();
        File xmlDirectory = this.getXMLDir();
        if (FileUtils.safeIsDirectory(stubsDirectory)) {
            this.oldStubsDir = new File(stubsDirectory.getPath() + "_old");
            if (this.oldStubsDir.exists()) {
                if (this.oldStubsDir.isDirectory()) {
                    FileUtils.whack(this.oldStubsDir);
                } else {
                    this.oldStubsDir.delete();
                }
            }
            if (!stubsDirectory.renameTo(this.oldStubsDir)) {
                String msg = localStrings.getString("enterprise.deployment.backend.directory_rename_error", stubsDirectory.getPath(), this.oldStubsDir.getPath());
                throw new IASDeploymentException(msg);
            }
        }
        if (FileUtils.safeIsDirectory(jspDirectory)) {
            this.oldJSPDir = new File(jspDirectory.getPath() + "_old");
            if (this.oldJSPDir.exists()) {
                if (FileUtils.safeIsDirectory(this.oldJSPDir)) {
                    FileUtils.whack(this.oldJSPDir);
                } else {
                    this.oldJSPDir.delete();
                }
            }
            if (!jspDirectory.renameTo(this.oldJSPDir)) {
                String msg = localStrings.getString("enterprise.deployment.backend.directory_rename_error", jspDirectory.getPath(), this.oldJSPDir.getPath());
                throw new IASDeploymentException(msg);
            }
        }
        if (FileUtils.safeIsDirectory(xmlDirectory)) {
            this.oldXMLDir = new File(xmlDirectory.getPath() + "_old");
            if (this.oldXMLDir.exists()) {
                if (FileUtils.safeIsDirectory(this.oldXMLDir)) {
                    FileUtils.whack(this.oldXMLDir);
                } else {
                    this.oldXMLDir.delete();
                }
            }
            if (!xmlDirectory.renameTo(this.oldXMLDir)) {
                String msg = localStrings.getString("enterprise.deployment.backend.directory_rename_error", xmlDirectory.getPath(), this.oldXMLDir.getPath());
                throw new IASDeploymentException(msg);
            }
        }
    }

    static {
        $assertionsDisabled = !AppReDeployer.class.desiredAssertionStatus();
        localStrings = StringManager.getManager(AppReDeployer.class);
    }
}

