/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.backend;

import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.backend.DeployableObjectType;
import com.sun.enterprise.deployment.backend.DeploymentRequest;
import com.sun.enterprise.deployment.backend.IASDeploymentException;
import com.sun.enterprise.deployment.backend.J2EEModuleExploder;
import com.sun.enterprise.deployment.backend.ModuleDeployer;
import com.sun.enterprise.deployment.backend.ModuleInfo;
import com.sun.enterprise.instance.AppclientModulesManager;
import com.sun.enterprise.instance.BaseManager;
import com.sun.enterprise.instance.InstanceEnvironment;
import com.sun.enterprise.instance.ModuleEnvironment;
import com.sun.enterprise.loader.EJBClassPathUtils;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.util.zip.ZipItem;
import java.io.IOException;
import java.util.List;

public class AppClientModuleDeployer
extends ModuleDeployer {
    private static StringManager localStrings;
    static final /* synthetic */ boolean $assertionsDisabled;

    AppClientModuleDeployer(DeploymentRequest r) throws IASDeploymentException {
        super(r);
    }

    public void cleanup_internal() {
        try {
            if (this.request.isUnDeploy()) {
                this.liquidate();
            } else if (this.request.isReDeploy() && this.isArchive() && this.oldModuleDir != null) {
                FileUtils.whack(this.oldModuleDir);
            }
        }
        catch (Exception e) {
            this.logger.warning("Exception caught and ignored in cleanup_internal()");
        }
    }

    protected BaseManager createConfigManager(InstanceEnvironment ienv, ModuleEnvironment menv) throws IASDeploymentException, ConfigException {
        return new AppclientModulesManager(ienv);
    }

    protected void preDeploy() throws IASDeploymentException {
        if (!$assertionsDisabled && this.moduleDir == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !StringUtils.ok((String)this.moduleName)) {
            throw new AssertionError();
        }
        try {
            if (this.isRegistered()) {
                String msg = localStrings.getString("enterprise.deployment.backend.deploy_error_module_exists");
                throw new IASDeploymentException(msg);
            }
            this.liquidateModuleDirAndStubsDirIfTheyHappenToExist();
            if (this.request.isDirectory()) {
                this.moduleInfo = new ModuleInfo(this.moduleDir, this.moduleName);
                this.moduleInfo.setType(DeployableObjectType.CAR);
            } else {
                this.moduleInfo = J2EEModuleExploder.explode(this.request.getFileSource().getFile(), this.moduleDir, this.moduleName);
            }
            this.xmlDir.mkdirs();
            this.runVerifier();
        }
        catch (Exception e) {
            throw new IASDeploymentException(e.toString(), e);
        }
    }

    protected boolean needsStubs() {
        return true;
    }

    protected void preRedeploy() throws IASDeploymentException, ConfigException {
        this.setOldDirs();
        if (this.request.isDirectory()) {
            this.moduleInfo = new ModuleInfo(this.moduleDir, this.moduleName);
            this.moduleInfo.setType(DeployableObjectType.CAR);
        } else {
            try {
                this.moduleInfo = J2EEModuleExploder.explode(this.request.getFileSource().getFile(), this.moduleDir, this.moduleName);
            }
            catch (IOException e) {
                throw new IASDeploymentException(e.toString(), e);
            }
        }
        this.xmlDir.mkdir();
        this.runVerifier();
    }

    protected void deploy() throws IASDeploymentException, ConfigException {
        this.loadDescriptors();
        this.xmlDir.mkdirs();
        ZipItem[] clientStubs = this.runEJBC();
        this.createClientJar(clientStubs);
    }

    protected List getModuleClasspath(Application application) throws IASDeploymentException {
        try {
            return EJBClassPathUtils.getAppClientModuleClasspathList(application.getRegistrationName(), this.request.getDeployedDirectory().getCanonicalPath());
        }
        catch (Exception e) {
            throw new IASDeploymentException(e);
        }
    }

    static {
        $assertionsDisabled = !AppClientModuleDeployer.class.desiredAssertionStatus();
        localStrings = StringManager.getManager(AppClientModuleDeployer.class);
    }
}

