/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.autodeploy;

import com.sun.enterprise.deployment.autodeploy.AutoDeployControllerImpl;
import com.sun.enterprise.deployment.autodeploy.FileInfo;
import java.io.File;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AutoDeployedFilesManager {
    private static final Logger sLogger = AutoDeployControllerImpl.sLogger;
    protected static final String STATUS_DIR_NAME = ".autodeploystatus";
    protected String statDir = null;

    public AutoDeployedFilesManager() {
    }

    protected AutoDeployedFilesManager(String s) {
        this.statDir = s;
    }

    public static AutoDeployedFilesManager loadStatus(File statusDir) throws Exception {
        return AutoDeployedFilesManager.loadStatus(statusDir.getAbsolutePath());
    }

    public static AutoDeployedFilesManager loadStatus(String autoDeploymentDir) throws Exception {
        String statusDir = autoDeploymentDir + File.separator + STATUS_DIR_NAME;
        String sysAppDirPath = System.getProperty("com.sun.aas.installRoot") + File.separator + "lib" + File.separator + "install" + File.separator + "applications";
        File fileObj = new File(statusDir);
        if (!fileObj.exists() && !autoDeploymentDir.equals(sysAppDirPath)) {
            sLogger.log(Level.INFO, "autoDeployment status dir missing, creating a new one");
            fileObj.mkdirs();
        }
        AutoDeployedFilesManager adfm = new AutoDeployedFilesManager(statusDir);
        return adfm;
    }

    public void writeStatus() throws Exception {
    }

    boolean needsDeployment(FileInfo fi) {
        File statusDir = new File(this.statDir);
        if (!statusDir.exists()) {
            return true;
        }
        File statusFile = new File(statusDir, fi.getName());
        return !statusFile.exists() || fi.getLastModified() != statusFile.lastModified();
    }

    public void setDeployedFileInfo(File f) throws Exception {
        File statusFile = new File(new File(this.statDir), f.getName());
        statusFile.createNewFile();
        statusFile.setLastModified(f.lastModified());
    }

    public void deleteDeployedFileInfo(String f) throws Exception {
        File statusFile = new File(new File(this.statDir), f);
        statusFile.delete();
    }

    public File[] getFilesForDeployment(File[] latestFiles) {
        if (latestFiles == null) {
            return new File[0];
        }
        FileInfo latestInfo = null;
        ArrayList<File> arrList = new ArrayList<File>(2);
        for (int i = 0; i < latestFiles.length; ++i) {
            latestInfo = new FileInfo(latestFiles[i]);
            if (!this.needsDeployment(latestInfo)) continue;
            arrList.add(latestFiles[i]);
        }
        File[] ret = new File[arrList.size()];
        for (int j = 0; j < arrList.size(); ++j) {
            ret[j] = (File)arrList.get(j);
        }
        return ret;
    }

    public String[] getApplicationsForUndeployment(File[] latestFiles) {
        File statusDirFile = new File(this.statDir);
        File[] statusFiles = statusDirFile.listFiles();
        if (statusFiles == null) {
            return null;
        }
        String deployedFile = null;
        ArrayList<String> arrList = new ArrayList<String>(2);
        for (int i = 0; i < statusFiles.length; ++i) {
            deployedFile = statusFiles[i].getName();
            if (this.isInList(deployedFile, latestFiles)) continue;
            arrList.add(deployedFile);
        }
        String[] a = new String[arrList.size()];
        for (int j = 0; j < a.length; ++j) {
            a[j] = (String)arrList.get(j);
        }
        return a;
    }

    protected boolean isInList(String f, File[] list) {
        for (int i = 0; i < list.length; ++i) {
            if (!f.equals(list[i].getName())) continue;
            return true;
        }
        return false;
    }
}

