/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.archivist;

import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.RootDeploymentDescriptor;
import com.sun.enterprise.deployment.archivist.AbstractArchive;
import com.sun.enterprise.deployment.archivist.AbstractArchiveFactory;
import com.sun.enterprise.deployment.archivist.ApplicationArchivist;
import com.sun.enterprise.deployment.archivist.ArchivistFactory;
import com.sun.enterprise.deployment.archivist.JarArchiveFactory;
import com.sun.enterprise.deployment.archivist.PluggableArchivists;
import com.sun.enterprise.deployment.deploy.shared.Archive;
import com.sun.enterprise.deployment.io.DeploymentDescriptorFile;
import com.sun.enterprise.deployment.io.WebServicesDeploymentDescriptorFile;
import com.sun.enterprise.deployment.util.ModuleDescriptor;
import com.sun.enterprise.deployment.util.TracerVisitor;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.enterprise.deploy.shared.ModuleType;
import org.xml.sax.SAXParseException;

public abstract class Archivist {
    public static String MANIFEST_VERSION_VALUE = "1.0";
    protected String path;
    protected boolean handleRuntimeInfo = true;
    protected Manifest manifest;
    protected AbstractArchiveFactory abstractArchiveFactory = new JarArchiveFactory();
    protected PluggableArchivists pa = null;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(Archivist.class);
    protected ClassLoader classLoader = null;
    private boolean isValidatingXML = true;
    private boolean isValidatingRuntimeXML = false;
    private String validationLevel = "parsing";
    private String runtimeValidationLevel = "parsing";
    private static String WSDL = ".wsdl";
    private static String XML = ".xml";
    private static String XSD = ".xsd";

    protected void initializeContext(Archivist other) {
        this.handleRuntimeInfo = other.isHandlingRuntimeInfo();
        this.isValidatingXML = other.isValidatingXML;
        this.validationLevel = other.validationLevel;
        this.abstractArchiveFactory = other.getAbstractArchiveFactory();
        this.classLoader = other.classLoader;
    }

    public void setAbstractArchiveFactory(AbstractArchiveFactory aa) {
        this.abstractArchiveFactory = aa;
    }

    public AbstractArchiveFactory getAbstractArchiveFactory() {
        return this.abstractArchiveFactory;
    }

    public RootDeploymentDescriptor open(AbstractArchive archive) throws IOException, SAXParseException {
        this.setManifest(archive.getManifest());
        RootDeploymentDescriptor descriptor = this.readDeploymentDescriptors(archive);
        this.postOpen(descriptor, archive);
        return descriptor;
    }

    public RootDeploymentDescriptor open(String path) throws IOException, SAXParseException {
        this.path = path;
        File file = new File(path);
        if (!file.exists()) {
            throw new FileNotFoundException(path);
        }
        AbstractArchive abstractArchive = this.abstractArchiveFactory.openArchive(path);
        RootDeploymentDescriptor descriptor = this.open(abstractArchive);
        this.postOpen(descriptor, abstractArchive);
        abstractArchive.close();
        this.validate(null);
        return descriptor;
    }

    protected void postOpen(RootDeploymentDescriptor descriptor, AbstractArchive archive) throws IOException {
    }

    public RootDeploymentDescriptor open(File file) throws IOException, SAXParseException {
        return this.open(file.getAbsolutePath());
    }

    public RootDeploymentDescriptor readDeploymentDescriptors(AbstractArchive abstractArchive) throws IOException, SAXParseException {
        Descriptor descriptor = this.readStandardDeploymentDescriptor(abstractArchive);
        ModuleDescriptor newModule = this.createModuleDescriptor((BundleDescriptor)descriptor);
        newModule.setArchiveUri(abstractArchive.getArchiveUri());
        this.readWebServicesDescriptor(abstractArchive, descriptor);
        this.readRuntimeDeploymentDescriptor(abstractArchive, descriptor);
        return (RootDeploymentDescriptor)descriptor;
    }

    public Descriptor readStandardDeploymentDescriptor(AbstractArchive abstractArchive) throws IOException, SAXParseException {
        InputStream is = null;
        try {
            is = abstractArchive.getEntry(this.getStandardDDFile().getDeploymentDescriptorPath());
            if (is != null) {
                Descriptor result;
                DeploymentDescriptorFile ddFile = this.getStandardDDFile();
                ddFile.setXMLValidation(this.getXMLValidation());
                ddFile.setXMLValidationLevel(this.validationLevel);
                if (abstractArchive.getArchiveUri() != null) {
                    ddFile.setErrorReportingString(abstractArchive.getArchiveUri());
                }
                Descriptor descriptor = result = ddFile.read(is);
                return descriptor;
            }
            throw new IOException(localStrings.getLocalString("enterprise.deployment.archivist.nodeploymentdescriptorfile", "The archive {0} does not contain deployment descriptor file {1}", new Object[]{this.path, this.getStandardDDFile().getDeploymentDescriptorPath()}));
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void readRuntimeDeploymentDescriptor(AbstractArchive abstractArchive, Descriptor descriptor) throws IOException, SAXParseException {
        String ddFileEntryName = this.getRuntimeDeploymentDescriptorPath();
        if (!this.isHandlingRuntimeInfo() || ddFileEntryName == null) {
            return;
        }
        InputStream is = null;
        try {
            is = abstractArchive.getEntry(ddFileEntryName);
            DeploymentDescriptorFile confDD = this.getConfigurationDDFile();
            if (abstractArchive.getArchiveUri() != null) {
                confDD.setErrorReportingString(abstractArchive.getArchiveUri());
            }
            if (is != null && confDD != null) {
                confDD.setXMLValidation(this.getRuntimeXMLValidation());
                confDD.setXMLValidationLevel(this.runtimeValidationLevel);
                confDD.read(descriptor, is);
            }
            Object var7_6 = null;
            if (is == null) return;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (is == null) throw throwable;
            try {
                is.close();
                throw throwable;
            }
            catch (IOException ioe) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            is.close();
            return;
        }
        catch (IOException ioe) {}
    }

    public void readRuntimeDDFromDeploymentPlan(AbstractArchive planArchive, Descriptor descriptor) throws IOException, SAXParseException {
        String runtimeDDPath = this.getRuntimeDeploymentDescriptorPath();
        if (runtimeDDPath == null || planArchive == null) {
            return;
        }
        Vector dpEntries = new Vector();
        Enumeration e = planArchive.entries();
        while (e.hasMoreElements()) {
            dpEntries.add(e.nextElement());
        }
        String entry = runtimeDDPath.substring(runtimeDDPath.lastIndexOf(47) + 1);
        if (dpEntries.contains(entry)) {
            this.readRuntimeDDFromDeploymentPlan(entry, planArchive, descriptor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void readRuntimeDDFromDeploymentPlan(String entry, AbstractArchive planArchive, Descriptor descriptor) throws IOException, SAXParseException {
        InputStream is = null;
        try {
            is = planArchive.getEntry(entry);
            DeploymentDescriptorFile confDD = this.getConfigurationDDFile();
            if (is != null && confDD != null) {
                if (planArchive.getArchiveUri() != null) {
                    confDD.setErrorReportingString(planArchive.getArchiveUri());
                }
                confDD.setXMLValidation(this.getXMLValidation());
                confDD.read(descriptor, is);
            }
            Object var7_6 = null;
            if (is == null) return;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (is == null) throw throwable;
            try {
                is.close();
                throw throwable;
            }
            catch (IOException ioe) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            is.close();
            return;
        }
        catch (IOException ioe) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readWebServicesDescriptor(AbstractArchive abstractArchive, Descriptor descriptor) throws IOException, SAXParseException {
        DeploymentDescriptorFile confDD = this.getWebServicesDDFile(descriptor);
        if (abstractArchive.getArchiveUri() != null) {
            confDD.setErrorReportingString(abstractArchive.getArchiveUri());
        }
        InputStream is = null;
        try {
            is = abstractArchive.getEntry(confDD.getDeploymentDescriptorPath());
            if (is != null) {
                confDD.setXMLValidation(this.getXMLValidation());
                confDD.setXMLValidationLevel(this.validationLevel);
                confDD.read(descriptor, is);
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    public void write() throws IOException {
        this.write(this.path);
    }

    public void write(String outPath) throws IOException {
        AbstractArchive in = this.abstractArchiveFactory.openArchive(this.path);
        this.write(in, outPath);
        in.close();
    }

    public void write(AbstractArchive in, String outPath) throws IOException {
        AbstractArchive oldArchive = null;
        try {
            oldArchive = this.abstractArchiveFactory.openArchive(outPath);
        }
        catch (IOException ioe) {
            // empty catch block
        }
        Archive out = null;
        File fOut = new File(outPath);
        Object bos = null;
        try {
            String tmpName = null;
            if (oldArchive != null && oldArchive.exists() && !oldArchive.supportsElementsOverwriting()) {
                File outputFile = Archivist.getTempFile(outPath);
                tmpName = outputFile.getAbsolutePath();
                outputFile.delete();
                out = this.abstractArchiveFactory.createArchive(tmpName);
                oldArchive.close();
            } else {
                out = this.abstractArchiveFactory.createArchive(outPath);
            }
            this.writeContents(in, (AbstractArchive)out);
            out.close();
            in.close();
            if (tmpName != null) {
                AbstractArchive finalArchive = this.abstractArchiveFactory.openArchive(outPath);
                finalArchive.delete();
                AbstractArchive tmpArchive = this.abstractArchiveFactory.openArchive(tmpName);
                tmpArchive.renameTo(outPath);
            }
        }
        catch (IOException ioe) {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException outIoe) {
                    // empty catch block
                }
            }
            throw ioe;
        }
    }

    public void write(AbstractArchive in, AbstractArchive out) throws IOException {
        this.writeContents(in, out);
    }

    protected void writeContents(AbstractArchive out) throws IOException {
        AbstractArchive in = this.abstractArchiveFactory.openArchive(this.path);
        this.writeContents(in, out);
        in.close();
    }

    protected void writeContents(AbstractArchive in, AbstractArchive out) throws IOException {
        this.writeContents(in, out, null);
    }

    protected void writeContents(AbstractArchive in, AbstractArchive out, Vector entriesToSkip) throws IOException {
        if (in != null && in.exists()) {
            if (entriesToSkip == null) {
                entriesToSkip = this.getListOfFilesToSkip();
            } else {
                entriesToSkip.addAll(this.getListOfFilesToSkip());
            }
            this.copyJarElements(in, out, entriesToSkip);
        }
        this.writeDeploymentDescriptors(out);
        if (this.manifest != null) {
            OutputStream os = out.putNextEntry("META-INF/MANIFEST.MF");
            this.manifest.write(new DataOutputStream(os));
            out.closeEntry(os);
        }
    }

    public void writeDeploymentDescriptors(AbstractArchive out) throws IOException {
        this.writeStandardDeploymentDescriptors(out);
        this.writeExtraDeploymentDescriptors(out);
    }

    public void writeStandardDeploymentDescriptors(AbstractArchive out) throws IOException {
        OutputStream os = out.addEntry(this.getDeploymentDescriptorPath());
        this.writeStandardDeploymentDescriptors(os);
        out.closeEntry(os);
        Descriptor desc = this.getDescriptor();
        if (desc instanceof BundleDescriptor) {
            this.writeWebServicesDescriptors((BundleDescriptor)desc, out);
        }
    }

    public void writeRuntimeDeploymentDescriptors(AbstractArchive out) throws IOException {
        DeploymentDescriptorFile confDD;
        Descriptor desc = this.getDescriptor();
        if (this.isHandlingRuntimeInfo() && (confDD = this.getConfigurationDDFile()) != null) {
            OutputStream os = out.addEntry(this.getRuntimeDeploymentDescriptorPath());
            confDD.write(desc, os);
            out.closeEntry(os);
        }
    }

    protected void writeExtraDeploymentDescriptors(AbstractArchive out) throws IOException {
        this.writeRuntimeDeploymentDescriptors(out);
    }

    public void writeStandardDeploymentDescriptors(OutputStream os) {
        this.getStandardDDFile().write(this.getDescriptor(), os);
    }

    public void writeRuntimeDeploymentDescriptors(OutputStream os) {
        DeploymentDescriptorFile confDD = this.getConfigurationDDFile();
        if (confDD != null) {
            confDD.write(this.getDescriptor(), os);
        }
    }

    protected void writeWebServicesDescriptors(BundleDescriptor desc, AbstractArchive out) throws IOException {
        if (desc.hasWebServices()) {
            DeploymentDescriptorFile webServicesDD = this.getWebServicesDDFile(desc);
            OutputStream os = out.addEntry(webServicesDD.getDeploymentDescriptorPath());
            webServicesDD.write((Descriptor)desc, os);
            out.closeEntry(os);
        }
    }

    public String getDeploymentDescriptorPath() {
        return this.getStandardDDFile().getDeploymentDescriptorPath();
    }

    public String getWebServicesDeploymentDescriptorPath() {
        return null;
    }

    public String getRuntimeDeploymentDescriptorPath() {
        DeploymentDescriptorFile ddFile = this.getConfigurationDDFile();
        if (ddFile != null) {
            return ddFile.getDeploymentDescriptorPath();
        }
        return null;
    }

    public boolean containsRuntimeDeploymentDescriptors(AbstractArchive in) {
        String ddFileName = this.getRuntimeDeploymentDescriptorPath();
        if (ddFileName == null) {
            return false;
        }
        Enumeration e = in.entries();
        while (e.hasMoreElements()) {
            String entryName = (String)e.nextElement();
            if (!entryName.equals(ddFileName)) continue;
            return true;
        }
        return false;
    }

    public void setModuleDescriptor(ModuleDescriptor module) {
        this.setDescriptor(module.getDescriptor());
        this.setManifest(module.getManifest());
    }

    public abstract void setDescriptor(Descriptor var1);

    public abstract Descriptor getDescriptor();

    public abstract ModuleType getModuleType();

    public abstract DeploymentDescriptorFile getStandardDDFile();

    public abstract DeploymentDescriptorFile getConfigurationDDFile();

    public DeploymentDescriptorFile getWebServicesDDFile(Descriptor desc) {
        return new WebServicesDeploymentDescriptorFile(desc);
    }

    public boolean handles(AbstractArchive abstractArchive) throws IOException {
        InputStream is = abstractArchive.getEntry(this.getDeploymentDescriptorPath());
        if (is != null) {
            is.close();
            return true;
        }
        return false;
    }

    public ModuleDescriptor createModuleDescriptor(BundleDescriptor descriptor) {
        ModuleDescriptor newModule = new ModuleDescriptor();
        newModule.setModuleType(this.getModuleType());
        newModule.setDescriptor(descriptor);
        this.setDescriptor(descriptor);
        return newModule;
    }

    public void printDescriptor() {
        this.getDescriptor().visit(new TracerVisitor());
    }

    public void setHandleRuntimeInfo(boolean handleRuntimeInfo) {
        this.handleRuntimeInfo = handleRuntimeInfo;
    }

    public boolean isHandlingRuntimeInfo() {
        return this.handleRuntimeInfo;
    }

    public void setManifest(Manifest m) {
        this.manifest = m;
    }

    public Manifest getManifest() {
        return this.manifest;
    }

    public void setClassPath(String newClassPath) {
        if (this.manifest == null) {
            this.manifest = new Manifest();
        }
        Attributes atts = this.manifest.getMainAttributes();
        atts.putValue(Attributes.Name.CLASS_PATH.toString(), newClassPath);
    }

    public String getClassPath() {
        if (this.manifest == null) {
            return null;
        }
        Attributes atts = this.manifest.getMainAttributes();
        return atts.getValue(Attributes.Name.CLASS_PATH);
    }

    protected String getUniqueEntryFilenameFor(AbstractArchive archive, String trialName) throws IOException {
        Vector entriesNames = new Vector();
        Enumeration enumeration = archive.entries();
        while (enumeration != null && enumeration.hasMoreElements()) {
            entriesNames.add(enumeration.nextElement());
        }
        return Descriptor.createUniqueFilenameAmongst(trialName, entriesNames);
    }

    protected ModuleDescriptor addToArchive(ApplicationArchivist appArch, String externalDD) throws IOException, SAXParseException {
        File externalDescriptorFile;
        AbstractArchive archiveToBeAdded = this.abstractArchiveFactory.openArchive(this.path);
        File archiveFile = new File(this.path);
        AbstractArchive appArchive = this.abstractArchiveFactory.openArchive(appArch.getArchiveUri());
        String archiveName = this.getUniqueEntryFilenameFor(appArchive, archiveFile.getName());
        appArchive.close();
        Descriptor descriptor = null;
        if (externalDD != null && !"".equals(externalDD) && (externalDescriptorFile = new File(externalDD)).exists()) {
            FileInputStream fis = new FileInputStream(externalDescriptorFile);
            try {
                DeploymentDescriptorFile ddf = this.getStandardDDFile();
                descriptor = ddf.read(fis);
            }
            catch (SAXParseException pe) {
                archiveToBeAdded.close();
                pe.printStackTrace();
                throw pe;
            }
        }
        if (descriptor == null) {
            descriptor = this.open(archiveToBeAdded);
        }
        archiveToBeAdded.close();
        if (descriptor instanceof BundleDescriptor) {
            ModuleDescriptor newModule = new ModuleDescriptor();
            newModule.setArchiveUri(archiveName);
            newModule.setModuleType(this.getModuleType());
            newModule.setDescriptor((BundleDescriptor)descriptor);
            newModule.setManifest(this.getManifest());
            if (externalDD != null && !"".equals(externalDD)) {
                newModule.setAlternateDescriptor(externalDD);
            }
            return newModule;
        }
        return null;
    }

    protected void prepareForInclusion(AbstractArchive out) throws IOException {
    }

    public void saveRuntimeInfo(File output) throws IOException {
        File outputFile = output;
        if (outputFile == null) {
            outputFile = Archivist.getTempFile(this.path);
        }
        AbstractArchive out = this.abstractArchiveFactory.createArchive(outputFile.getAbsolutePath());
        AbstractArchive in = this.abstractArchiveFactory.openArchive(this.path);
        Vector<String> skipFiles = new Vector<String>();
        skipFiles.add(this.getRuntimeDeploymentDescriptorPath());
        this.copyInto(in, out, skipFiles);
        in.close();
        OutputStream os = out.addEntry(this.getRuntimeDeploymentDescriptorPath());
        this.writeRuntimeDeploymentDescriptors(os);
        out.closeEntry(os);
        out.close();
        if (output == null) {
            AbstractArchive finalArchive = this.abstractArchiveFactory.openArchive(this.path);
            finalArchive.delete();
            AbstractArchive tmpArchive = this.abstractArchiveFactory.openArchive(outputFile.getAbsolutePath());
            tmpArchive.renameTo(this.path);
        }
    }

    public void applyRuntimeInfo(File runtimeDD, File output) throws IOException, SAXParseException {
        this.getConfigurationDDFile().read(this.getDescriptor(), new FileInputStream(runtimeDD));
        this.saveRuntimeInfo(output);
    }

    public static void copyWithoutClose(InputStream is, OutputStream os) throws IOException {
        byte[] buf = new byte[4096];
        int len = 0;
        while (len != -1) {
            try {
                len = is.read(buf, 0, buf.length);
            }
            catch (EOFException eof) {
                break;
            }
            if (len == -1) continue;
            os.write(buf, 0, len);
        }
        os.flush();
    }

    public static void copy(InputStream is, OutputStream os) throws IOException {
        Archivist.copyWithoutClose(is, os);
        is.close();
        os.close();
    }

    protected static File getTempFile(String fileOrDirPath) throws IOException {
        if (fileOrDirPath != null) {
            return Archivist.getTempFile(new File(fileOrDirPath));
        }
        return Archivist.getTempFile((File)null);
    }

    public Vector getListOfFilesToSkip() {
        Vector<String> filesToSkip = new Vector<String>();
        filesToSkip.add(this.getDeploymentDescriptorPath());
        if (this.manifest != null) {
            filesToSkip.add("META-INF/MANIFEST.MF");
        }
        if (this.getRuntimeDeploymentDescriptorPath() != null) {
            filesToSkip.add(this.getRuntimeDeploymentDescriptorPath());
        }
        filesToSkip.addAll(WebServicesDeploymentDescriptorFile.getAllDescriptorPaths());
        return filesToSkip;
    }

    protected static File getTempFile(File fileOrDir) throws IOException {
        File dir = null;
        if (fileOrDir == null) {
            dir = new File(System.getProperty("user.dir"));
        } else if (!fileOrDir.isDirectory()) {
            dir = fileOrDir.getParentFile();
            if (dir == null) {
                dir = new File(System.getProperty("user.dir"));
            }
        } else {
            dir = fileOrDir;
        }
        return File.createTempFile("tmp", ".jar", dir);
    }

    protected static void addFileToArchive(AbstractArchive archive, String filePath, String entryName) throws IOException {
        FileInputStream is = new FileInputStream(new File(filePath));
        OutputStream os = archive.addEntry(entryName);
        Archivist.copyWithoutClose(is, os);
        is.close();
        archive.closeEntry(os);
    }

    protected void copyJarElements(AbstractArchive in, AbstractArchive out, Vector ignoreList) throws IOException {
        Enumeration entries = in.entries();
        Enumeration outEntriesItr = out.entries();
        while (outEntriesItr.hasMoreElements()) {
            if (ignoreList == null) {
                ignoreList = new Vector();
            }
            ignoreList.add(outEntriesItr.nextElement());
        }
        if (entries != null) {
            while (entries.hasMoreElements()) {
                String anEntry = (String)entries.nextElement();
                if (ignoreList != null && ignoreList.contains(anEntry)) continue;
                InputStream is = in.getEntry(anEntry);
                OutputStream os = out.addEntry(anEntry);
                Archivist.copyWithoutClose(is, os);
                is.close();
                out.closeEntry(os);
            }
        }
    }

    protected boolean renameTmp(String from, String to) throws IOException {
        AbstractArchive finalArchive = this.abstractArchiveFactory.openArchive(to);
        finalArchive.delete();
        AbstractArchive tmpArchive = this.abstractArchiveFactory.openArchive(from);
        boolean success = tmpArchive.renameTo(to);
        if (!success) {
            throw new IOException("Error renaming JAR");
        }
        return success;
    }

    public void setArchiveUri(String path) {
        this.path = path;
    }

    public String getArchiveUri() {
        return this.path;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setXMLValidation(boolean validate) {
        this.isValidatingXML = validate;
    }

    public boolean getXMLValidation() {
        return this.isValidatingXML;
    }

    public void setRuntimeXMLValidation(boolean validate) {
        this.isValidatingRuntimeXML = validate;
    }

    public boolean getRuntimeXMLValidation() {
        return this.isValidatingRuntimeXML;
    }

    public void setXMLValidationLevel(String level) {
        this.validationLevel = level;
    }

    public String getXMLValidationLevel() {
        return this.validationLevel;
    }

    public void setRuntimeXMLValidationLevel(String level) {
        this.runtimeValidationLevel = level;
    }

    public String getRuntimeXMLValidationLevel() {
        return this.runtimeValidationLevel;
    }

    public void validate(ClassLoader aClassLoader) {
    }

    public void copyInto(AbstractArchive target) throws IOException {
        AbstractArchive source = this.abstractArchiveFactory.openArchive(this.path);
        this.copyInto(source, target);
    }

    public void copyInto(AbstractArchive source, AbstractArchive target) throws IOException {
        this.copyInto(source, target, null, true);
    }

    public void copyInto(AbstractArchive source, AbstractArchive target, boolean overwriteManifest) throws IOException {
        this.copyInto(source, target, null, overwriteManifest);
    }

    public void copyInto(AbstractArchive source, AbstractArchive target, Vector entriesToSkip) throws IOException {
        this.copyInto(source, target, entriesToSkip, true);
    }

    public void copyInto(AbstractArchive source, AbstractArchive target, Vector entriesToSkip, boolean overwriteManifest) throws IOException {
        Manifest m;
        this.copyJarElements(source, target, entriesToSkip);
        if (overwriteManifest && (m = source.getManifest()) != null) {
            OutputStream os = target.addEntry("META-INF/MANIFEST.MF");
            m.write(os);
            target.closeEntry(os);
        }
    }

    public void extractEntry(String entryName, File out) throws IOException {
        AbstractArchive archive = this.abstractArchiveFactory.openArchive(this.path);
        InputStream is = archive.getEntry(entryName);
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(out));
        Archivist.copy(new BufferedInputStream(is), os);
        archive.close();
    }

    public void setPluggableArchivists(PluggableArchivists pa) {
        this.pa = pa;
    }

    public PluggableArchivists getPluggableArchivists() {
        if (this.pa == null) {
            return ArchivistFactory.getPluggableArchivists();
        }
        return this.pa;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyAnEntry(AbstractArchive in, AbstractArchive out, String entryName) throws IOException {
        OutputStream os;
        InputStream is2;
        block8: {
            InputStream is = null;
            is2 = null;
            os = null;
            try {
                is = in.getEntry(entryName);
                is2 = out.getEntry(entryName);
                if (is != null && is2 == null) {
                    os = out.addEntry(entryName);
                    Archivist.copyWithoutClose(is, os);
                }
                Object var7_6 = null;
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (is != null) {
                    is.close();
                }
                if (is2 != null) {
                    is2.close();
                }
                if (os != null) {
                    out.closeEntry(os);
                }
                throw throwable;
            }
            is.close();
        }
        if (is2 != null) {
            is2.close();
        }
        if (os != null) {
            out.closeEntry(os);
        }
    }

    public void copyStandardDeploymentDescriptors(AbstractArchive in, AbstractArchive out) throws IOException {
        BundleDescriptor desc2;
        String entryName = this.getDeploymentDescriptorPath();
        Archivist.copyAnEntry(in, out, entryName);
        Descriptor desc = this.getDescriptor();
        if (desc instanceof BundleDescriptor && (desc2 = (BundleDescriptor)desc).hasWebServices()) {
            DeploymentDescriptorFile webServicesDD = this.getWebServicesDDFile(desc2);
            String anEntry = webServicesDD.getDeploymentDescriptorPath();
            Archivist.copyAnEntry(in, out, anEntry);
        }
    }

    public static void copyExtraElements(AbstractArchive in, AbstractArchive out) throws IOException {
        Enumeration entries = in.entries();
        if (entries != null) {
            while (entries.hasMoreElements()) {
                String anEntry = (String)entries.nextElement();
                if (anEntry.indexOf(WSDL) == -1 && anEntry.indexOf(XML) == -1 && anEntry.indexOf(XSD) == -1) continue;
                Archivist.copyAnEntry(in, out, anEntry);
            }
        }
    }
}

