/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbReferenceDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.JmsDestinationReferenceDescriptor;
import com.sun.enterprise.deployment.MessageDestinationReferenceDescriptor;
import com.sun.enterprise.deployment.NamedDescriptor;
import com.sun.enterprise.deployment.OrderedSet;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.WritableJndiNameEnvironment;
import com.sun.enterprise.deployment.types.EjbReference;
import com.sun.enterprise.deployment.types.EjbReferenceContainer;
import com.sun.enterprise.deployment.types.MessageDestinationReferenceContainer;
import com.sun.enterprise.deployment.types.MessageDestinationReferencer;
import com.sun.enterprise.deployment.types.ResourceEnvReferenceContainer;
import com.sun.enterprise.deployment.types.ResourceReferenceContainer;
import com.sun.enterprise.deployment.util.AppClientVisitor;
import com.sun.enterprise.deployment.util.DescriptorVisitor;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.enterprise.deploy.shared.ModuleType;

public class ApplicationClientDescriptor
extends BundleDescriptor
implements WritableJndiNameEnvironment,
ResourceReferenceContainer,
EjbReferenceContainer,
ResourceEnvReferenceContainer,
MessageDestinationReferenceContainer {
    private Set environmentProperties;
    private Set ejbReferences;
    private Set jmsDestReferences;
    private Set messageDestReferences;
    private Set resourceReferences;
    private Set serviceReferences;
    private String mainClassName;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ApplicationClientDescriptor.class);
    private String callbackHandler = null;

    public boolean hasRuntimeInformation() {
        Iterator itr = this.getNamedDescriptors().iterator();
        while (itr.hasNext()) {
            NamedDescriptor next = (NamedDescriptor)itr.next();
            if ("".equals(next.getJndiName())) continue;
            return true;
        }
        return false;
    }

    public String getMainClassName() {
        if (this.mainClassName == null) {
            this.mainClassName = "";
        }
        return this.mainClassName;
    }

    public void setMainClassName(String mainClassName) {
        this.mainClassName = mainClassName;
        this.changed();
    }

    public String getCallbackHandler() {
        return this.callbackHandler;
    }

    public void setCallbackHandler(String handler) {
        this.callbackHandler = handler;
        this.changed();
    }

    public Collection getNamedDescriptors() {
        return super.getNamedDescriptorsFrom(this);
    }

    public Vector getNamedReferencePairs() {
        return super.getNamedReferencePairsFrom(this);
    }

    public Set getEnvironmentProperties() {
        if (this.environmentProperties == null) {
            this.environmentProperties = new OrderedSet();
        }
        this.environmentProperties = new OrderedSet((Collection)this.environmentProperties);
        return this.environmentProperties;
    }

    public void addEnvironmentProperty(EnvironmentProperty environmentProperty) {
        this.getEnvironmentProperties().add(environmentProperty);
        this.changed();
    }

    public void removeEnvironmentProperty(EnvironmentProperty environmentProperty) {
        this.getEnvironmentProperties().remove(environmentProperty);
        this.changed();
    }

    public Set getEjbReferenceDescriptors() {
        if (this.ejbReferences == null) {
            this.ejbReferences = new OrderedSet();
        }
        this.ejbReferences = new OrderedSet((Collection)this.ejbReferences);
        return this.ejbReferences;
    }

    public void addEjbReferenceDescriptor(EjbReferenceDescriptor ejbReference) {
        this.addEjbReferenceDescriptor((EjbReference)ejbReference);
    }

    public void addEjbReferenceDescriptor(EjbReference ejbReference) {
        this.getEjbReferenceDescriptors().add(ejbReference);
        ejbReference.setReferringBundleDescriptor(this);
        this.changed();
    }

    public void removeEjbReferenceDescriptor(EjbReferenceDescriptor ejbReference) {
        this.removeEjbReferenceDescriptor((EjbReference)ejbReference);
    }

    public void removeEjbReferenceDescriptor(EjbReference ejbReference) {
        this.getEjbReferenceDescriptors().remove(ejbReference);
        ejbReference.setReferringBundleDescriptor(null);
        this.changed();
    }

    public Set getServiceReferenceDescriptors() {
        if (this.serviceReferences == null) {
            this.serviceReferences = new OrderedSet();
        }
        this.serviceReferences = new OrderedSet((Collection)this.serviceReferences);
        return this.serviceReferences;
    }

    public void addServiceReferenceDescriptor(ServiceReferenceDescriptor serviceRef) {
        serviceRef.setBundleDescriptor(this);
        this.getServiceReferenceDescriptors().add(serviceRef);
        this.changed();
    }

    public void removeServiceReferenceDescriptor(ServiceReferenceDescriptor serviceRef) {
        this.getServiceReferenceDescriptors().remove(serviceRef);
        this.changed();
    }

    public ServiceReferenceDescriptor getServiceReferenceByName(String name) {
        Iterator itr = this.getServiceReferenceDescriptors().iterator();
        while (itr.hasNext()) {
            ServiceReferenceDescriptor srd = (ServiceReferenceDescriptor)itr.next();
            if (!srd.getName().equals(name)) continue;
            return srd;
        }
        throw new IllegalArgumentException("This application client has no service refernce by the name " + name);
    }

    public Set getMessageDestinationReferenceDescriptors() {
        if (this.messageDestReferences == null) {
            this.messageDestReferences = new OrderedSet();
        }
        this.messageDestReferences = new OrderedSet((Collection)this.messageDestReferences);
        return this.messageDestReferences;
    }

    public void addMessageDestinationReferenceDescriptor(MessageDestinationReferenceDescriptor messageDestRef) {
        messageDestRef.setReferringBundleDescriptor(this);
        this.getMessageDestinationReferenceDescriptors().add(messageDestRef);
        this.changed();
    }

    public void removeMessageDestinationReferenceDescriptor(MessageDestinationReferenceDescriptor msgDestRef) {
        this.getMessageDestinationReferenceDescriptors().remove(msgDestRef);
        this.changed();
    }

    public MessageDestinationReferenceDescriptor getMessageDestinationReferenceByName(String name) {
        Iterator itr = this.getMessageDestinationReferenceDescriptors().iterator();
        while (itr.hasNext()) {
            MessageDestinationReferenceDescriptor mdr = (MessageDestinationReferenceDescriptor)itr.next();
            if (!mdr.getName().equals(name)) continue;
            return mdr;
        }
        throw new IllegalArgumentException("This ejb has no message destination refernce by the name " + name);
    }

    public Set getJmsDestinationReferenceDescriptors() {
        if (this.jmsDestReferences == null) {
            this.jmsDestReferences = new OrderedSet();
        }
        this.jmsDestReferences = new OrderedSet((Collection)this.jmsDestReferences);
        return this.jmsDestReferences;
    }

    public void addJmsDestinationReferenceDescriptor(JmsDestinationReferenceDescriptor jmsDestReference) {
        this.getJmsDestinationReferenceDescriptors().add(jmsDestReference);
        this.changed();
    }

    public void removeJmsDestinationReferenceDescriptor(JmsDestinationReferenceDescriptor jmsDestReference) {
        this.getJmsDestinationReferenceDescriptors().remove(jmsDestReference);
        this.changed();
    }

    public EjbReferenceDescriptor getEjbReferenceByName(String name) {
        Iterator itr = this.getEjbReferenceDescriptors().iterator();
        while (itr.hasNext()) {
            EjbReferenceDescriptor ejr = (EjbReferenceDescriptor)itr.next();
            if (!ejr.getName().equals(name)) continue;
            return ejr;
        }
        throw new IllegalArgumentException("This application client has no ejb refernce by the name " + name);
    }

    public EjbReference getEjbReference(String name) {
        Iterator itr = this.getEjbReferenceDescriptors().iterator();
        while (itr.hasNext()) {
            EjbReference ejr = (EjbReference)itr.next();
            if (!ejr.getName().equals(name)) continue;
            return ejr;
        }
        throw new IllegalArgumentException("This application client has no ejb refernce by the name " + name);
    }

    public JmsDestinationReferenceDescriptor getJmsDestinationReferenceByName(String name) {
        Iterator itr = this.getJmsDestinationReferenceDescriptors().iterator();
        while (itr.hasNext()) {
            JmsDestinationReferenceDescriptor jdr = (JmsDestinationReferenceDescriptor)itr.next();
            if (!jdr.getName().equals(name)) continue;
            return jdr;
        }
        throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptionappclienthasnojmsdestrefbyname", "This application client has no JMS destination reference by the name of {0}", new Object[]{name}));
    }

    public Set getResourceReferenceDescriptors() {
        if (this.resourceReferences == null) {
            this.resourceReferences = new OrderedSet();
        }
        this.resourceReferences = new OrderedSet((Collection)this.resourceReferences);
        return this.resourceReferences;
    }

    public ResourceReferenceDescriptor getResourceReferenceByName(String name) {
        Iterator itr = this.getResourceReferenceDescriptors().iterator();
        while (itr.hasNext()) {
            ResourceReferenceDescriptor rr = (ResourceReferenceDescriptor)itr.next();
            if (!rr.getName().equals(name)) continue;
            return rr;
        }
        throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptionappclienthasnoejbrefname", "This application client has no ejb refernce by the name {0}", new Object[]{name}));
    }

    public void addResourceReferenceDescriptor(ResourceReferenceDescriptor resourceReference) {
        this.getResourceReferenceDescriptors().add(resourceReference);
        this.changed();
    }

    public void removeResourceReferenceDescriptor(ResourceReferenceDescriptor resourceReference) {
        this.getResourceReferenceDescriptors().remove(resourceReference);
        this.changed();
    }

    public boolean hasWebServiceClients() {
        return !this.getServiceReferenceDescriptors().isEmpty();
    }

    public boolean hasWebServices() {
        return false;
    }

    public void print(StringBuffer toStringBuffer) {
        toStringBuffer.append("Application Client Descriptor");
        toStringBuffer.append("\n ");
        super.print(toStringBuffer);
        toStringBuffer.append("\n environmentProperties ").append(this.environmentProperties);
        toStringBuffer.append("\n ejbReferences ");
        if (this.ejbReferences != null) {
            this.printDescriptorSet(this.ejbReferences, toStringBuffer);
        }
        toStringBuffer.append("\n jmsDestReferences ");
        if (this.jmsDestReferences != null) {
            this.printDescriptorSet(this.jmsDestReferences, toStringBuffer);
        }
        toStringBuffer.append("\n messageDestReferences ");
        if (this.messageDestReferences != null) {
            this.printDescriptorSet(this.messageDestReferences, toStringBuffer);
        }
        toStringBuffer.append("\n resourceReferences ");
        if (this.resourceReferences != null) {
            this.printDescriptorSet(this.resourceReferences, toStringBuffer);
        }
        toStringBuffer.append("\n serviceReferences ");
        if (this.serviceReferences != null) {
            this.printDescriptorSet(this.serviceReferences, toStringBuffer);
        }
        toStringBuffer.append("\n mainClassName ").append(this.mainClassName);
    }

    private void printDescriptorSet(Set descSet, StringBuffer sbuf) {
        Iterator itr = descSet.iterator();
        while (itr.hasNext()) {
            Object obj = itr.next();
            if (obj instanceof Descriptor) {
                ((Descriptor)obj).print(sbuf);
                continue;
            }
            sbuf.append(obj);
        }
    }

    public void visit(DescriptorVisitor aVisitor) {
        if (aVisitor instanceof AppClientVisitor) {
            this.visit((AppClientVisitor)aVisitor);
        } else {
            super.visit(aVisitor);
        }
    }

    public void visit(AppClientVisitor aVisitor) {
        aVisitor.accept(this);
        Set ejbRefs = this.getEjbReferenceDescriptors();
        Iterator itr = ejbRefs.iterator();
        while (itr.hasNext()) {
            aVisitor.accept((EjbReference)itr.next());
        }
        Set msgDestRefs = this.getMessageDestinationReferenceDescriptors();
        Iterator itr2 = msgDestRefs.iterator();
        while (itr2.hasNext()) {
            aVisitor.accept((MessageDestinationReferencer)itr2.next());
        }
        Set serviceRefs = this.getServiceReferenceDescriptors();
        Iterator itr3 = serviceRefs.iterator();
        while (itr3.hasNext()) {
            aVisitor.accept((ServiceReferenceDescriptor)itr3.next());
        }
    }

    public ModuleType getModuleType() {
        return ModuleType.CAR;
    }
}

