/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.work;

import com.sun.corba.ee.spi.orbutil.threadpool.WorkQueue;
import com.sun.enterprise.J2EETransactionManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.connectors.work.OneWork;
import com.sun.enterprise.connectors.work.WorkStats;
import com.sun.enterprise.distributedtx.J2EETransactionManagerOpt;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.spi.work.ExecutionContext;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkCompletedException;
import javax.resource.spi.work.WorkEvent;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.work.WorkListener;
import javax.resource.spi.work.WorkRejectedException;

public class WorkCoordinator {
    static int WAIT_UNTIL_START = 1;
    static int WAIT_UNTIL_FINISH = 2;
    static int NO_WAIT = 3;
    static int CREATED = 1;
    static int STARTED = 2;
    static int COMPLETED = 3;
    static int TIMEDOUT = 4;
    private int waitMode;
    private volatile int state = CREATED;
    private boolean workIsBad = false;
    private Work work;
    private long timeout;
    private long startTime;
    private ExecutionContext ec;
    private WorkQueue queue;
    private WorkListener listener;
    private WorkException exception;
    private Object lock;
    private static int seed;
    private int id;
    private static Logger logger;
    private WorkStats workStats = null;

    public WorkCoordinator(Work work, long timeout, ExecutionContext ec, WorkQueue queue, WorkListener listener, WorkStats workStats) {
        this.work = work;
        this.timeout = timeout;
        this.ec = ec;
        this.queue = queue;
        this.listener = listener;
        this.id = ++seed;
        this.lock = new Object();
        this.workStats = workStats;
    }

    public void submitWork(int waitMode) {
        this.waitMode = waitMode;
        this.startTime = System.currentTimeMillis();
        if (this.listener != null) {
            this.listener.workAccepted(new WorkEvent((Object)this, 1, this.work, null));
        }
        this.queue.addWork(new OneWork(this.work, this));
        if (this.workStats != null) {
            ++this.workStats.submittedWorkCount;
            this.workStats.incrementWaitQueueLength();
        }
    }

    public void preInvoke() {
        if (this.waitMode == NO_WAIT && this.timeout > -1L) {
            long elapsedTime = System.currentTimeMillis() - this.startTime;
            if (this.workStats != null) {
                this.workStats.setWorkWaitTime(elapsedTime);
            }
            if (elapsedTime > this.timeout) {
                this.workTimedOut();
            }
        }
        this.setState(STARTED);
        if (this.waitMode == WAIT_UNTIL_START) {
            this.unLock();
        }
        if (!this.proceed()) {
            if (this.workStats != null) {
                this.workStats.decrementWaitQueueLength();
            }
            return;
        }
        if (this.listener != null) {
            this.listener.workStarted(new WorkEvent((Object)this, 3, this.work, null));
        }
        try {
            J2EETransactionManager tm = Switch.getSwitch().getTransactionManager();
            if (this.ec != null && this.ec.getXid() != null) {
                tm.recreate(this.ec.getXid(), this.ec.getTransactionTimeout());
            }
        }
        catch (WorkException we) {
            this.exception = we;
        }
        catch (Exception e) {
            this.setException(e);
        }
        if (this.workStats != null) {
            this.workStats.setActiveWorkCount(this.workStats.currentActiveWorkCount++);
            this.workStats.decrementWaitQueueLength();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void postInvoke() {
        block19: {
            boolean txImported;
            block18: {
                txImported = this.ec != null && this.ec.getXid() != null;
                J2EETransactionManager tm = Switch.getSwitch().getTransactionManager();
                if (!txImported) break block18;
                tm.release(this.ec.getXid());
            }
            Object var4_4 = null;
            try {
                J2EETransactionManager tm;
                if (this.workStats != null) {
                    this.workStats.setActiveWorkCount(this.workStats.currentActiveWorkCount--);
                    ++this.workStats.completedWorkCount;
                }
                if (this.listener != null && !this.isTimedOut()) {
                    this.listener.workCompleted(new WorkEvent((Object)this, 4, this.work, this.getException()));
                }
                if (txImported && (tm = Switch.getSwitch().getTransactionManager()) instanceof J2EETransactionManagerOpt) {
                    ((J2EETransactionManagerOpt)tm).clearThreadTx();
                }
                break block19;
            }
            catch (Exception e) {
                logger.log(Level.WARNING, e.getMessage());
            }
            break block19;
            {
                catch (WorkException ex) {
                    this.setException(ex);
                    Object var4_5 = null;
                    try {
                        J2EETransactionManager tm;
                        if (this.workStats != null) {
                            this.workStats.setActiveWorkCount(this.workStats.currentActiveWorkCount--);
                            ++this.workStats.completedWorkCount;
                        }
                        if (this.listener != null && !this.isTimedOut()) {
                            this.listener.workCompleted(new WorkEvent((Object)this, 4, this.work, this.getException()));
                        }
                        if (txImported && (tm = Switch.getSwitch().getTransactionManager()) instanceof J2EETransactionManagerOpt) {
                            ((J2EETransactionManagerOpt)tm).clearThreadTx();
                        }
                        break block19;
                    }
                    catch (Exception e) {
                        logger.log(Level.WARNING, e.getMessage());
                    }
                }
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                try {
                    J2EETransactionManager tm;
                    if (this.workStats != null) {
                        this.workStats.setActiveWorkCount(this.workStats.currentActiveWorkCount--);
                        ++this.workStats.completedWorkCount;
                    }
                    if (this.listener != null && !this.isTimedOut()) {
                        this.listener.workCompleted(new WorkEvent((Object)this, 4, this.work, this.getException()));
                    }
                    if (txImported && (tm = Switch.getSwitch().getTransactionManager()) instanceof J2EETransactionManagerOpt) {
                        ((J2EETransactionManagerOpt)tm).clearThreadTx();
                    }
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, e.getMessage());
                }
                throw throwable;
            }
        }
        this.setState(COMPLETED);
        if (this.waitMode == WAIT_UNTIL_FINISH) {
            this.unLock();
        }
    }

    private void workTimedOut() {
        this.setState(TIMEDOUT);
        this.exception = new WorkRejectedException();
        this.exception.setErrorCode("1");
        if (this.listener != null) {
            this.listener.workRejected(new WorkEvent((Object)this, 2, this.work, this.exception));
        }
        if (this.workStats != null) {
            ++this.workStats.rejectedWorkCount;
            this.workStats.setActiveWorkCount(this.workStats.currentActiveWorkCount--);
        }
    }

    public boolean proceed() {
        return !this.isTimedOut() && this.exception == null;
    }

    private boolean isTimedOut() {
        return this.getState() == TIMEDOUT;
    }

    public WorkException getException() {
        return this.exception;
    }

    public void setException(Throwable e) {
        if (this.getState() < STARTED) {
            if (e instanceof WorkRejectedException) {
                this.exception = (WorkException)e;
            } else if (e instanceof WorkException) {
                WorkException we = (WorkException)e;
                this.exception = new WorkRejectedException((Throwable)we);
                this.exception.setErrorCode(we.getErrorCode());
            } else {
                this.exception = new WorkRejectedException(e);
                this.exception.setErrorCode("0");
            }
        } else if (e instanceof WorkCompletedException) {
            this.exception = (WorkException)e;
        } else if (e instanceof WorkException) {
            WorkException we = (WorkException)e;
            this.exception = new WorkCompletedException((Throwable)we);
            this.exception.setErrorCode(we.getErrorCode());
        } else {
            this.exception = new WorkCompletedException(e);
            this.exception.setErrorCode("0");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock() {
        block14: {
            if (!this.lockRequired()) {
                return;
            }
            try {
                Object object = this.lock;
                synchronized (object) {
                    if (this.checkStateBeforeLocking()) {
                        if (this.timeout != -1L) {
                            this.lock.wait(this.timeout);
                        } else {
                            this.lock.wait();
                        }
                    }
                }
                if (this.getState() < STARTED) {
                    this.workTimedOut();
                }
                if (!this.lockRequired()) break block14;
                object = this.lock;
                synchronized (object) {
                    if (this.checkStateBeforeLocking()) {
                        this.lock.wait();
                    }
                }
            }
            catch (Exception e) {
                this.setException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unLock() {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
        }
        catch (Exception e) {
            this.setException(e);
        }
    }

    public String toString() {
        return this.id + ":" + this.work;
    }

    public synchronized void setState(int state) {
        this.state = state;
    }

    public synchronized int getState() {
        return this.state;
    }

    private boolean lockRequired() {
        if (!this.proceed()) {
            return false;
        }
        if (this.waitMode == NO_WAIT) {
            return false;
        }
        if (this.waitMode == WAIT_UNTIL_FINISH) {
            return this.getState() < COMPLETED;
        }
        if (this.waitMode == WAIT_UNTIL_START) {
            return this.getState() < STARTED;
        }
        return false;
    }

    private boolean checkStateBeforeLocking() {
        if (this.waitMode == WAIT_UNTIL_FINISH) {
            return this.state < COMPLETED;
        }
        if (this.waitMode == WAIT_UNTIL_START) {
            return this.state < STARTED;
        }
        return false;
    }

    static {
        logger = LogDomains.getLogger("javax.enterprise.resource.resourceadapter");
    }
}

