/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.util;

import com.sun.enterprise.connectors.ConnectorRuntimeException;
import com.sun.enterprise.connectors.util.ConnectorDDTransformUtils;
import com.sun.enterprise.connectors.util.ConnectorRARClassLoader;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RARUtils {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.resource.resourceadapter");

    public static Map getRABeanProperties(String pathToDeployableUnit) {
        File f = new File(pathToDeployableUnit);
        if (f.isDirectory()) {
            return RARUtils.getRABeanPropertiesForDirectoryBasedDeployment(pathToDeployableUnit);
        }
        return RARUtils.getRABeanPropertiesForRARBasedDeployment(pathToDeployableUnit);
    }

    private static Map getRABeanPropertiesForRARBasedDeployment(String rarLocation) {
        ConnectorRARClassLoader jarCL = new ConnectorRARClassLoader(rarLocation);
        String raClassName = ConnectorDDTransformUtils.getResourceAdapterClassName(rarLocation);
        _logger.finer("RA class :  " + raClassName);
        Map hMap = new HashMap();
        try {
            hMap = RARUtils.extractRABeanProps(raClassName, jarCL);
        }
        catch (ClassNotFoundException e) {
            _logger.info(e.getMessage());
            _logger.log(Level.FINE, "Error while trying to find class " + raClassName + "in RAR at " + rarLocation, e);
        }
        return hMap;
    }

    private static Map getRABeanPropertiesForDirectoryBasedDeployment(String directoryLocation) {
        Map hMap = new HashMap();
        try {
            ConnectorDescriptor cd = ConnectorDDTransformUtils.getConnectorDescriptor(directoryLocation);
            String raClassName = cd.getResourceAdapterClass();
            File f = new File(directoryLocation);
            URLClassLoader ucl = new URLClassLoader(new URL[]{f.toURL()});
            hMap = RARUtils.extractRABeanProps(raClassName, ucl);
        }
        catch (IOException e) {
            _logger.info(e.getMessage());
            _logger.log(Level.FINE, "IO Error while trying to read connectordescriptor to get resource-adapter properties", e);
        }
        catch (ClassNotFoundException e) {
            _logger.info(e.getMessage());
            _logger.log(Level.FINE, "Unable to find class while trying to read connectordescriptor to get resource-adapter properties", e);
        }
        catch (ConnectorRuntimeException e) {
            _logger.info(e.getMessage());
            _logger.log(Level.FINE, "Error while trying to read connectordescriptor to get resource-adapter properties", e);
        }
        catch (Exception e) {
            _logger.info(e.getMessage());
            _logger.log(Level.FINE, "Error while trying to read connectordescriptor to get resource-adapter properties", e);
        }
        return hMap;
    }

    private static Map extractRABeanProps(String raClassName, ClassLoader classLoader) throws ClassNotFoundException {
        Map hMap = new HashMap();
        if (raClassName.trim().length() != 0) {
            Class<?> c = classLoader.loadClass(raClassName);
            if (_logger.isLoggable(Level.FINER)) {
                RARUtils.printClassDetails(c);
            }
            hMap = RARUtils.getJavaBeanProperties(c);
        }
        return hMap;
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("<Usage> java RARUtils directory-path ");
            return;
        }
        Map hMap = RARUtils.getRABeanPropertiesForDirectoryBasedDeployment(args[0]);
        System.out.println("RA JavaBean Properties");
        System.out.println(hMap);
    }

    private static Map getJavaBeanProperties(Class c) {
        Method[] m = c.getMethods();
        HashMap hMap = new HashMap();
        for (int i = 0; i < m.length; ++i) {
            _logger.finer(m[i].getName());
            if (!m[i].getName().startsWith("get") || !RARUtils.isValidRABeanConfigProperty(m[i].getReturnType())) continue;
            hMap.put(m[i].getName().substring(3), m[i].getReturnType());
        }
        hMap.remove("Class");
        return hMap;
    }

    public static boolean isValidRABeanConfigProperty(Class clz) {
        return clz.isPrimitive() || clz.equals(String.class) || RARUtils.isPrimitiveWrapper(clz);
    }

    private static boolean isPrimitiveWrapper(Class clz) {
        return clz.equals(Boolean.class) || clz.equals(Character.class) || clz.equals(Byte.class) || clz.equals(Short.class) || clz.equals(Integer.class) || clz.equals(Long.class) || clz.equals(Float.class) || clz.equals(Double.class);
    }

    private static void printClassDetails(Class c) {
        Method[] m = c.getMethods();
        _logger.finer("Methods in " + c.getName());
        for (int i = 0; i < m.length; ++i) {
            _logger.finer(m[i].toString());
        }
    }
}

