/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.util;

import com.sun.enterprise.connectors.ConnectorConnectionPool;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.connectors.ConnectorRuntimeException;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.runtime.connector.ResourceAdapter;
import com.sun.enterprise.deployment.runtime.connector.SunConnector;
import com.sun.logging.LogDomains;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.spi.ManagedConnectionFactory;

public class ConnectionPoolObjectsUtils {
    private static Logger _logger = LogDomains.getLogger("javax.enterprise.resource.resourceadapter");
    private static final String VALIDATE_ATMOST_EVERY_IDLE_SECS = "com.sun.enterprise.connectors.ValidateAtmostEveryIdleSecs";
    private static String validateAtmostEveryIdleSecsProperty = System.getProperty("com.sun.enterprise.connectors.ValidateAtmostEveryIdleSecs");

    public static ConnectorConnectionPool createDefaultConnectorPoolObject(String poolName, String rarName) {
        ConnectorConnectionPool connectorPoolObj = new ConnectorConnectionPool(poolName);
        connectorPoolObj.setMaxPoolSize("20");
        connectorPoolObj.setSteadyPoolSize("10");
        connectorPoolObj.setMaxWaitTimeInMillis("7889");
        connectorPoolObj.setIdleTimeoutInSeconds("789");
        connectorPoolObj.setPoolResizeQuantity("2");
        connectorPoolObj.setFailAllConnections(false);
        try {
            connectorPoolObj.setTransactionSupport(ConnectionPoolObjectsUtils.getTransactionSupportFromRaXml(rarName));
        }
        catch (Exception ex) {
            _logger.fine("error in setting txSupport");
        }
        return connectorPoolObj;
    }

    public static ConnectorConnectionPool createSunRaConnectorPoolObject(String poolName, ConnectorDescriptor desc, String rarName) {
        ConnectorConnectionPool connectorPoolObj = new ConnectorConnectionPool(poolName);
        SunConnector sundesc = desc.getSunDescriptor();
        ResourceAdapter sunRAXML = sundesc.getResourceAdapter();
        connectorPoolObj.setMaxPoolSize((String)sunRAXML.getValue("MaxPoolSize"));
        connectorPoolObj.setSteadyPoolSize((String)sunRAXML.getValue("SteadyPoolSize"));
        connectorPoolObj.setMaxWaitTimeInMillis((String)sunRAXML.getValue("MaxWaitTimeInMillis"));
        connectorPoolObj.setIdleTimeoutInSeconds((String)sunRAXML.getValue("IdleTimeoutInSeconds"));
        connectorPoolObj.setPoolResizeQuantity("2");
        connectorPoolObj.setFailAllConnections(true);
        try {
            connectorPoolObj.setTransactionSupport(ConnectionPoolObjectsUtils.getTransactionSupportFromRaXml(rarName));
        }
        catch (Exception ex) {
            _logger.fine("error in setting txSupport");
        }
        boolean validateAtmostEveryIdleSecs = false;
        if (validateAtmostEveryIdleSecsProperty != null && validateAtmostEveryIdleSecsProperty.equalsIgnoreCase("TRUE")) {
            validateAtmostEveryIdleSecs = true;
            _logger.log(Level.WARNING, "Validate Atmost Every Idle Secs Set for Pool : " + poolName);
        }
        connectorPoolObj.setValidateAtmostEveryIdleSecs(validateAtmostEveryIdleSecs);
        return connectorPoolObj;
    }

    public static int getTransactionSupportFromRaXml(String rarName) throws ConnectorRuntimeException {
        String txSupport = ConnectorRuntime.getRuntime().getConnectorDescriptor(rarName).getOutboundResourceAdapter().getTransSupport();
        return ConnectionPoolObjectsUtils.parseTransactionSupportString(txSupport);
    }

    public static int parseTransactionSupportString(String txSupport) {
        int txSupportIntVal = -1;
        if (txSupport == null) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("txSupport is null");
            }
            return txSupportIntVal;
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("parseTransactionSupportString: passed in txSupport =>" + txSupport);
        }
        if ("NoTransaction".equals(txSupport)) {
            txSupportIntVal = 0;
        } else if ("LocalTransaction".equals(txSupport)) {
            txSupportIntVal = 1;
        } else if ("XATransaction".equals(txSupport)) {
            txSupportIntVal = 2;
        }
        return txSupportIntVal;
    }

    public static String getValueFromMCF(String prop, String poolName, ManagedConnectionFactory mcf) {
        String result = null;
        try {
            Method m = mcf.getClass().getMethod("get" + prop, null);
            result = (String)m.invoke((Object)mcf, null);
        }
        catch (Throwable t) {
            _logger.log(Level.FINE, t.getMessage(), t);
        }
        return result == null ? "" : result;
    }
}

