/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans;

import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.StaleWriteConfigException;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.config.serverbeans.HttpAccessLog;
import com.sun.enterprise.config.serverbeans.ServerTags;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.Serializable;
import java.util.Vector;
import org.netbeans.modules.schema2beans.BeanComparator;
import org.netbeans.modules.schema2beans.Common;
import org.netbeans.modules.schema2beans.GenBeans;

public class VirtualServer
extends ConfigBean
implements Serializable {
    static Vector comparators = new Vector();
    public static final String HTTP_ACCESS_LOG = "HttpAccessLog";
    public static final String ELEMENT_PROPERTY = "ElementProperty";

    public VirtualServer() {
        this(Common.USE_DEFAULT_VALUES);
    }

    public VirtualServer(int options) {
        super(comparators, new GenBeans.Version(1, 0, 8));
        this.createProperty("http-access-log", HTTP_ACCESS_LOG, 66064, HttpAccessLog.class);
        this.createAttribute(HTTP_ACCESS_LOG, "log-directory", "LogDirectory", 1, null, "${com.sun.aas.instanceRoot}/logs/access");
        this.createAttribute(HTTP_ACCESS_LOG, "iponly", "Iponly", 1, null, "true");
        this.createProperty("property", ELEMENT_PROPERTY, 66096, ElementProperty.class);
        this.createAttribute(ELEMENT_PROPERTY, "name", "Name", 257, null, null);
        this.createAttribute(ELEMENT_PROPERTY, "value", "Value", 257, null, null);
        this.initialize(options);
    }

    void initialize(int options) {
    }

    public void setHttpAccessLog(HttpAccessLog value) {
        this.setValue(HTTP_ACCESS_LOG, value);
    }

    public HttpAccessLog getHttpAccessLog() {
        return (HttpAccessLog)this.getValue(HTTP_ACCESS_LOG);
    }

    public void setElementProperty(int index, ElementProperty value) {
        this.setValue(ELEMENT_PROPERTY, index, value);
    }

    public ElementProperty getElementProperty(int index) {
        return (ElementProperty)this.getValue(ELEMENT_PROPERTY, index);
    }

    public void setElementProperty(ElementProperty[] value) {
        this.setValue(ELEMENT_PROPERTY, value);
    }

    public ElementProperty[] getElementProperty() {
        return (ElementProperty[])this.getValues(ELEMENT_PROPERTY);
    }

    public int sizeElementProperty() {
        return this.size(ELEMENT_PROPERTY);
    }

    public int addElementProperty(ElementProperty value) throws ConfigException {
        return this.addElementProperty(value, true);
    }

    public int addElementProperty(ElementProperty value, boolean overwrite) throws ConfigException {
        ElementProperty old = this.getElementPropertyByName(value.getName());
        if (old != null) {
            throw new ConfigException(StringManager.getManager(VirtualServer.class).getString("cannotAddDuplicate", ELEMENT_PROPERTY));
        }
        return this.addValue(ELEMENT_PROPERTY, value, overwrite);
    }

    public int removeElementProperty(ElementProperty value) {
        return this.removeValue(ELEMENT_PROPERTY, value);
    }

    public int removeElementProperty(ElementProperty value, boolean overwrite) throws StaleWriteConfigException {
        return this.removeValue(ELEMENT_PROPERTY, value, overwrite);
    }

    public ElementProperty getElementPropertyByName(String id) {
        ElementProperty[] o;
        if (null != id) {
            id = id.trim();
        }
        if ((o = this.getElementProperty()) == null) {
            return null;
        }
        for (int i = 0; i < o.length; ++i) {
            if (!o[i].getAttributeValue(Common.convertName((String)ServerTags.NAME)).equals(id)) continue;
            return o[i];
        }
        return null;
    }

    public String getId() {
        return this.getAttributeValue(ServerTags.ID);
    }

    public void setId(String v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.ID, v, overwrite);
    }

    public void setId(String v) {
        this.setAttributeValue(ServerTags.ID, v);
    }

    public String getHttpListeners() {
        return this.getAttributeValue(ServerTags.HTTP_LISTENERS);
    }

    public void setHttpListeners(String v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.HTTP_LISTENERS, v, overwrite);
    }

    public void setHttpListeners(String v) {
        this.setAttributeValue(ServerTags.HTTP_LISTENERS, v);
    }

    public String getDefaultWebModule() {
        return this.getAttributeValue(ServerTags.DEFAULT_WEB_MODULE);
    }

    public void setDefaultWebModule(String v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.DEFAULT_WEB_MODULE, v, overwrite);
    }

    public void setDefaultWebModule(String v) {
        this.setAttributeValue(ServerTags.DEFAULT_WEB_MODULE, v);
    }

    public String getHosts() {
        return this.getAttributeValue(ServerTags.HOSTS);
    }

    public void setHosts(String v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.HOSTS, v, overwrite);
    }

    public void setHosts(String v) {
        this.setAttributeValue(ServerTags.HOSTS, v);
    }

    public String getState() {
        return this.getAttributeValue(ServerTags.STATE);
    }

    public void setState(String v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.STATE, v, overwrite);
    }

    public void setState(String v) {
        this.setAttributeValue(ServerTags.STATE, v);
    }

    public String getDocroot() {
        return this.getAttributeValue(ServerTags.DOCROOT);
    }

    public void setDocroot(String v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.DOCROOT, v, overwrite);
    }

    public void setDocroot(String v) {
        this.setAttributeValue(ServerTags.DOCROOT, v);
    }

    public String getLogFile() {
        return this.getAttributeValue(ServerTags.LOG_FILE);
    }

    public void setLogFile(String v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.LOG_FILE, v, overwrite);
    }

    public void setLogFile(String v) {
        this.setAttributeValue(ServerTags.LOG_FILE, v);
    }

    protected String getRelativeXPath() {
        String ret = null;
        ret = "virtual-server" + (this.canHaveSiblings() ? "[@id='" + this.getAttributeValue("id") + "']" : "");
        return null != ret ? ret.trim() : null;
    }

    public boolean verify() {
        return true;
    }

    public static void addComparator(BeanComparator c) {
        comparators.add(c);
    }

    public static void removeComparator(BeanComparator c) {
        comparators.remove(c);
    }

    public static String getDefaultAttributeValue(String attr) {
        if (attr == null) {
            return null;
        }
        if ((attr = attr.trim()).equals(ServerTags.STATE)) {
            return "on".trim();
        }
        if (attr.equals(ServerTags.LOG_FILE)) {
            return "${com.sun.aas.instanceRoot}/logs/server.log".trim();
        }
        return null;
    }

    public static String getDefaultState() {
        return "on".trim();
    }

    public static String getDefaultLogFile() {
        return "${com.sun.aas.instanceRoot}/logs/server.log".trim();
    }

    public void dump(StringBuffer str, String indent) {
        str.append(indent);
        str.append(HTTP_ACCESS_LOG);
        ConfigBean n = this.getHttpAccessLog();
        if (n != null) {
            n.dump(str, indent + "\t");
        } else {
            str.append(indent + "\tnull");
        }
        this.dumpAttributes(HTTP_ACCESS_LOG, 0, str, indent);
        str.append(indent);
        str.append("ElementProperty[" + this.sizeElementProperty() + "]");
        for (int i = 0; i < this.sizeElementProperty(); ++i) {
            str.append(indent + "\t");
            str.append("#" + i + ":");
            n = this.getElementProperty(i);
            if (n != null) {
                n.dump(str, indent + "\t");
            } else {
                str.append(indent + "\tnull");
            }
            this.dumpAttributes(ELEMENT_PROPERTY, i, str, indent);
        }
    }

    public String dumpBeanNode() {
        StringBuffer str = new StringBuffer();
        str.append("VirtualServer\n");
        this.dump(str, "\n  ");
        return str.toString().trim();
    }
}

