/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans;

import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.StaleWriteConfigException;
import com.sun.enterprise.config.serverbeans.ServerTags;
import com.sun.enterprise.config.serverbeans.ThreadPool;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.Serializable;
import java.util.Vector;
import org.netbeans.modules.schema2beans.BeanComparator;
import org.netbeans.modules.schema2beans.Common;
import org.netbeans.modules.schema2beans.GenBeans;

public class ThreadPools
extends ConfigBean
implements Serializable {
    static Vector comparators = new Vector();
    public static final String THREAD_POOL = "ThreadPool";

    public ThreadPools() {
        this(Common.USE_DEFAULT_VALUES);
    }

    public ThreadPools(int options) {
        super(comparators, new GenBeans.Version(1, 0, 8));
        this.createProperty("thread-pool", THREAD_POOL, 66112, ThreadPool.class);
        this.createAttribute(THREAD_POOL, "thread-pool-id", "ThreadPoolId", 257, null, null);
        this.createAttribute(THREAD_POOL, "min-thread-pool-size", "MinThreadPoolSize", 1, null, "0");
        this.createAttribute(THREAD_POOL, "max-thread-pool-size", "MaxThreadPoolSize", 1, null, "200");
        this.createAttribute(THREAD_POOL, "idle-thread-timeout-in-seconds", "IdleThreadTimeoutInSeconds", 1, null, "120");
        this.createAttribute(THREAD_POOL, "num-work-queues", "NumWorkQueues", 1, null, "1");
        this.initialize(options);
    }

    void initialize(int options) {
    }

    public void setThreadPool(int index, ThreadPool value) {
        this.setValue(THREAD_POOL, index, value);
    }

    public ThreadPool getThreadPool(int index) {
        return (ThreadPool)this.getValue(THREAD_POOL, index);
    }

    public void setThreadPool(ThreadPool[] value) {
        this.setValue(THREAD_POOL, value);
    }

    public ThreadPool[] getThreadPool() {
        return (ThreadPool[])this.getValues(THREAD_POOL);
    }

    public int sizeThreadPool() {
        return this.size(THREAD_POOL);
    }

    public int addThreadPool(ThreadPool value) throws ConfigException {
        return this.addThreadPool(value, true);
    }

    public int addThreadPool(ThreadPool value, boolean overwrite) throws ConfigException {
        ThreadPool old = this.getThreadPoolByThreadPoolId(value.getThreadPoolId());
        if (old != null) {
            throw new ConfigException(StringManager.getManager(ThreadPools.class).getString("cannotAddDuplicate", THREAD_POOL));
        }
        return this.addValue(THREAD_POOL, value, overwrite);
    }

    public int removeThreadPool(ThreadPool value) {
        return this.removeValue(THREAD_POOL, value);
    }

    public int removeThreadPool(ThreadPool value, boolean overwrite) throws StaleWriteConfigException {
        return this.removeValue(THREAD_POOL, value, overwrite);
    }

    public ThreadPool getThreadPoolByThreadPoolId(String id) {
        ThreadPool[] o;
        if (null != id) {
            id = id.trim();
        }
        if ((o = this.getThreadPool()) == null) {
            return null;
        }
        for (int i = 0; i < o.length; ++i) {
            if (!o[i].getAttributeValue(Common.convertName((String)ServerTags.THREAD_POOL_ID)).equals(id)) continue;
            return o[i];
        }
        return null;
    }

    protected String getRelativeXPath() {
        String ret = null;
        ret = "thread-pools";
        return null != ret ? ret.trim() : null;
    }

    public boolean verify() {
        return true;
    }

    public static void addComparator(BeanComparator c) {
        comparators.add(c);
    }

    public static void removeComparator(BeanComparator c) {
        comparators.remove(c);
    }

    public static String getDefaultAttributeValue(String attr) {
        if (attr == null) {
            return null;
        }
        attr = attr.trim();
        return null;
    }

    public void dump(StringBuffer str, String indent) {
        str.append(indent);
        str.append("ThreadPool[" + this.sizeThreadPool() + "]");
        for (int i = 0; i < this.sizeThreadPool(); ++i) {
            str.append(indent + "\t");
            str.append("#" + i + ":");
            ThreadPool n = this.getThreadPool(i);
            if (n != null) {
                n.dump(str, indent + "\t");
            } else {
                str.append(indent + "\tnull");
            }
            this.dumpAttributes(THREAD_POOL, i, str, indent);
        }
    }

    public String dumpBeanNode() {
        StringBuffer str = new StringBuffer();
        str.append("ThreadPools\n");
        this.dump(str, "\n  ");
        return str.toString().trim();
    }
}

