/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans;

import com.sun.enterprise.config.serverbeans.ServerTags;
import com.sun.enterprise.config.util.ConfigXPathHelper;

public final class ServerXPathHelper {
    public static final String DEFAULT_CONFIG_MODEL_NAME = "server-config";
    public static final String REGEX_DEFAULT_CONFIG_MODEL_NAME = "server\\-config";
    public static final String DEFAULT_HOST_MODEL_NAME = "host1";
    public static final String REGEX_ONE_PLUS = "{1,}";
    public static final String XPATH_SEPARATOR = "/";
    public static final String XPATH_DOMAIN = "/" + ServerTags.DOMAIN;
    public static final String REGEX_XPATH_DOMAIN = "/{1,}" + ServerTags.DOMAIN;
    public static final String XPATH_CONFIG = XPATH_DOMAIN + "/" + ServerTags.CONFIGS + "/" + ServerTags.CONFIG + "[@" + ServerTags.NAME + "='" + "server-config" + "']";
    public static final String REGEX_XPATH_CONFIG = REGEX_XPATH_DOMAIN + "/" + "{1,}" + ServerTags.CONFIGS + "/" + "{1,}" + ServerTags.CONFIG + "[@" + ServerTags.NAME + "='" + "server\\-config" + "']";
    public static final String XPATH_APPLICATIONS = XPATH_DOMAIN + "/" + ServerTags.APPLICATIONS;
    public static final String XPATH_J2EE_APPLICATION = XPATH_APPLICATIONS + "/" + ServerTags.J2EE_APPLICATION;
    public static final String XPATH_EJB_MODULE = XPATH_APPLICATIONS + "/" + ServerTags.EJB_MODULE;
    public static final String XPATH_WEB_MODULE = XPATH_APPLICATIONS + "/" + ServerTags.WEB_MODULE;
    public static final String XPATH_CONNECTOR_MODULE = XPATH_APPLICATIONS + "/" + ServerTags.CONNECTOR_MODULE;
    public static final String XPATH_APPCLIENT_MODULE = XPATH_APPLICATIONS + "/" + ServerTags.APPCLIENT_MODULE;
    public static final String XPATH_LIFECYCLE_MODULE = XPATH_APPLICATIONS + "/" + ServerTags.LIFECYCLE_MODULE;
    public static final String XPATH_LOG_SERVICE = XPATH_CONFIG + "/" + ServerTags.LOG_SERVICE;
    public static final String XPATH_SECURITY_SERVICE = XPATH_CONFIG + "/" + ServerTags.SECURITY_SERVICE;
    public static final String XPATH_SECURITY_AUTH_REALM = XPATH_SECURITY_SERVICE + "/" + ServerTags.AUTH_REALM;
    public static final String XPATH_RESOURCES = XPATH_DOMAIN + "/" + ServerTags.RESOURCES;
    public static final String XPATH_JDBC_RESOURCE = XPATH_RESOURCES + "/" + ServerTags.JDBC_RESOURCE;
    public static final String XPATH_JNDI_RESOURCE = XPATH_RESOURCES + "/" + ServerTags.EXTERNAL_JNDI_RESOURCE;
    public static final String XPATH_CUSTOM_RESOURCE = XPATH_RESOURCES + "/" + ServerTags.CUSTOM_RESOURCE;
    public static final String XPATH_JDBC_CONNECTION_POOL = XPATH_RESOURCES + "/" + ServerTags.JDBC_CONNECTION_POOL;
    public static final String XPATH_PM_FACTORY_RESOURCE = XPATH_RESOURCES + "/" + ServerTags.PERSISTENCE_MANAGER_FACTORY_RESOURCE;
    public static final String XPATH_MAIL_RESOURCE = XPATH_RESOURCES + "/" + ServerTags.MAIL_RESOURCE;
    public static final String XPATH_ADMIN_OBJECT_RESOURCE = XPATH_RESOURCES + "/" + ServerTags.ADMIN_OBJECT_RESOURCE;
    public static final String XPATH_CONNECTOR_RESOURCE = XPATH_RESOURCES + "/" + ServerTags.CONNECTOR_RESOURCE;
    public static final String XPATH_CONNECTOR_CONNECTION_POOL = XPATH_RESOURCES + "/" + ServerTags.CONNECTOR_CONNECTION_POOL;
    public static final String XPATH_RESOURCE_ADAPTER_CONFIG = XPATH_RESOURCES + "/" + ServerTags.RESOURCE_ADAPTER_CONFIG;
    public static final String XPATH_HTTP_SERVICE = XPATH_CONFIG + "/" + ServerTags.HTTP_SERVICE;
    public static final String XPATH_HTTP_LISTENER = XPATH_HTTP_SERVICE + "/" + ServerTags.HTTP_LISTENER;
    public static final String XPATH_TRANSACTION_SERVICE = XPATH_CONFIG + "/" + ServerTags.TRANSACTION_SERVICE;
    public static final String XPATH_JMS_SERVICE = XPATH_CONFIG + "/" + ServerTags.JMS_SERVICE;
    public static final String XPATH_IIOP_SERVICE = XPATH_CONFIG + "/" + ServerTags.IIOP_SERVICE;
    public static final String XPATH_ORB = XPATH_IIOP_SERVICE + "/" + ServerTags.ORB;
    public static final String XPATH_IIOP_LISTENER = XPATH_IIOP_SERVICE + "/" + ServerTags.IIOP_LISTENER;
    public static final String XPATH_MDB_CONTAINER = XPATH_CONFIG + "/" + ServerTags.MDB_CONTAINER;
    public static final String XPATH_WEB_CONTAINER = XPATH_CONFIG + "/" + ServerTags.WEB_CONTAINER;
    public static final String XPATH_EJB_CONTAINER = XPATH_CONFIG + "/" + ServerTags.EJB_CONTAINER;
    public static final String XPATH_JAVACONFIG = XPATH_CONFIG + "/" + ServerTags.JAVA_CONFIG;
    public static final String XPATH_PROFILER = XPATH_JAVACONFIG + "/" + ServerTags.PROFILER;

    public static String getServerIdXpath(String serverId) {
        return XPATH_DOMAIN + XPATH_SEPARATOR + ServerTags.SERVERS + XPATH_SEPARATOR + ServerTags.SERVER + "[@" + ServerTags.NAME + "='" + serverId + "']";
    }

    public static String getConfigIdXpath(String configId) {
        return XPATH_DOMAIN + XPATH_SEPARATOR + ServerTags.CONFIGS + XPATH_SEPARATOR + ServerTags.CONFIG + "[@" + ServerTags.NAME + "='" + configId + "']";
    }

    public static String getAppIdXpathExpression(String appId) {
        return XPATH_J2EE_APPLICATION + "[@" + ServerTags.NAME + "='" + appId + "']";
    }

    public static String getEjbModuleIdXpathExpression(String moduleId) {
        return ServerXPathHelper.getAbsoluteIdXpathExpression(XPATH_EJB_MODULE, ServerTags.NAME, moduleId);
    }

    public static String getWebModuleIdXpathExpression(String moduleId) {
        return ServerXPathHelper.getAbsoluteIdXpathExpression(XPATH_WEB_MODULE, ServerTags.NAME, moduleId);
    }

    public static String getConnectorModuleIdXpathExpression(String moduleId) {
        return XPATH_CONNECTOR_MODULE + "[@" + ServerTags.NAME + "='" + moduleId + "']";
    }

    public static String getAppClientModuleIdXpathExpression(String moduleId) {
        return ServerXPathHelper.getAbsoluteIdXpathExpression(XPATH_APPCLIENT_MODULE, ServerTags.NAME, moduleId);
    }

    public static String getLifecycleModuleIdXpath(String moduleId) {
        return ServerXPathHelper.getAbsoluteIdXpathExpression(XPATH_LIFECYCLE_MODULE, ServerTags.NAME, moduleId);
    }

    public static String getJDBCResourceIdXpath(String jndiId) {
        return ServerXPathHelper.getAbsoluteIdXpathExpression(XPATH_JDBC_RESOURCE, ServerTags.JNDI_NAME, jndiId);
    }

    public static String getJNDIResourceIdXpath(String jndiId) {
        return ServerXPathHelper.getAbsoluteIdXpathExpression(XPATH_JNDI_RESOURCE, ServerTags.JNDI_NAME, jndiId);
    }

    public static String getMailResourceIdXpath(String jndiId) {
        return ServerXPathHelper.getAbsoluteIdXpathExpression(XPATH_MAIL_RESOURCE, ServerTags.JNDI_NAME, jndiId);
    }

    public static String getCustomResourceIdXpath(String jndiId) {
        return ServerXPathHelper.getAbsoluteIdXpathExpression(XPATH_CUSTOM_RESOURCE, ServerTags.JNDI_NAME, jndiId);
    }

    public static String getJDBCConnectionPoolIdXpath(String poolId) {
        return ServerXPathHelper.getAbsoluteIdXpathExpression(XPATH_JDBC_CONNECTION_POOL, ServerTags.NAME, poolId);
    }

    public static String getPMFactoryResourceIdXpath(String jndiId) {
        return ServerXPathHelper.getAbsoluteIdXpathExpression(XPATH_PM_FACTORY_RESOURCE, ServerTags.JNDI_NAME, jndiId);
    }

    public static String getMDBContainerXpath() {
        return XPATH_MDB_CONTAINER;
    }

    public static String getWEBContainerXpath() {
        return XPATH_WEB_CONTAINER;
    }

    public static String getEJBContainerXpath() {
        return XPATH_EJB_CONTAINER;
    }

    public static String getTransactionServiceXpath() {
        return XPATH_TRANSACTION_SERVICE;
    }

    public static String getJmsServiceXpath() {
        return XPATH_JMS_SERVICE;
    }

    public static String getHTTPServiceXpath() {
        return XPATH_HTTP_SERVICE;
    }

    public static String getHTTPListenerIdXpath(String id) {
        return ServerXPathHelper.getAbsoluteIdXpathExpression(XPATH_HTTP_LISTENER, ServerTags.ID, id);
    }

    public static String getVirtualServerIdXpath(String classId, String id) {
        return ServerXPathHelper.getAbsoluteIdXpathExpression(XPATH_HTTP_SERVICE + XPATH_SEPARATOR + ServerTags.VIRTUAL_SERVER, ServerTags.ID, id);
    }

    public static String getIIOPServiceXpath() {
        return XPATH_IIOP_SERVICE;
    }

    public static String getOrbXpath() {
        return XPATH_ORB;
    }

    public static String getIIOPListenerIdXpath(String id) {
        return ServerXPathHelper.getAbsoluteIdXpathExpression(XPATH_IIOP_LISTENER, ServerTags.ID, id);
    }

    public static String getLogServiceXpath() {
        return XPATH_LOG_SERVICE;
    }

    public static String getSecurityServiceXpath() {
        return XPATH_SECURITY_SERVICE;
    }

    public static String getSecurityAuthRealmIdXpath(String name) {
        return ServerXPathHelper.getAbsoluteIdXpathExpression(XPATH_SECURITY_AUTH_REALM, ServerTags.NAME, name);
    }

    public static String getJavaConfigXpath() {
        return XPATH_JAVACONFIG;
    }

    public static String getProfilerXpath() {
        return XPATH_PROFILER;
    }

    public static String getAbsoluteIdXpathExpression(String childTagName, String nameId, String valueId) {
        return ConfigXPathHelper.getAbsoluteIdXpathExpression(childTagName, nameId, valueId);
    }

    public static String getLastNodeName(String xPath) {
        return ConfigXPathHelper.getLastNodeName(xPath);
    }

    public static String getParentXPath(String xPath) {
        return ConfigXPathHelper.getParentXPath(xPath);
    }
}

