/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans;

import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.StaleWriteConfigException;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.config.serverbeans.ServerTags;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.Serializable;
import java.util.Vector;
import org.netbeans.modules.schema2beans.BeanComparator;
import org.netbeans.modules.schema2beans.Common;
import org.netbeans.modules.schema2beans.GenBeans;

public class JdbcConnectionPool
extends ConfigBean
implements Serializable {
    static Vector comparators = new Vector();
    public static final String DESCRIPTION = "Description";
    public static final String ELEMENT_PROPERTY = "ElementProperty";

    public JdbcConnectionPool() {
        this(Common.USE_DEFAULT_VALUES);
    }

    public JdbcConnectionPool(int options) {
        super(comparators, new GenBeans.Version(1, 0, 8));
        this.createProperty("description", DESCRIPTION, 65808, String.class);
        this.createProperty("property", ELEMENT_PROPERTY, 66096, ElementProperty.class);
        this.createAttribute(ELEMENT_PROPERTY, "name", "Name", 257, null, null);
        this.createAttribute(ELEMENT_PROPERTY, "value", "Value", 257, null, null);
        this.initialize(options);
    }

    void initialize(int options) {
    }

    public String getDescription() {
        return (String)this.getValue(ServerTags.DESCRIPTION);
    }

    public void setDescription(String v) {
        this.setValue(ServerTags.DESCRIPTION, null != v ? v.trim() : null);
    }

    public void setElementProperty(int index, ElementProperty value) {
        this.setValue(ELEMENT_PROPERTY, index, value);
    }

    public ElementProperty getElementProperty(int index) {
        return (ElementProperty)this.getValue(ELEMENT_PROPERTY, index);
    }

    public void setElementProperty(ElementProperty[] value) {
        this.setValue(ELEMENT_PROPERTY, value);
    }

    public ElementProperty[] getElementProperty() {
        return (ElementProperty[])this.getValues(ELEMENT_PROPERTY);
    }

    public int sizeElementProperty() {
        return this.size(ELEMENT_PROPERTY);
    }

    public int addElementProperty(ElementProperty value) throws ConfigException {
        return this.addElementProperty(value, true);
    }

    public int addElementProperty(ElementProperty value, boolean overwrite) throws ConfigException {
        ElementProperty old = this.getElementPropertyByName(value.getName());
        if (old != null) {
            throw new ConfigException(StringManager.getManager(JdbcConnectionPool.class).getString("cannotAddDuplicate", ELEMENT_PROPERTY));
        }
        return this.addValue(ELEMENT_PROPERTY, value, overwrite);
    }

    public int removeElementProperty(ElementProperty value) {
        return this.removeValue(ELEMENT_PROPERTY, value);
    }

    public int removeElementProperty(ElementProperty value, boolean overwrite) throws StaleWriteConfigException {
        return this.removeValue(ELEMENT_PROPERTY, value, overwrite);
    }

    public ElementProperty getElementPropertyByName(String id) {
        ElementProperty[] o;
        if (null != id) {
            id = id.trim();
        }
        if ((o = this.getElementProperty()) == null) {
            return null;
        }
        for (int i = 0; i < o.length; ++i) {
            if (!o[i].getAttributeValue(Common.convertName((String)ServerTags.NAME)).equals(id)) continue;
            return o[i];
        }
        return null;
    }

    public String getName() {
        return this.getAttributeValue(ServerTags.NAME);
    }

    public void setName(String v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.NAME, v, overwrite);
    }

    public void setName(String v) {
        this.setAttributeValue(ServerTags.NAME, v);
    }

    public String getDatasourceClassname() {
        return this.getAttributeValue(ServerTags.DATASOURCE_CLASSNAME);
    }

    public void setDatasourceClassname(String v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.DATASOURCE_CLASSNAME, v, overwrite);
    }

    public void setDatasourceClassname(String v) {
        this.setAttributeValue(ServerTags.DATASOURCE_CLASSNAME, v);
    }

    public String getResType() {
        return this.getAttributeValue(ServerTags.RES_TYPE);
    }

    public void setResType(String v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.RES_TYPE, v, overwrite);
    }

    public void setResType(String v) {
        this.setAttributeValue(ServerTags.RES_TYPE, v);
    }

    public String getSteadyPoolSize() {
        return this.getAttributeValue(ServerTags.STEADY_POOL_SIZE);
    }

    public void setSteadyPoolSize(String v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.STEADY_POOL_SIZE, v, overwrite);
    }

    public void setSteadyPoolSize(String v) {
        this.setAttributeValue(ServerTags.STEADY_POOL_SIZE, v);
    }

    public String getMaxPoolSize() {
        return this.getAttributeValue(ServerTags.MAX_POOL_SIZE);
    }

    public void setMaxPoolSize(String v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.MAX_POOL_SIZE, v, overwrite);
    }

    public void setMaxPoolSize(String v) {
        this.setAttributeValue(ServerTags.MAX_POOL_SIZE, v);
    }

    public String getMaxWaitTimeInMillis() {
        return this.getAttributeValue(ServerTags.MAX_WAIT_TIME_IN_MILLIS);
    }

    public void setMaxWaitTimeInMillis(String v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.MAX_WAIT_TIME_IN_MILLIS, v, overwrite);
    }

    public void setMaxWaitTimeInMillis(String v) {
        this.setAttributeValue(ServerTags.MAX_WAIT_TIME_IN_MILLIS, v);
    }

    public String getPoolResizeQuantity() {
        return this.getAttributeValue(ServerTags.POOL_RESIZE_QUANTITY);
    }

    public void setPoolResizeQuantity(String v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.POOL_RESIZE_QUANTITY, v, overwrite);
    }

    public void setPoolResizeQuantity(String v) {
        this.setAttributeValue(ServerTags.POOL_RESIZE_QUANTITY, v);
    }

    public String getIdleTimeoutInSeconds() {
        return this.getAttributeValue(ServerTags.IDLE_TIMEOUT_IN_SECONDS);
    }

    public void setIdleTimeoutInSeconds(String v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.IDLE_TIMEOUT_IN_SECONDS, v, overwrite);
    }

    public void setIdleTimeoutInSeconds(String v) {
        this.setAttributeValue(ServerTags.IDLE_TIMEOUT_IN_SECONDS, v);
    }

    public String getTransactionIsolationLevel() {
        return this.getAttributeValue(ServerTags.TRANSACTION_ISOLATION_LEVEL);
    }

    public void setTransactionIsolationLevel(String v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.TRANSACTION_ISOLATION_LEVEL, v, overwrite);
    }

    public void setTransactionIsolationLevel(String v) {
        this.setAttributeValue(ServerTags.TRANSACTION_ISOLATION_LEVEL, v);
    }

    public boolean isIsIsolationLevelGuaranteed() {
        return JdbcConnectionPool.toBoolean(this.getAttributeValue(ServerTags.IS_ISOLATION_LEVEL_GUARANTEED));
    }

    public void setIsIsolationLevelGuaranteed(boolean v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.IS_ISOLATION_LEVEL_GUARANTEED, "" + v, overwrite);
    }

    public void setIsIsolationLevelGuaranteed(boolean v) {
        this.setAttributeValue(ServerTags.IS_ISOLATION_LEVEL_GUARANTEED, "" + v);
    }

    public boolean isIsConnectionValidationRequired() {
        return JdbcConnectionPool.toBoolean(this.getAttributeValue(ServerTags.IS_CONNECTION_VALIDATION_REQUIRED));
    }

    public void setIsConnectionValidationRequired(boolean v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.IS_CONNECTION_VALIDATION_REQUIRED, "" + v, overwrite);
    }

    public void setIsConnectionValidationRequired(boolean v) {
        this.setAttributeValue(ServerTags.IS_CONNECTION_VALIDATION_REQUIRED, "" + v);
    }

    public String getConnectionValidationMethod() {
        return this.getAttributeValue(ServerTags.CONNECTION_VALIDATION_METHOD);
    }

    public void setConnectionValidationMethod(String v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.CONNECTION_VALIDATION_METHOD, v, overwrite);
    }

    public void setConnectionValidationMethod(String v) {
        this.setAttributeValue(ServerTags.CONNECTION_VALIDATION_METHOD, v);
    }

    public String getValidationTableName() {
        return this.getAttributeValue(ServerTags.VALIDATION_TABLE_NAME);
    }

    public void setValidationTableName(String v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.VALIDATION_TABLE_NAME, v, overwrite);
    }

    public void setValidationTableName(String v) {
        this.setAttributeValue(ServerTags.VALIDATION_TABLE_NAME, v);
    }

    public boolean isFailAllConnections() {
        return JdbcConnectionPool.toBoolean(this.getAttributeValue(ServerTags.FAIL_ALL_CONNECTIONS));
    }

    public void setFailAllConnections(boolean v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.FAIL_ALL_CONNECTIONS, "" + v, overwrite);
    }

    public void setFailAllConnections(boolean v) {
        this.setAttributeValue(ServerTags.FAIL_ALL_CONNECTIONS, "" + v);
    }

    protected String getRelativeXPath() {
        String ret = null;
        ret = "jdbc-connection-pool" + (this.canHaveSiblings() ? "[@name='" + this.getAttributeValue("name") + "']" : "");
        return null != ret ? ret.trim() : null;
    }

    public boolean verify() {
        return true;
    }

    public static void addComparator(BeanComparator c) {
        comparators.add(c);
    }

    public static void removeComparator(BeanComparator c) {
        comparators.remove(c);
    }

    public static String getDefaultAttributeValue(String attr) {
        if (attr == null) {
            return null;
        }
        if ((attr = attr.trim()).equals(ServerTags.STEADY_POOL_SIZE)) {
            return "8".trim();
        }
        if (attr.equals(ServerTags.MAX_POOL_SIZE)) {
            return "32".trim();
        }
        if (attr.equals(ServerTags.MAX_WAIT_TIME_IN_MILLIS)) {
            return "60000".trim();
        }
        if (attr.equals(ServerTags.POOL_RESIZE_QUANTITY)) {
            return "2".trim();
        }
        if (attr.equals(ServerTags.IDLE_TIMEOUT_IN_SECONDS)) {
            return "300".trim();
        }
        if (attr.equals(ServerTags.IS_ISOLATION_LEVEL_GUARANTEED)) {
            return "true".trim();
        }
        if (attr.equals(ServerTags.IS_CONNECTION_VALIDATION_REQUIRED)) {
            return "false".trim();
        }
        if (attr.equals(ServerTags.CONNECTION_VALIDATION_METHOD)) {
            return "auto-commit".trim();
        }
        if (attr.equals(ServerTags.FAIL_ALL_CONNECTIONS)) {
            return "false".trim();
        }
        return null;
    }

    public static String getDefaultSteadyPoolSize() {
        return "8".trim();
    }

    public static String getDefaultMaxPoolSize() {
        return "32".trim();
    }

    public static String getDefaultMaxWaitTimeInMillis() {
        return "60000".trim();
    }

    public static String getDefaultPoolResizeQuantity() {
        return "2".trim();
    }

    public static String getDefaultIdleTimeoutInSeconds() {
        return "300".trim();
    }

    public static String getDefaultIsIsolationLevelGuaranteed() {
        return "true".trim();
    }

    public static String getDefaultIsConnectionValidationRequired() {
        return "false".trim();
    }

    public static String getDefaultConnectionValidationMethod() {
        return "auto-commit".trim();
    }

    public static String getDefaultFailAllConnections() {
        return "false".trim();
    }

    public void dump(StringBuffer str, String indent) {
        str.append(indent);
        str.append("ElementProperty[" + this.sizeElementProperty() + "]");
        for (int i = 0; i < this.sizeElementProperty(); ++i) {
            str.append(indent + "\t");
            str.append("#" + i + ":");
            ElementProperty n = this.getElementProperty(i);
            if (n != null) {
                n.dump(str, indent + "\t");
            } else {
                str.append(indent + "\tnull");
            }
            this.dumpAttributes(ELEMENT_PROPERTY, i, str, indent);
        }
    }

    public String dumpBeanNode() {
        StringBuffer str = new StringBuffer();
        str.append("JdbcConnectionPool\n");
        this.dump(str, "\n  ");
        return str.toString().trim();
    }
}

