/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans;

import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.StaleWriteConfigException;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Clusters;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.config.serverbeans.LbConfigs;
import com.sun.enterprise.config.serverbeans.NodeAgents;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.ServerTags;
import com.sun.enterprise.config.serverbeans.Servers;
import com.sun.enterprise.config.serverbeans.SystemProperty;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Vector;
import org.netbeans.modules.schema2beans.BaseBean;
import org.netbeans.modules.schema2beans.BeanComparator;
import org.netbeans.modules.schema2beans.Common;
import org.netbeans.modules.schema2beans.GenBeans;
import org.netbeans.modules.schema2beans.GraphManager;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class Domain
extends ConfigBean
implements Serializable {
    static Vector comparators = new Vector();
    private static final long serialVersionUID = 1L;
    public static final String APPLICATIONS = "Applications";
    public static final String RESOURCES = "Resources";
    public static final String CONFIGS = "Configs";
    public static final String SERVERS = "Servers";
    public static final String CLUSTERS = "Clusters";
    public static final String NODE_AGENTS = "NodeAgents";
    public static final String LB_CONFIGS = "LbConfigs";
    public static final String SYSTEM_PROPERTY = "SystemProperty";
    public static final String ELEMENT_PROPERTY = "ElementProperty";

    public Domain() {
        this(null, Common.USE_DEFAULT_VALUES);
    }

    public Domain(Node doc, int options) {
        this(Common.NO_DEFAULT_VALUES);
        this.initFromNode(doc, options);
    }

    protected void initFromNode(Node doc, int options) {
        if (doc == null && (doc = GraphManager.createRootElementNode((String)"domain")) == null) {
            throw new RuntimeException(Common.getMessage((String)"CantCreateDOMRoot_msg", (Object)"domain"));
        }
        Node n = GraphManager.getElementNode((String)"domain", (Node)doc);
        if (n == null) {
            throw new RuntimeException(Common.getMessage((String)"DocRootNotInDOMGraph_msg", (Object)"domain", (Object)doc.getFirstChild().getNodeName()));
        }
        this.graphManager.setXmlDocument(doc);
        this.createBean(n, this.graphManager());
        this.initialize(options);
    }

    public Domain(int options) {
        super(comparators, new GenBeans.Version(1, 0, 8));
        this.initOptions(options);
    }

    protected void initOptions(int options) {
        this.graphManager = new GraphManager((BaseBean)this);
        this.createRoot("domain", "Domain", 544, Domain.class);
        this.createProperty("applications", APPLICATIONS, 66064, Applications.class);
        this.createProperty("resources", RESOURCES, 66064, Resources.class);
        this.createProperty("configs", CONFIGS, 66080, Configs.class);
        this.createProperty("servers", SERVERS, 66080, Servers.class);
        this.createProperty("clusters", CLUSTERS, 66064, Clusters.class);
        this.createProperty("node-agents", NODE_AGENTS, 66064, NodeAgents.class);
        this.createProperty("lb-configs", LB_CONFIGS, 66064, LbConfigs.class);
        this.createProperty("system-property", SYSTEM_PROPERTY, 66096, SystemProperty.class);
        this.createAttribute(SYSTEM_PROPERTY, "name", "Name", 257, null, null);
        this.createAttribute(SYSTEM_PROPERTY, "value", "Value", 257, null, null);
        this.createProperty("property", ELEMENT_PROPERTY, 66096, ElementProperty.class);
        this.createAttribute(ELEMENT_PROPERTY, "name", "Name", 257, null, null);
        this.createAttribute(ELEMENT_PROPERTY, "value", "Value", 257, null, null);
        this.createAttribute("application-root", "ApplicationRoot", 513, null, null);
        this.createAttribute("log-root", "LogRoot", 513, null, null);
        this.createAttribute("locale", "Locale", 513, null, null);
        this.initialize(options);
    }

    void initialize(int options) {
    }

    public void setApplications(Applications value) {
        this.setValue(APPLICATIONS, value);
    }

    public Applications getApplications() {
        return (Applications)this.getValue(APPLICATIONS);
    }

    public void setResources(Resources value) {
        this.setValue(RESOURCES, value);
    }

    public Resources getResources() {
        return (Resources)this.getValue(RESOURCES);
    }

    public void setConfigs(Configs value) {
        this.setValue(CONFIGS, value);
    }

    public Configs getConfigs() {
        return (Configs)this.getValue(CONFIGS);
    }

    public void setServers(Servers value) {
        this.setValue(SERVERS, value);
    }

    public Servers getServers() {
        return (Servers)this.getValue(SERVERS);
    }

    public void setClusters(Clusters value) {
        this.setValue(CLUSTERS, value);
    }

    public Clusters getClusters() {
        return (Clusters)this.getValue(CLUSTERS);
    }

    public void setNodeAgents(NodeAgents value) {
        this.setValue(NODE_AGENTS, value);
    }

    public NodeAgents getNodeAgents() {
        return (NodeAgents)this.getValue(NODE_AGENTS);
    }

    public void setLbConfigs(LbConfigs value) {
        this.setValue(LB_CONFIGS, value);
    }

    public LbConfigs getLbConfigs() {
        return (LbConfigs)this.getValue(LB_CONFIGS);
    }

    public void setSystemProperty(int index, SystemProperty value) {
        this.setValue(SYSTEM_PROPERTY, index, value);
    }

    public SystemProperty getSystemProperty(int index) {
        return (SystemProperty)this.getValue(SYSTEM_PROPERTY, index);
    }

    public void setSystemProperty(SystemProperty[] value) {
        this.setValue(SYSTEM_PROPERTY, value);
    }

    public SystemProperty[] getSystemProperty() {
        return (SystemProperty[])this.getValues(SYSTEM_PROPERTY);
    }

    public int sizeSystemProperty() {
        return this.size(SYSTEM_PROPERTY);
    }

    public int addSystemProperty(SystemProperty value) throws ConfigException {
        return this.addSystemProperty(value, true);
    }

    public int addSystemProperty(SystemProperty value, boolean overwrite) throws ConfigException {
        SystemProperty old = this.getSystemPropertyByName(value.getName());
        if (old != null) {
            throw new ConfigException(StringManager.getManager(Domain.class).getString("cannotAddDuplicate", SYSTEM_PROPERTY));
        }
        return this.addValue(SYSTEM_PROPERTY, value, overwrite);
    }

    public int removeSystemProperty(SystemProperty value) {
        return this.removeValue(SYSTEM_PROPERTY, value);
    }

    public int removeSystemProperty(SystemProperty value, boolean overwrite) throws StaleWriteConfigException {
        return this.removeValue(SYSTEM_PROPERTY, value, overwrite);
    }

    public SystemProperty getSystemPropertyByName(String id) {
        SystemProperty[] o;
        if (null != id) {
            id = id.trim();
        }
        if ((o = this.getSystemProperty()) == null) {
            return null;
        }
        for (int i = 0; i < o.length; ++i) {
            if (!o[i].getAttributeValue(Common.convertName((String)ServerTags.NAME)).equals(id)) continue;
            return o[i];
        }
        return null;
    }

    public void setElementProperty(int index, ElementProperty value) {
        this.setValue(ELEMENT_PROPERTY, index, value);
    }

    public ElementProperty getElementProperty(int index) {
        return (ElementProperty)this.getValue(ELEMENT_PROPERTY, index);
    }

    public void setElementProperty(ElementProperty[] value) {
        this.setValue(ELEMENT_PROPERTY, value);
    }

    public ElementProperty[] getElementProperty() {
        return (ElementProperty[])this.getValues(ELEMENT_PROPERTY);
    }

    public int sizeElementProperty() {
        return this.size(ELEMENT_PROPERTY);
    }

    public int addElementProperty(ElementProperty value) throws ConfigException {
        return this.addElementProperty(value, true);
    }

    public int addElementProperty(ElementProperty value, boolean overwrite) throws ConfigException {
        ElementProperty old = this.getElementPropertyByName(value.getName());
        if (old != null) {
            throw new ConfigException(StringManager.getManager(Domain.class).getString("cannotAddDuplicate", ELEMENT_PROPERTY));
        }
        return this.addValue(ELEMENT_PROPERTY, value, overwrite);
    }

    public int removeElementProperty(ElementProperty value) {
        return this.removeValue(ELEMENT_PROPERTY, value);
    }

    public int removeElementProperty(ElementProperty value, boolean overwrite) throws StaleWriteConfigException {
        return this.removeValue(ELEMENT_PROPERTY, value, overwrite);
    }

    public ElementProperty getElementPropertyByName(String id) {
        ElementProperty[] o;
        if (null != id) {
            id = id.trim();
        }
        if ((o = this.getElementProperty()) == null) {
            return null;
        }
        for (int i = 0; i < o.length; ++i) {
            if (!o[i].getAttributeValue(Common.convertName((String)ServerTags.NAME)).equals(id)) continue;
            return o[i];
        }
        return null;
    }

    public String getApplicationRoot() {
        return this.getAttributeValue(ServerTags.APPLICATION_ROOT);
    }

    public void setApplicationRoot(String v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.APPLICATION_ROOT, v, overwrite);
    }

    public void setApplicationRoot(String v) {
        this.setAttributeValue(ServerTags.APPLICATION_ROOT, v);
    }

    public String getLogRoot() {
        return this.getAttributeValue(ServerTags.LOG_ROOT);
    }

    public void setLogRoot(String v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.LOG_ROOT, v, overwrite);
    }

    public void setLogRoot(String v) {
        this.setAttributeValue(ServerTags.LOG_ROOT, v);
    }

    public String getLocale() {
        return this.getAttributeValue(ServerTags.LOCALE);
    }

    public void setLocale(String v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.LOCALE, v, overwrite);
    }

    public void setLocale(String v) {
        this.setAttributeValue(ServerTags.LOCALE, v);
    }

    protected String getRelativeXPath() {
        String ret = null;
        ret = "domain";
        return null != ret ? ret.trim() : null;
    }

    public boolean verify() {
        return true;
    }

    public static void addComparator(BeanComparator c) {
        comparators.add(c);
    }

    public static void removeComparator(BeanComparator c) {
        comparators.remove(c);
    }

    public static Domain createGraph(Node doc) {
        return new Domain(doc, Common.NO_DEFAULT_VALUES);
    }

    public static Domain createGraph(InputStream in) {
        return Domain.createGraph(in, false);
    }

    public static Domain createGraph(InputStream in, boolean validate) {
        try {
            Document doc = GraphManager.createXmlDocument((InputStream)in, (boolean)validate);
            return Domain.createGraph(doc);
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new RuntimeException(Common.getMessage((String)"DOMGraphCreateFailed_msg", (Object)t.getMessage()));
        }
    }

    public static Domain createGraph() {
        return new Domain();
    }

    public static String getDefaultAttributeValue(String attr) {
        if (attr == null) {
            return null;
        }
        attr = attr.trim();
        return null;
    }

    private synchronized void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        int MAX_SIZE = 65535;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.write(baos);
        byte[] array = baos.toByteArray();
        int numStrings = array.length / 65535;
        int leftover = array.length % 65535;
        out.writeInt(numStrings + (0 == leftover ? 0 : 1));
        out.writeInt(65535);
        int offset = 0;
        for (int i = 0; i < numStrings; ++i) {
            out.writeUTF(new String(array, offset, 65535));
            offset += 65535;
        }
        if (leftover > 0) {
            int count = array.length - offset;
            out.writeUTF(new String(array, offset, count));
        }
    }

    private synchronized void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.init(comparators, new GenBeans.Version(1, 0, 8));
        int numStrings = in.readInt();
        int max_size = in.readInt();
        StringBuffer sb = new StringBuffer(numStrings * max_size);
        for (int i = 0; i < numStrings; ++i) {
            sb.append(in.readUTF());
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(sb.toString().getBytes());
        Document doc = GraphManager.createXmlDocument((InputStream)bais, (boolean)false);
        this.initOptions(Common.NO_DEFAULT_VALUES);
        this.initFromNode(doc, Common.NO_DEFAULT_VALUES);
    }

    public void dump(StringBuffer str, String indent) {
        int i;
        str.append(indent);
        str.append(APPLICATIONS);
        ConfigBean n = this.getApplications();
        if (n != null) {
            n.dump(str, indent + "\t");
        } else {
            str.append(indent + "\tnull");
        }
        this.dumpAttributes(APPLICATIONS, 0, str, indent);
        str.append(indent);
        str.append(RESOURCES);
        n = this.getResources();
        if (n != null) {
            n.dump(str, indent + "\t");
        } else {
            str.append(indent + "\tnull");
        }
        this.dumpAttributes(RESOURCES, 0, str, indent);
        str.append(indent);
        str.append(CONFIGS);
        n = this.getConfigs();
        if (n != null) {
            n.dump(str, indent + "\t");
        } else {
            str.append(indent + "\tnull");
        }
        this.dumpAttributes(CONFIGS, 0, str, indent);
        str.append(indent);
        str.append(SERVERS);
        n = this.getServers();
        if (n != null) {
            n.dump(str, indent + "\t");
        } else {
            str.append(indent + "\tnull");
        }
        this.dumpAttributes(SERVERS, 0, str, indent);
        str.append(indent);
        str.append(CLUSTERS);
        n = this.getClusters();
        if (n != null) {
            n.dump(str, indent + "\t");
        } else {
            str.append(indent + "\tnull");
        }
        this.dumpAttributes(CLUSTERS, 0, str, indent);
        str.append(indent);
        str.append(NODE_AGENTS);
        n = this.getNodeAgents();
        if (n != null) {
            n.dump(str, indent + "\t");
        } else {
            str.append(indent + "\tnull");
        }
        this.dumpAttributes(NODE_AGENTS, 0, str, indent);
        str.append(indent);
        str.append(LB_CONFIGS);
        n = this.getLbConfigs();
        if (n != null) {
            n.dump(str, indent + "\t");
        } else {
            str.append(indent + "\tnull");
        }
        this.dumpAttributes(LB_CONFIGS, 0, str, indent);
        str.append(indent);
        str.append("SystemProperty[" + this.sizeSystemProperty() + "]");
        for (i = 0; i < this.sizeSystemProperty(); ++i) {
            str.append(indent + "\t");
            str.append("#" + i + ":");
            n = this.getSystemProperty(i);
            if (n != null) {
                n.dump(str, indent + "\t");
            } else {
                str.append(indent + "\tnull");
            }
            this.dumpAttributes(SYSTEM_PROPERTY, i, str, indent);
        }
        str.append(indent);
        str.append("ElementProperty[" + this.sizeElementProperty() + "]");
        for (i = 0; i < this.sizeElementProperty(); ++i) {
            str.append(indent + "\t");
            str.append("#" + i + ":");
            n = this.getElementProperty(i);
            if (n != null) {
                n.dump(str, indent + "\t");
            } else {
                str.append(indent + "\tnull");
            }
            this.dumpAttributes(ELEMENT_PROPERTY, i, str, indent);
        }
    }

    public String dumpBeanNode() {
        StringBuffer str = new StringBuffer();
        str.append("Domain\n");
        this.dump(str, "\n  ");
        return str.toString().trim();
    }
}

