/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans;

import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.StaleWriteConfigException;
import com.sun.enterprise.config.serverbeans.EjbContainerAvailability;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.config.serverbeans.ServerTags;
import com.sun.enterprise.config.serverbeans.WebContainerAvailability;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.Serializable;
import java.util.Vector;
import org.netbeans.modules.schema2beans.BeanComparator;
import org.netbeans.modules.schema2beans.Common;
import org.netbeans.modules.schema2beans.GenBeans;

public class AvailabilityService
extends ConfigBean
implements Serializable {
    static Vector comparators = new Vector();
    public static final String WEB_CONTAINER_AVAILABILITY = "WebContainerAvailability";
    public static final String EJB_CONTAINER_AVAILABILITY = "EjbContainerAvailability";
    public static final String ELEMENT_PROPERTY = "ElementProperty";

    public AvailabilityService() {
        this(Common.USE_DEFAULT_VALUES);
    }

    public AvailabilityService(int options) {
        super(comparators, new GenBeans.Version(1, 0, 8));
        this.createProperty("web-container-availability", WEB_CONTAINER_AVAILABILITY, 66064, WebContainerAvailability.class);
        this.createAttribute(WEB_CONTAINER_AVAILABILITY, "availability-enabled", "AvailabilityEnabled", 513, null, null);
        this.createAttribute(WEB_CONTAINER_AVAILABILITY, "persistence-type", "PersistenceType", 1, null, "memory");
        this.createAttribute(WEB_CONTAINER_AVAILABILITY, "persistence-frequency", "PersistenceFrequency", 513, null, null);
        this.createAttribute(WEB_CONTAINER_AVAILABILITY, "persistence-scope", "PersistenceScope", 513, null, null);
        this.createAttribute(WEB_CONTAINER_AVAILABILITY, "persistence-store-health-check-enabled", "PersistenceStoreHealthCheckEnabled", 1, null, "false");
        this.createAttribute(WEB_CONTAINER_AVAILABILITY, "sso-failover-enabled", "SsoFailoverEnabled", 1, null, "false");
        this.createAttribute(WEB_CONTAINER_AVAILABILITY, "http-session-store-pool-name", "HttpSessionStorePoolName", 513, null, null);
        this.createProperty("ejb-container-availability", EJB_CONTAINER_AVAILABILITY, 66064, EjbContainerAvailability.class);
        this.createAttribute(EJB_CONTAINER_AVAILABILITY, "availability-enabled", "AvailabilityEnabled", 513, null, null);
        this.createAttribute(EJB_CONTAINER_AVAILABILITY, "sfsb-ha-persistence-type", "SfsbHaPersistenceType", 1, null, "ha");
        this.createAttribute(EJB_CONTAINER_AVAILABILITY, "sfsb-persistence-type", "SfsbPersistenceType", 1, null, "file");
        this.createAttribute(EJB_CONTAINER_AVAILABILITY, "sfsb-checkpoint-enabled", "SfsbCheckpointEnabled", 513, null, null);
        this.createAttribute(EJB_CONTAINER_AVAILABILITY, "sfsb-quick-checkpoint-enabled", "SfsbQuickCheckpointEnabled", 513, null, null);
        this.createAttribute(EJB_CONTAINER_AVAILABILITY, "sfsb-store-pool-name", "SfsbStorePoolName", 513, null, null);
        this.createProperty("property", ELEMENT_PROPERTY, 66096, ElementProperty.class);
        this.createAttribute(ELEMENT_PROPERTY, "name", "Name", 257, null, null);
        this.createAttribute(ELEMENT_PROPERTY, "value", "Value", 257, null, null);
        this.initialize(options);
    }

    void initialize(int options) {
    }

    public void setWebContainerAvailability(WebContainerAvailability value) {
        this.setValue(WEB_CONTAINER_AVAILABILITY, value);
    }

    public WebContainerAvailability getWebContainerAvailability() {
        return (WebContainerAvailability)this.getValue(WEB_CONTAINER_AVAILABILITY);
    }

    public void setEjbContainerAvailability(EjbContainerAvailability value) {
        this.setValue(EJB_CONTAINER_AVAILABILITY, value);
    }

    public EjbContainerAvailability getEjbContainerAvailability() {
        return (EjbContainerAvailability)this.getValue(EJB_CONTAINER_AVAILABILITY);
    }

    public void setElementProperty(int index, ElementProperty value) {
        this.setValue(ELEMENT_PROPERTY, index, value);
    }

    public ElementProperty getElementProperty(int index) {
        return (ElementProperty)this.getValue(ELEMENT_PROPERTY, index);
    }

    public void setElementProperty(ElementProperty[] value) {
        this.setValue(ELEMENT_PROPERTY, value);
    }

    public ElementProperty[] getElementProperty() {
        return (ElementProperty[])this.getValues(ELEMENT_PROPERTY);
    }

    public int sizeElementProperty() {
        return this.size(ELEMENT_PROPERTY);
    }

    public int addElementProperty(ElementProperty value) throws ConfigException {
        return this.addElementProperty(value, true);
    }

    public int addElementProperty(ElementProperty value, boolean overwrite) throws ConfigException {
        ElementProperty old = this.getElementPropertyByName(value.getName());
        if (old != null) {
            throw new ConfigException(StringManager.getManager(AvailabilityService.class).getString("cannotAddDuplicate", ELEMENT_PROPERTY));
        }
        return this.addValue(ELEMENT_PROPERTY, value, overwrite);
    }

    public int removeElementProperty(ElementProperty value) {
        return this.removeValue(ELEMENT_PROPERTY, value);
    }

    public int removeElementProperty(ElementProperty value, boolean overwrite) throws StaleWriteConfigException {
        return this.removeValue(ELEMENT_PROPERTY, value, overwrite);
    }

    public ElementProperty getElementPropertyByName(String id) {
        ElementProperty[] o;
        if (null != id) {
            id = id.trim();
        }
        if ((o = this.getElementProperty()) == null) {
            return null;
        }
        for (int i = 0; i < o.length; ++i) {
            if (!o[i].getAttributeValue(Common.convertName((String)ServerTags.NAME)).equals(id)) continue;
            return o[i];
        }
        return null;
    }

    public boolean isAvailabilityEnabled() {
        return AvailabilityService.toBoolean(this.getAttributeValue(ServerTags.AVAILABILITY_ENABLED));
    }

    public void setAvailabilityEnabled(boolean v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.AVAILABILITY_ENABLED, "" + v, overwrite);
    }

    public void setAvailabilityEnabled(boolean v) {
        this.setAttributeValue(ServerTags.AVAILABILITY_ENABLED, "" + v);
    }

    public String getStorePoolName() {
        return this.getAttributeValue(ServerTags.STORE_POOL_NAME);
    }

    public void setStorePoolName(String v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue(ServerTags.STORE_POOL_NAME, v, overwrite);
    }

    public void setStorePoolName(String v) {
        this.setAttributeValue(ServerTags.STORE_POOL_NAME, v);
    }

    protected String getRelativeXPath() {
        String ret = null;
        ret = "availability-service";
        return null != ret ? ret.trim() : null;
    }

    public boolean verify() {
        return true;
    }

    public static void addComparator(BeanComparator c) {
        comparators.add(c);
    }

    public static void removeComparator(BeanComparator c) {
        comparators.remove(c);
    }

    public static String getDefaultAttributeValue(String attr) {
        if (attr == null) {
            return null;
        }
        if ((attr = attr.trim()).equals(ServerTags.AVAILABILITY_ENABLED)) {
            return "true".trim();
        }
        return null;
    }

    public static String getDefaultAvailabilityEnabled() {
        return "true".trim();
    }

    public void dump(StringBuffer str, String indent) {
        str.append(indent);
        str.append(WEB_CONTAINER_AVAILABILITY);
        ConfigBean n = this.getWebContainerAvailability();
        if (n != null) {
            n.dump(str, indent + "\t");
        } else {
            str.append(indent + "\tnull");
        }
        this.dumpAttributes(WEB_CONTAINER_AVAILABILITY, 0, str, indent);
        str.append(indent);
        str.append(EJB_CONTAINER_AVAILABILITY);
        n = this.getEjbContainerAvailability();
        if (n != null) {
            n.dump(str, indent + "\t");
        } else {
            str.append(indent + "\tnull");
        }
        this.dumpAttributes(EJB_CONTAINER_AVAILABILITY, 0, str, indent);
        str.append(indent);
        str.append("ElementProperty[" + this.sizeElementProperty() + "]");
        for (int i = 0; i < this.sizeElementProperty(); ++i) {
            str.append(indent + "\t");
            str.append("#" + i + ":");
            n = this.getElementProperty(i);
            if (n != null) {
                n.dump(str, indent + "\t");
            } else {
                str.append(indent + "\tnull");
            }
            this.dumpAttributes(ELEMENT_PROPERTY, i, str, indent);
        }
    }

    public String dumpBeanNode() {
        StringBuffer str = new StringBuffer();
        str.append("AvailabilityService\n");
        this.dump(str, "\n  ");
        return str.toString().trim();
    }
}

