/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.impl;

import com.sun.enterprise.config.ConfigUpdate;
import com.sun.enterprise.config.impl.ConfigChangeImpl;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class ConfigUpdateImpl
extends ConfigChangeImpl
implements ConfigUpdate,
Serializable {
    private HashMap oldValues = new HashMap();
    private HashMap newValues = new HashMap();

    public ConfigUpdateImpl(String xpath, String attrName, String oldValue, String newValue) {
        this.xpath = xpath;
        this.addChangedAttribute(attrName, oldValue, newValue);
    }

    public String getConfigChangeType() {
        return "update";
    }

    public void addChangedAttribute(String attrName, String oldValue, String newValue) {
        if (this.oldValues.get(attrName) == null) {
            this.oldValues.put(attrName, oldValue);
            this.newValues.put(attrName, newValue);
        } else if (this.oldValues.get(attrName).equals(newValue)) {
            this.oldValues.remove(attrName);
            this.newValues.remove(attrName);
        } else {
            this.newValues.put(attrName, newValue);
        }
    }

    public String getOldValue(String attrName) {
        return (String)this.oldValues.get(attrName);
    }

    public String getNewValue(String attrName) {
        return (String)this.newValues.get(attrName);
    }

    public Set getAttributeSet() {
        return this.oldValues.keySet();
    }

    public void removeAttribute(String attrName) {
        if (attrName == null) {
            throw new IllegalArgumentException("Attribute name is null");
        }
        if (this.oldValues.containsKey(attrName) && this.newValues.containsKey(attrName)) {
            this.oldValues.remove(attrName);
            this.newValues.remove(attrName);
        }
    }

    public String toString() {
        String ret = "update xpath=" + this.xpath + "\n";
        Set s = this.newValues.keySet();
        Iterator iter = s.iterator();
        while (iter.hasNext()) {
            String next = (String)iter.next();
            ret = ret + "\tattr=" + next + "   " + this.oldValues.get(next) + "-->" + this.newValues.get(next) + "\n";
        }
        return ret;
    }

    public String getName() {
        return null;
    }
}

