/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.verifier.tests;

import com.sun.enterprise.admin.verifier.Result;
import com.sun.enterprise.admin.verifier.ServerCheck;
import com.sun.enterprise.admin.verifier.ServerXmlTest;
import com.sun.enterprise.admin.verifier.tests.StaticTest;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigContextEvent;
import com.sun.enterprise.config.serverbeans.JmsHost;
import com.sun.enterprise.config.serverbeans.ServerTags;
import com.sun.logging.LogDomains;
import java.util.logging.Logger;

public class JmsServiceTest
extends ServerXmlTest
implements ServerCheck {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.tools.verifier");

    public Result check(ConfigContext context) {
        Result result = super.getInitializedResult();
        return result;
    }

    public Result check(ConfigContextEvent ccce) {
        Result result = new Result();
        Object value = ccce.getObject();
        String beanName = ccce.getBeanName();
        if (beanName != null) {
            String name = ccce.getName();
            return this.testSave(name, (String)value);
        }
        JmsHost jms = (JmsHost)value;
        String httpPort = jms.getPort();
        try {
            if (StaticTest.isPortValid(Integer.parseInt(httpPort))) {
                result.passed("Valid Port");
            } else {
                result.failed("Invalid JMSService Port : " + httpPort);
            }
        }
        catch (NumberFormatException e) {
            result.failed("Invalid JMSService Port Number : " + httpPort);
        }
        return result;
    }

    public Result testSave(String name, String value) {
        Result result = new Result();
        result.passed("Passed");
        if (name.equals(ServerTags.PORT)) {
            try {
                if (StaticTest.isPortValid(Integer.parseInt(value))) {
                    result.passed("Valid Port");
                } else {
                    result.failed("Invalid Port");
                }
            }
            catch (NumberFormatException e) {
                result.failed("Bad Number");
            }
        }
        if (name.equals(ServerTags.INIT_TIMEOUT_IN_SECONDS)) {
            try {
                if (Integer.parseInt(value) < 0) {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".initTimeoutNegative", "Init Timeout cannot be negative number"));
                } else {
                    result.passed("Passed **");
                }
            }
            catch (NumberFormatException e) {
                result.failed(this.smh.getLocalString(this.getClass().getName() + ".initTimeoutInvalid", "Init Timeout : invalid number"));
            }
        }
        return result;
    }
}

