/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.verifier.tests;

import com.sun.enterprise.admin.verifier.Result;
import com.sun.enterprise.admin.verifier.ServerCheck;
import com.sun.enterprise.admin.verifier.ServerXmlTest;
import com.sun.enterprise.admin.verifier.tests.StaticTest;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigContextEvent;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.HttpListener;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.ServerTags;
import com.sun.enterprise.config.serverbeans.VirtualServer;
import com.sun.logging.LogDomains;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import java.util.logging.Logger;

public class HttpListenerTest
extends ServerXmlTest
implements ServerCheck {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.tools.verifier");
    private static final String DELIMITER = ",";
    protected HttpListener thisListener;

    public Result check(ConfigContext context) {
        Result result = super.getInitializedResult();
        return result;
    }

    public Result check(ConfigContextEvent ccce) {
        HttpListener http;
        Result result = new Result();
        Object value = ccce.getObject();
        ConfigContext context = ccce.getConfigContext();
        String beanName = ccce.getBeanName();
        if (beanName != null) {
            String name = ccce.getName();
            result = this.testSave(name, (String)value, context);
            return result;
        }
        this.thisListener = http = (HttpListener)value;
        if (ccce.getChoice().equals("DELETE")) {
            try {
                Config config = StaticTest.getConfig(context);
                if (config != null) {
                    HttpService service = config.getHttpService();
                    VirtualServer[] vs = service.getVirtualServer();
                    for (int i = 0; vs != null && i < vs.length; ++i) {
                        String httpListener = vs[i].getHttpListeners();
                        if (httpListener == null) continue;
                        StringTokenizer st = new StringTokenizer(httpListener, DELIMITER);
                        StringBuffer newHttpListener = new StringBuffer("");
                        String token = "";
                        while (st.hasMoreTokens()) {
                            token = st.nextToken();
                            if (!token.equals(this.thisListener.getId())) continue;
                            result.failed("This listener is being referenced by some virtual server. Please remove the reference and try again.");
                            return result;
                        }
                    }
                    result.passed("Test passed for referential integrity");
                }
            }
            catch (Exception e) {
                result.failed("Exception Caught : " + e.getMessage());
            }
            return result;
        }
        String id = http.getId();
        if (!StaticTest.checkObjectName(id, result)) {
            result.failed("Http Listener ID Invalid ");
            return result;
        }
        result.passed("Valid Object Name");
        try {
            if (!StaticTest.isPortValid(Integer.parseInt(http.getPort()))) {
                result.failed("Invalid Port Number");
                return result;
            }
            result.passed("passed ***");
            String port = http.getPort();
            if (ccce.getChoice().equals("ADD") && this.isPortUsed(port, context, result)) {
                return result;
            }
        }
        catch (NumberFormatException e) {
            result.failed("Number Format Exception");
            return result;
        }
        String httpAddress = http.getAddress();
        try {
            if (httpAddress == null || httpAddress.equals("")) {
                result.failed("Http Address cannot be Null value");
                return result;
            }
            if (StaticTest.checkAddress(httpAddress)) {
                InetAddress.getByName(httpAddress).getHostName();
            }
            result.passed("Valid Http Listener IP Address");
        }
        catch (UnknownHostException e) {
            result.failed("Host name not resolvable - " + httpAddress);
            return result;
        }
        String virtualServer = http.getDefaultVirtualServer();
        try {
            Config config = StaticTest.getConfig(context);
            if (config != null) {
                boolean exists = this.checkVSExists(virtualServer, config);
                if (exists) {
                    result.passed("Virtual Server found in vs class");
                } else {
                    result.failed("Virtual Server not found in vs class");
                }
            }
        }
        catch (Exception e) {
            result.failed("Virtual Server specified not available ");
        }
        return result;
    }

    public Result testSave(String name, String value, ConfigContext context) {
        Result result = new Result();
        result.passed("Passed ");
        if (name.equals(ServerTags.ADDRESS)) {
            try {
                if (value == null || value.equals("")) {
                    result.failed("Http Address cannot be Null");
                    return result;
                }
                if (StaticTest.checkAddress(value)) {
                    InetAddress.getByName(value).getHostName();
                }
                result.passed("Valid Http Listener IP Address");
            }
            catch (UnknownHostException e) {
                result.failed("Host name not resolvable - " + value);
            }
        }
        if (name.equals(ServerTags.PORT)) {
            try {
                if (StaticTest.isPortValid(Integer.parseInt(value))) {
                    result.passed("passed ***");
                } else {
                    result.failed("Invalid Port Number");
                }
            }
            catch (NumberFormatException e) {
                result.failed("Number Format Exception");
            }
        }
        return result;
    }

    private boolean checkVSExists(String vsID, Config config) {
        VirtualServer vs = config.getHttpService().getVirtualServerById(vsID);
        return vs != null;
    }

    public boolean isPortUsed(String port, ConfigContext context, Result result) {
        boolean flag;
        block3: {
            result.passed("...");
            flag = false;
            try {
                Config config = StaticTest.getConfig(context);
                if (config == null) break block3;
                HttpListener[] httpListener = config.getHttpService().getHttpListener();
                for (int i = 0; i < httpListener.length; ++i) {
                    if (this.thisListener.getId().equals(httpListener[i].getId()) || !port.equals(httpListener[i].getPort()) || !this.thisListener.getAddress().equals(httpListener[i].getAddress())) continue;
                    flag = true;
                    result.failed("Port Already In Use by : " + httpListener[i].getId());
                    break;
                }
            }
            catch (Exception e) {
                result.failed("Exception Caught : " + e.getMessage());
            }
        }
        return flag;
    }
}

