/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.verifier.tests;

import com.sun.enterprise.admin.verifier.Result;
import com.sun.enterprise.admin.verifier.ServerCheck;
import com.sun.enterprise.admin.verifier.ServerXmlTest;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigContextEvent;
import com.sun.enterprise.config.serverbeans.ServerTags;
import com.sun.logging.LogDomains;
import java.util.logging.Logger;

public class EjbContainerTest
extends ServerXmlTest
implements ServerCheck {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.tools.verifier");
    static int ejbSteadyQty = 0;
    static int ejbMaxCacheSize = 0;
    static int ejbResizeQty = 0;

    public Result check(ConfigContext context) {
        Result result = super.getInitializedResult();
        return result;
    }

    public Result check(ConfigContextEvent ccce) {
        Object value = ccce.getObject();
        ConfigContext context = ccce.getConfigContext();
        Result result = new Result();
        result.passed("Passed ** ");
        String beanName = ccce.getBeanName();
        if (beanName != null) {
            String name = ccce.getName();
            if (name != null && value != null) {
                result = this.validateAttribute(name, (String)value);
            }
            return result;
        }
        return result;
    }

    public Result validateAttribute(String name, String value) {
        Result result = new Result();
        boolean isFailed = false;
        result.passed("Passed **");
        if (name.equals(ServerTags.STEADY_POOL_SIZE)) {
            try {
                int steadyQty = Integer.parseInt(value);
                if (steadyQty < 0) {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".steadyPoolNegative", "Steady Pool size cannot be a negative number"));
                    isFailed = true;
                } else {
                    result.passed("Passed ***");
                    ejbSteadyQty = steadyQty;
                }
            }
            catch (NumberFormatException e) {
                result.failed(this.smh.getLocalString(this.getClass().getName() + ".steadyPoolInvalid", "Steady Pool Size : invalid number"));
                isFailed = true;
            }
        }
        if (name.equals(ServerTags.MAX_POOL_SIZE)) {
            try {
                int maxQty = Integer.parseInt(value);
                if (maxQty < 0) {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".maxPoolNegative", "Max Pool Size cannot be a negative number"));
                    isFailed = true;
                } else if (maxQty < ejbSteadyQty) {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".steadyPoolMaxPoolError", "Steady Pool Size should be less than or equal to Maximum Pool Size"));
                    isFailed = true;
                } else if (maxQty < ejbResizeQty) {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".resizePoolMaxPoolError", "Pool Resize Qty should be less than or equal to Maximum Pool Size"));
                    isFailed = true;
                } else {
                    result.passed("Passed ***");
                }
            }
            catch (NumberFormatException e) {
                result.failed(this.smh.getLocalString(this.getClass().getName() + ".maxPoolInvalid", "Max. Pool Size : invalid number "));
                isFailed = true;
            }
        }
        if (name.equals(ServerTags.POOL_RESIZE_QUANTITY)) {
            try {
                int resizeQty = Integer.parseInt(value);
                if (resizeQty < 0) {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".resizeQtyNegative", "Pool resize quantity cannot be negative number"));
                    isFailed = true;
                } else {
                    result.passed("Passed ***");
                    ejbResizeQty = resizeQty;
                }
            }
            catch (NumberFormatException e) {
                result.failed(this.smh.getLocalString(this.getClass().getName() + ".resizeQtyInvalid", "Pool Resize Quantity : invalid number "));
                isFailed = true;
            }
        }
        if (name.equals(ServerTags.POOL_IDLE_TIMEOUT_IN_SECONDS)) {
            try {
                if (Integer.parseInt(value) < 0) {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".idleTimeoutNegative", "Pool Idle Timeout cannot be negative number"));
                    isFailed = true;
                } else {
                    result.passed("Passed ***");
                }
            }
            catch (NumberFormatException e) {
                result.failed(this.smh.getLocalString(this.getClass().getName() + ".idleTimeoutInvalid", "Pool Idle timeout : invalid number"));
                isFailed = true;
            }
        }
        if (name.equals(ServerTags.MAX_CACHE_SIZE)) {
            try {
                int maxCache = Integer.parseInt(value);
                if (maxCache < 0) {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".maxCacheNegative", "Max Cache Size cannot be negative number"));
                    isFailed = true;
                } else {
                    result.passed("Passed ***");
                    ejbMaxCacheSize = maxCache;
                }
            }
            catch (NumberFormatException e) {
                result.failed(this.smh.getLocalString(this.getClass().getName() + ".maxCacheInvalid", "Max Cache Size  : invalid number "));
                isFailed = true;
            }
        }
        if (name.equals(ServerTags.CACHE_RESIZE_QUANTITY)) {
            try {
                int cacheResize = Integer.parseInt(value);
                if (Integer.parseInt(value) < 0) {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".cacheResizeNegative", "Cache Resize Qty cannot be negative number"));
                    isFailed = true;
                } else if (cacheResize > ejbMaxCacheSize) {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".cacheResizeMaxCacheError", "Cache Resize Quantity should be less than or equal to Maximum Cache Size"));
                    isFailed = true;
                } else {
                    result.passed("Passed ***");
                }
            }
            catch (NumberFormatException e) {
                result.failed(this.smh.getLocalString(this.getClass().getName() + ".cacheResizeInvalid", "Cache Resize Qty : invalid number "));
                isFailed = true;
            }
        }
        if (name.equals(ServerTags.REMOVAL_TIMEOUT_IN_SECONDS)) {
            try {
                if (Integer.parseInt(value) < 0) {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".removalTimeNegative", "Removal Timeout cannot be negative number"));
                    isFailed = true;
                } else {
                    result.passed("Passed ***");
                }
            }
            catch (NumberFormatException e) {
                result.failed(this.smh.getLocalString(this.getClass().getName() + ".removalTimeInvalid", "Removal Timeout : invalid number"));
                isFailed = true;
            }
        }
        if (name.equals(ServerTags.CACHE_IDLE_TIMEOUT_IN_SECONDS)) {
            try {
                if (Integer.parseInt(value) < 0) {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".cacheIdleTimeoutNegative", "Cache Idle Timeout cannot be negative number"));
                    isFailed = true;
                } else {
                    result.passed("Passed ***");
                }
            }
            catch (NumberFormatException e) {
                result.failed(this.smh.getLocalString(this.getClass().getName() + ".cacheIdleTimeoutInvalid", "Cache Idle Timeout  : invalid number "));
                isFailed = true;
            }
        }
        if (isFailed) {
            result.setStatus(1);
        }
        return result;
    }
}

