/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.target;

import com.sun.enterprise.admin.target.ClusterTarget;
import com.sun.enterprise.admin.target.ConfigTarget;
import com.sun.enterprise.admin.target.DASTarget;
import com.sun.enterprise.admin.target.DomainTarget;
import com.sun.enterprise.admin.target.NodeAgentTarget;
import com.sun.enterprise.admin.target.ServerTarget;
import com.sun.enterprise.admin.target.Target;
import com.sun.enterprise.admin.target.TargetFactory;
import com.sun.enterprise.admin.target.TargetType;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.ClusterHelper;
import com.sun.enterprise.config.serverbeans.ConfigAPIHelper;
import com.sun.enterprise.config.serverbeans.NodeAgentHelper;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.config.serverbeans.ServerTags;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.server.pluggable.PluggableFeatureFactory;
import com.sun.enterprise.util.i18n.StringManager;

public class TargetBuilder {
    public static TargetBuilder INSTANCE;
    private static final StringManager strMgr;
    private static final String XPATH_CONFIG_PREFIX;
    private static final String XPATH_SERVER_PREFIX;
    private static final String XPATH_CLUSTER_PREFIX;
    private static final String XPATH_NODE_AGENT_PREFIX;
    private static final String XPATH_DOMAIN_PREFIX;
    private static final String XPATH_APPLICATIONS_PREFIX;
    private static final String XPATH_RESOURCES_PREFIX;

    public Target createTarget(String name, ConfigContext domainContext) throws ConfigException {
        return this.createTarget(null, this.getDefaultValidTargets(), name, domainContext);
    }

    protected TargetType[] getDefaultValidTargets() {
        return new TargetType[]{TargetType.DAS};
    }

    public Target createTarget(TargetType[] validTypes, String name, ConfigContext domainContext) throws ConfigException {
        return this.createTarget(null, validTypes, name, domainContext);
    }

    public Target createTarget(String defaultTargetName, String name, ConfigContext domainContext) throws ConfigException {
        return this.createTarget(defaultTargetName, this.getDefaultValidTargets(), name, domainContext);
    }

    public Target createTarget(String defaultTargetName, TargetType[] validTypes, String name, ConfigContext domainContext) throws ConfigException {
        this.checkArg(domainContext, strMgr.getString("target.config_context"));
        if (name == null || "".equals(name) || "null".equals(name)) {
            name = defaultTargetName == null || "".equals(defaultTargetName) ? this.getDefaultTarget(domainContext) : defaultTargetName;
        }
        TargetType type = this.getTargetType(name, domainContext);
        this.validateTargetType(validTypes, type, name, domainContext);
        Target target = null;
        if (type == TargetType.DAS) {
            target = new DASTarget(name, domainContext);
        } else if (type == TargetType.SERVER) {
            target = new ServerTarget(name, domainContext);
        } else if (type == TargetType.DOMAIN) {
            target = new DomainTarget(name, domainContext);
        } else if (type == TargetType.CONFIG) {
            target = new ConfigTarget(name, domainContext);
        } else if (type == TargetType.CLUSTER) {
            target = new ClusterTarget(name, domainContext);
        } else if (type == TargetType.NODE_AGENT) {
            target = new NodeAgentTarget(name, domainContext);
        } else {
            throw new ConfigException(strMgr.getString("target.cant_determine_type", name));
        }
        return target;
    }

    private void validateTargetType(TargetType[] validTypes, TargetType targetType, String targetName, ConfigContext domainContext) throws ConfigException {
        if (validTypes != null) {
            boolean isValid = false;
            String validTargets = new String();
            for (int i = 0; i < validTypes.length; ++i) {
                if (targetType == validTypes[i]) {
                    isValid = true;
                } else if (targetType == TargetType.SERVER) {
                    if (validTypes[i] == TargetType.STANDALONE_SERVER) {
                        if (ServerHelper.isServerStandAlone(domainContext, targetName)) {
                            isValid = true;
                        }
                    } else if (validTypes[i] == TargetType.UNCLUSTERED_SERVER && !ServerHelper.isServerClustered(domainContext, targetName)) {
                        isValid = true;
                    }
                } else if (targetType == TargetType.CLUSTER && validTypes[i] == TargetType.STANDALONE_CLUSTER && ClusterHelper.isClusterStandAlone(domainContext, targetName)) {
                    isValid = true;
                }
                validTargets = validTargets + validTypes[i].getName();
                if (i >= validTypes.length - 1) continue;
                validTargets = validTargets + ", ";
            }
            if (!isValid) {
                throw new ConfigException(strMgr.getString("target.invalid_type", targetName, targetType.getName(), validTargets));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private TargetType getTargetType(String targetName, ConfigContext domainContext) throws ConfigException {
        void var3_3;
        TargetType targetType;
        if (targetName.equals("domain")) {
            targetType = TargetType.DOMAIN;
        } else if (ConfigAPIHelper.isAConfig(domainContext, targetName)) {
            targetType = TargetType.CONFIG;
        } else if (ServerHelper.isAServer(domainContext, targetName)) {
            targetType = ServerHelper.isDAS(domainContext, targetName) ? TargetType.DAS : TargetType.SERVER;
        } else if (ClusterHelper.isACluster(domainContext, targetName)) {
            targetType = TargetType.CLUSTER;
        } else if (NodeAgentHelper.isANodeAgent(domainContext, targetName)) {
            targetType = TargetType.NODE_AGENT;
        } else {
            throw new ConfigException(strMgr.getString("target.cant_determine_type", targetName));
        }
        return var3_3;
    }

    protected String getDefaultTarget(ConfigContext cc) throws ConfigException {
        Server[] servers = ServerHelper.getServersInDomain(cc);
        if (servers.length > 0) {
            return servers[0].getName();
        }
        throw new ConfigException(strMgr.getString("target.no_servers"));
    }

    private void checkArg(Object o, Object name) {
        if (null == o) {
            throw new IllegalArgumentException(strMgr.getString("target.cant_be_null", name.toString()));
        }
    }

    private static String[] extractElementNameAndTypeForPrefix(String xpath, String prefix) throws ConfigException {
        if ((xpath = xpath.trim()) != null && xpath.startsWith(prefix) && xpath.endsWith("']")) {
            int idx = (xpath = xpath.substring(prefix.length(), xpath.length() - 2)).lastIndexOf(91);
            if (idx < 0) {
                return null;
            }
            String type = xpath.substring(0, idx);
            if (type.indexOf(39) >= 0) {
                return null;
            }
            if ((idx = xpath.indexOf(39, idx)) < 0) {
                return null;
            }
            String key = xpath.substring(idx + 1);
            if (key.indexOf(39) >= 0) {
                return null;
            }
            return new String[]{key, type};
        }
        return null;
    }

    private static String extractElementNameForPrefix(String xpath, String prefix) throws ConfigException {
        int beg;
        int end;
        String name = null;
        if (xpath != null && xpath.startsWith(prefix) && prefix.endsWith("'") && (end = xpath.indexOf("'", beg = prefix.length())) >= 0) {
            name = xpath.substring(beg, end);
        }
        return name;
    }

    private Target testForPrefix(String xpath, String prefix, TargetType type, ConfigContext domainContext) throws ConfigException {
        if (xpath != null && xpath.startsWith(prefix)) {
            String name = TargetBuilder.extractElementNameForPrefix(xpath, prefix);
            return this.createTarget(type.getName(), null, name, domainContext);
        }
        return null;
    }

    public Target createTargetForXPath(String xpath, ConfigContext domainContext) throws ConfigException {
        Target target = null;
        target = this.testForPrefix(xpath, XPATH_CONFIG_PREFIX, TargetType.CONFIG, domainContext);
        if (target != null || (target = this.testForPrefix(xpath, XPATH_SERVER_PREFIX, TargetType.SERVER, domainContext)) != null || (target = this.testForPrefix(xpath, XPATH_CLUSTER_PREFIX, TargetType.CLUSTER, domainContext)) != null || (target = this.testForPrefix(xpath, XPATH_NODE_AGENT_PREFIX, TargetType.NODE_AGENT, domainContext)) != null || (target = this.testForPrefix(xpath, XPATH_DOMAIN_PREFIX, TargetType.DOMAIN, domainContext)) != null) {
            return target;
        }
        return null;
    }

    public String getTargetNameForXPath(String xpath, ConfigContext ctx, boolean bIncludingAppAndRes) throws ConfigException {
        if (bIncludingAppAndRes) {
            String[] pair = null;
            pair = TargetBuilder.extractElementNameAndTypeForPrefix(xpath, XPATH_APPLICATIONS_PREFIX);
            if (pair != null) {
                return ServerTags.APPLICATIONS + "|" + pair[0] + "|" + pair[1];
            }
            pair = TargetBuilder.extractElementNameAndTypeForPrefix(xpath, XPATH_RESOURCES_PREFIX);
            if (pair != null) {
                return ServerTags.RESOURCES + "|" + pair[0] + "|" + pair[1];
            }
        }
        Target target = this.createTargetForXPath(xpath, ctx);
        return target.getName();
    }

    static {
        PluggableFeatureFactory featureFactory = ApplicationServer.getServerContext().getPluggableFeatureFactory();
        TargetFactory tFactory = featureFactory.getTargetFactory();
        INSTANCE = tFactory.getTargetBuilder();
        strMgr = StringManager.getManager(TargetBuilder.class);
        XPATH_CONFIG_PREFIX = "/" + ServerTags.DOMAIN + "/" + ServerTags.CONFIGS + "/" + ServerTags.CONFIG + "[@" + ServerTags.NAME + "='";
        XPATH_SERVER_PREFIX = "/" + ServerTags.DOMAIN + "/" + ServerTags.SERVERS + "/" + ServerTags.SERVER + "[@" + ServerTags.NAME + "='";
        XPATH_CLUSTER_PREFIX = "/" + ServerTags.DOMAIN + "/" + ServerTags.CLUSTERS + "/" + ServerTags.CLUSTER + "[@" + ServerTags.NAME + "='";
        XPATH_NODE_AGENT_PREFIX = "/" + ServerTags.DOMAIN + "/" + ServerTags.NODE_AGENTS + "/" + ServerTags.NODE_AGENT + "[@" + ServerTags.NAME + "='";
        XPATH_DOMAIN_PREFIX = "/" + ServerTags.DOMAIN + "/";
        XPATH_APPLICATIONS_PREFIX = "/" + ServerTags.DOMAIN + "/" + ServerTags.APPLICATIONS + "/";
        XPATH_RESOURCES_PREFIX = "/" + ServerTags.DOMAIN + "/" + ServerTags.RESOURCES + "/";
    }
}

