/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermodel.tester;

import com.sun.enterprise.admin.servermodel.AppServerInstance;
import com.sun.enterprise.admin.servermodel.ServerInstanceManager;
import com.sun.enterprise.admin.servermodel.beans.DeployedApplicationComponentBean;
import com.sun.enterprise.admin.servermodel.beans.DeployedWebModuleComponentBean;
import com.sun.enterprise.admin.servermodel.tester.SOMTester;
import com.sun.enterprise.admin.servermodel.util.ServerModelIterator;

public class ListServletsTester
extends SOMTester {
    static final String USAGE_STRING = "Usage : ListServletsTester --standalone <instance-name> <module-name> <app-name>";

    public ListServletsTester() {
        super("Servlet Tester");
    }

    public static String getUsageString() {
        return USAGE_STRING;
    }

    public int execute(String[] params) throws Exception {
        if (params.length < 3) {
            this.getWriter().println(ListServletsTester.getUsageString());
            return -1;
        }
        AppServerInstance server = this.getServerInstance(params[0]);
        boolean isStandAlone = this.isStandAloneModule(params);
        DeployedWebModuleComponentBean module = null;
        if (isStandAlone) {
            module = server.getDeployedWebModule(params[2]);
        } else {
            DeployedApplicationComponentBean app = server.getDeployedApplication(params[2]);
            module = app.getWebModule(params[1]);
        }
        this.listServlets(module);
        return 0;
    }

    private AppServerInstance getServerInstance(String name) throws Exception {
        ServerInstanceManager sim = this.getServerInstanceManager("surya10.red.iplanet.com", 8888, "admin", "password");
        AppServerInstance si = sim.getServerInstance(name);
        return si;
    }

    private void listServlets(DeployedWebModuleComponentBean module) throws Exception {
        ServerModelIterator it = module.getServlets();
        while (it.hasNext()) {
            this.getWriter().println("Servlet = " + it.next());
        }
    }

    private boolean isStandAloneModule(String[] params) {
        boolean isStandAlone = false;
        for (int i = 0; i < params.length; ++i) {
            if (!params[i].equalsIgnoreCase("--standalone")) continue;
            isStandAlone = true;
            break;
        }
        return isStandAlone;
    }

    public static void main(String[] args) throws Exception {
        new ListServletsTester().execute(args);
    }
}

