/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermodel.tester;

import com.sun.enterprise.admin.servermodel.AppServerInstance;
import com.sun.enterprise.admin.servermodel.ServerInstanceManager;
import com.sun.enterprise.admin.servermodel.tester.SOMTester;
import com.sun.enterprise.admin.servermodel.util.ServerModelIterator;
import com.sun.enterprise.admin.util.SOMLocalStringsManager;

public class ListResourcesTester
extends SOMTester {
    static final String USAGE_STRING = "Usage : ListResourcesTester <instance-name> <res-type>(persistence|jndi|jdbc|mail|custom|jms)";
    private static SOMLocalStringsManager localizedStrMgr = SOMLocalStringsManager.getManager(ListResourcesTester.class);

    public ListResourcesTester() {
        super("j2ee resource tester");
    }

    public static String getUsageString() {
        return USAGE_STRING;
    }

    public int execute(String[] params) throws Exception {
        if (params.length != 2) {
            this.getWriter().println(ListResourcesTester.getUsageString());
            return -1;
        }
        this.checkResourceType(params[1]);
        this.listResources(params[0], params[1]);
        return 0;
    }

    public static void main(String[] args) throws Exception {
        new ListResourcesTester().execute(args);
    }

    private void checkResourceType(String resType) throws Exception {
        if (!(resType.equals("persistence") || resType.equals("custom") || resType.equals("jndi") || resType.equals("jdbc") || resType.equals("jms") || resType.equals("mail"))) {
            String msg = localizedStrMgr.getString("admin.servermodel.tester.invalid_resource_type");
            throw new Exception(msg);
        }
    }

    private void listResources(String instanceName, String resourceType) throws Exception {
        ServerModelIterator it = null;
        ServerInstanceManager sim = this.getServerInstanceManager("surya10.red.iplanet.com", 8888, "admin", "password");
        AppServerInstance si = sim.getServerInstance(instanceName);
        if (resourceType.equals("persistence")) {
            it = si.getPersistenceManagerFactoryResources();
        } else if (resourceType.equals("jndi")) {
            it = si.getJNDIResources();
        } else if (resourceType.equals("jdbc")) {
            it = si.getJDBCResources();
        } else if (resourceType.equals("custom")) {
            it = si.getCustomResources();
        } else if (resourceType.equals("jms")) {
            it = si.getJMSResources();
        } else if (resourceType.equals("mail")) {
            it = si.getJavaMailResources();
        }
        if (it != null) {
            while (it.hasNext()) {
                this.getWriter().println(it.next());
            }
        }
    }
}

